/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.security.GeneralSecurityException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.Decryptor;
import org.apache.hadoop.crypto.Encryptor;
import org.apache.hadoop.crypto.JceCtrCryptoCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class JceSm4CtrCryptoCodec
extends JceCtrCryptoCodec {
    private static final Logger LOG = LoggerFactory.getLogger(JceSm4CtrCryptoCodec.class.getName());

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public CipherSuite getCipherSuite() {
        return CipherSuite.SM4_CTR_NOPADDING;
    }

    @Override
    public void calculateIV(byte[] initIV, long counter, byte[] iv) {
        super.calculateIV(initIV, counter, iv, this.getCipherSuite().getAlgorithmBlockSize());
    }

    @Override
    public Encryptor createEncryptor() throws GeneralSecurityException {
        return new JceCtrCryptoCodec.JceCtrCipher(1, this.getProvider(), this.getCipherSuite(), "SM4");
    }

    @Override
    public Decryptor createDecryptor() throws GeneralSecurityException {
        return new JceCtrCryptoCodec.JceCtrCipher(2, this.getProvider(), this.getCipherSuite(), "SM4");
    }
}

