/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.security.GeneralSecurityException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.base64;
import org.xbill.DNS.utils.hexdump;

public class TSIG {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TSIG.class);
    public static final Name GSS_TSIG = Name.fromConstantString("gss-tsig.");
    public static final Name HMAC_MD5;
    @Deprecated
    public static final Name HMAC;
    public static final Name HMAC_SHA1;
    public static final Name HMAC_SHA224;
    public static final Name HMAC_SHA256;
    public static final Name HMAC_SHA384;
    public static final Name HMAC_SHA512;
    private static final Map<Name, String> algMap;
    public static final Duration FUDGE;
    private final Name alg;
    private final Clock clock;
    private final Name name;
    private final SecretKey macKey;
    private final String macAlgorithm;
    private final Mac sharedHmac;

    public static Name algorithmToName(String alg) {
        if (alg == null) {
            throw new IllegalArgumentException("Null algorithm");
        }
        if (alg.equalsIgnoreCase("HMAC-MD5") || alg.equalsIgnoreCase("HMAC-MD5.")) {
            return HMAC_MD5;
        }
        return algMap.keySet().stream().filter(n -> n.toString().equalsIgnoreCase(alg) || n.toString(true).equalsIgnoreCase(alg)).findAny().orElseGet(() -> algMap.entrySet().stream().filter(e -> ((String)e.getValue()).equalsIgnoreCase(alg)).map(Map.Entry::getKey).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown algorithm: " + alg)));
    }

    @Deprecated
    public static String nameToAlgorithm(Name name) {
        String alg = algMap.get(name);
        if (alg != null) {
            return alg;
        }
        throw new IllegalArgumentException("Unknown algorithm: " + name);
    }

    private static boolean verify(byte[] expected, byte[] signature) {
        if (signature.length < expected.length) {
            byte[] truncated = new byte[signature.length];
            System.arraycopy(expected, 0, truncated, 0, truncated.length);
            expected = truncated;
        }
        return Arrays.equals(signature, expected);
    }

    private Mac initHmac() {
        if (this.sharedHmac != null) {
            try {
                return (Mac)this.sharedHmac.clone();
            }
            catch (CloneNotSupportedException e) {
                this.sharedHmac.reset();
                return this.sharedHmac;
            }
        }
        try {
            Mac mac = Mac.getInstance(this.macAlgorithm);
            mac.init(this.macKey);
            return mac;
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalArgumentException("Caught security exception setting up HMAC.", ex);
        }
    }

    public TSIG(Name algorithm, Name name, String key) {
        this(algorithm, name, Objects.requireNonNull(base64.fromString(key)));
    }

    public TSIG(Name algorithm, Name name, byte[] keyBytes) {
        this(algorithm, name, new SecretKeySpec(keyBytes, TSIG.nameToAlgorithm(algorithm)));
    }

    public TSIG(Name algorithm, Name name, SecretKey key) {
        this(algorithm, name, key, Clock.systemUTC());
    }

    public TSIG(Name algorithm, Name name, SecretKey key, Clock clock) {
        this.name = name;
        this.alg = algorithm;
        this.clock = clock;
        this.macAlgorithm = TSIG.nameToAlgorithm(algorithm);
        this.macKey = key;
        this.sharedHmac = null;
    }

    @Deprecated
    public TSIG(Mac mac, Name name) {
        this.name = name;
        this.sharedHmac = mac;
        this.macAlgorithm = null;
        this.macKey = null;
        this.clock = Clock.systemUTC();
        this.alg = TSIG.algorithmToName(mac.getAlgorithm());
    }

    @Deprecated
    public TSIG(Name name, byte[] key) {
        this(HMAC_MD5, name, key);
    }

    public TSIG(Name algorithm, String name, String key) {
        byte[] keyBytes = base64.fromString(key);
        if (keyBytes == null) {
            throw new IllegalArgumentException("Invalid TSIG key string");
        }
        try {
            this.name = Name.fromString(name, Name.root);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException("Invalid TSIG key name");
        }
        this.alg = algorithm;
        this.clock = Clock.systemUTC();
        this.macAlgorithm = TSIG.nameToAlgorithm(algorithm);
        this.sharedHmac = null;
        this.macKey = new SecretKeySpec(keyBytes, this.macAlgorithm);
    }

    public TSIG(String algorithm, String name, String key) {
        this(TSIG.algorithmToName(algorithm), name, key);
    }

    @Deprecated
    public TSIG(String name, String key) {
        this(HMAC_MD5, name, key);
    }

    @Deprecated
    public static TSIG fromString(String str) {
        String[] parts = str.split("[:/]", 3);
        switch (parts.length) {
            case 2: {
                return new TSIG(HMAC_MD5, parts[0], parts[1]);
            }
            case 3: {
                return new TSIG(parts[0], parts[1], parts[2]);
            }
        }
        throw new IllegalArgumentException("Invalid TSIG key specification");
    }

    public TSIGRecord generate(Message m4, byte[] b, int error, TSIGRecord old) {
        return this.generate(m4, b, error, old, true);
    }

    public TSIGRecord generate(Message m4, byte[] b, int error, TSIGRecord old, boolean fullSignature) {
        Mac hmac = null;
        if (error == 0 || error == 18 || error == 22) {
            hmac = this.initHmac();
        }
        return this.generate(m4, b, error, old, fullSignature, hmac);
    }

    private TSIGRecord generate(Message m4, byte[] b, int error, TSIGRecord old, boolean fullSignature, Mac hmac) {
        byte[] signature;
        boolean signing;
        Instant timeSigned = this.getTimeSigned(error, old);
        Duration fudge = TSIG.getTsigFudge();
        boolean bl = signing = hmac != null;
        if (old != null && signing) {
            TSIG.hmacAddSignature(hmac, old);
        }
        if (signing) {
            if (log.isTraceEnabled()) {
                log.trace(hexdump.dump("TSIG-HMAC rendered message", b));
            }
            hmac.update(b);
        }
        DNSOutput out = new DNSOutput();
        if (fullSignature) {
            this.name.toWireCanonical(out);
            out.writeU16(255);
            out.writeU32(0L);
            this.alg.toWireCanonical(out);
        }
        TSIG.writeTsigTimerVariables(timeSigned, fudge, out);
        if (fullSignature) {
            out.writeU16(error);
            out.writeU16(0);
        }
        if (signing) {
            byte[] tsigVariables = out.toByteArray();
            if (log.isTraceEnabled()) {
                log.trace(hexdump.dump("TSIG-HMAC variables", tsigVariables));
            }
            signature = hmac.doFinal(tsigVariables);
        } else {
            signature = new byte[]{};
        }
        byte[] other = null;
        if (error == 18) {
            out = new DNSOutput(6);
            TSIG.writeTsigTime(this.clock.instant(), out);
            other = out.toByteArray();
        }
        return new TSIGRecord(this.name, 255, 0L, this.alg, timeSigned, fudge, signature, m4.getHeader().getID(), error, other);
    }

    private Instant getTimeSigned(int error, TSIGRecord old) {
        return error == 18 ? old.getTimeSigned() : this.clock.instant();
    }

    private static Duration getTsigFudge() {
        int fudgeOption = Options.intValue("tsigfudge");
        return fudgeOption < 0 || fudgeOption > Short.MAX_VALUE ? FUDGE : Duration.ofSeconds(fudgeOption);
    }

    public void apply(Message m4, TSIGRecord old) {
        this.apply(m4, 0, old, true);
    }

    public void apply(Message m4, int error, TSIGRecord old) {
        this.apply(m4, error, old, true);
    }

    public void apply(Message m4, TSIGRecord old, boolean fullSignature) {
        this.apply(m4, 0, old, fullSignature);
    }

    public void apply(Message m4, int error, TSIGRecord old, boolean fullSignature) {
        TSIGRecord r = this.generate(m4, m4.toWire(), error, old, fullSignature);
        m4.addRecord(r, 3);
        m4.tsigState = 3;
    }

    @Deprecated
    public void applyStream(Message m4, TSIGRecord old, boolean fullSignature) {
        this.apply(m4, 0, old, fullSignature);
    }

    @Deprecated
    public byte verify(Message m4, byte[] b, int length, TSIGRecord old) {
        return (byte)this.verify(m4, b, old);
    }

    public int verify(Message m4, byte[] messageBytes, TSIGRecord requestTSIG) {
        return this.verify(m4, messageBytes, requestTSIG, true);
    }

    public int verify(Message m4, byte[] messageBytes, TSIGRecord requestTSIG, boolean fullSignature) {
        return this.verify(m4, messageBytes, requestTSIG, fullSignature, null);
    }

    private int verify(Message m4, byte[] messageBytes, TSIGRecord requestTSIG, boolean fullSignature, Mac hmac) {
        m4.tsigState = 4;
        TSIGRecord tsig = m4.getTSIG();
        if (tsig == null) {
            return 1;
        }
        if (!tsig.getName().equals(this.name) || !tsig.getAlgorithm().equals(this.alg)) {
            log.debug("BADKEY failure on message id {}, expected: {}/{}, actual: {}/{}", m4.getHeader().getID(), this.name, this.alg, tsig.getName(), tsig.getAlgorithm());
            return 17;
        }
        if (hmac == null) {
            hmac = this.initHmac();
        }
        if (requestTSIG != null && tsig.getError() != 17 && tsig.getError() != 16) {
            TSIG.hmacAddSignature(hmac, requestTSIG);
        }
        m4.getHeader().decCount(3);
        byte[] header = m4.getHeader().toWire();
        m4.getHeader().incCount(3);
        if (log.isTraceEnabled()) {
            log.trace(hexdump.dump("TSIG-HMAC header", header));
        }
        hmac.update(header);
        int len = m4.tsigstart - header.length;
        if (log.isTraceEnabled()) {
            log.trace(hexdump.dump("TSIG-HMAC message after header", messageBytes, header.length, len));
        }
        hmac.update(messageBytes, header.length, len);
        byte[] tsigVariables = TSIG.getTsigVariables(fullSignature, tsig);
        hmac.update(tsigVariables);
        byte[] signature = tsig.getSignature();
        int badsig = TSIG.verifySignature(hmac, signature);
        if (badsig != 0) {
            return badsig;
        }
        int badtime = this.verifyTime(tsig);
        if (badtime != 0) {
            return badtime;
        }
        m4.tsigState = 1;
        return 0;
    }

    private static byte[] getTsigVariables(boolean fullSignature, TSIGRecord tsig) {
        DNSOutput out = new DNSOutput();
        if (fullSignature) {
            tsig.getName().toWireCanonical(out);
            out.writeU16(tsig.dclass);
            out.writeU32(tsig.ttl);
            tsig.getAlgorithm().toWireCanonical(out);
        }
        TSIG.writeTsigTimerVariables(tsig.getTimeSigned(), tsig.getFudge(), out);
        if (fullSignature) {
            out.writeU16(tsig.getError());
            if (tsig.getOther() != null) {
                out.writeU16(tsig.getOther().length);
                out.writeByteArray(tsig.getOther());
            } else {
                out.writeU16(0);
            }
        }
        byte[] tsigVariables = out.toByteArray();
        if (log.isTraceEnabled()) {
            log.trace(hexdump.dump("TSIG-HMAC variables", tsigVariables));
        }
        return tsigVariables;
    }

    private static int verifySignature(Mac hmac, byte[] signature) {
        int digestLength = hmac.getMacLength();
        int minDigestLength = Math.max(10, digestLength / 2);
        if (signature.length > digestLength) {
            log.debug("BADSIG: signature too long, expected: {}, actual: {}", (Object)digestLength, (Object)signature.length);
            return 16;
        }
        if (signature.length < minDigestLength) {
            log.debug("BADSIG: signature too short, expected: {} of {}, actual: {}", minDigestLength, digestLength, signature.length);
            return 16;
        }
        byte[] expectedSignature = hmac.doFinal();
        if (!TSIG.verify(expectedSignature, signature)) {
            if (log.isDebugEnabled()) {
                log.debug("BADSIG: signature verification failed, expected: {}, actual: {}", (Object)base64.toString(expectedSignature), (Object)base64.toString(signature));
            }
            return 16;
        }
        return 0;
    }

    private int verifyTime(TSIGRecord tsig) {
        Instant now = this.clock.instant();
        Duration delta = Duration.between(now, tsig.getTimeSigned()).abs();
        if (delta.compareTo(tsig.getFudge()) > 0) {
            log.debug("BADTIME failure, now {} +/- tsig {} > fudge {}", now, tsig.getTimeSigned(), tsig.getFudge());
            return 18;
        }
        return 0;
    }

    public int recordLength() {
        return this.name.length() + 10 + this.alg.length() + 8 + 18 + 4 + 8;
    }

    private static void hmacAddSignature(Mac hmac, TSIGRecord tsig) {
        byte[] signatureSize = DNSOutput.toU16(tsig.getSignature().length);
        if (log.isTraceEnabled()) {
            log.trace(hexdump.dump("TSIG-HMAC signature size", signatureSize));
            log.trace(hexdump.dump("TSIG-HMAC signature", tsig.getSignature()));
        }
        hmac.update(signatureSize);
        hmac.update(tsig.getSignature());
    }

    private static void writeTsigTimerVariables(Instant instant, Duration fudge, DNSOutput out) {
        TSIG.writeTsigTime(instant, out);
        out.writeU16((int)fudge.getSeconds());
    }

    private static void writeTsigTime(Instant instant, DNSOutput out) {
        long time = instant.getEpochSecond();
        int timeHigh = (int)(time >> 32);
        long timeLow = time & 0xFFFFFFFFL;
        out.writeU16(timeHigh);
        out.writeU32(timeLow);
    }

    static {
        HMAC = HMAC_MD5 = Name.fromConstantString("HMAC-MD5.SIG-ALG.REG.INT.");
        HMAC_SHA1 = Name.fromConstantString("hmac-sha1.");
        HMAC_SHA224 = Name.fromConstantString("hmac-sha224.");
        HMAC_SHA256 = Name.fromConstantString("hmac-sha256.");
        HMAC_SHA384 = Name.fromConstantString("hmac-sha384.");
        HMAC_SHA512 = Name.fromConstantString("hmac-sha512.");
        HashMap<Name, String> out = new HashMap<Name, String>();
        out.put(HMAC_MD5, "HmacMD5");
        out.put(HMAC_SHA1, "HmacSHA1");
        out.put(HMAC_SHA224, "HmacSHA224");
        out.put(HMAC_SHA256, "HmacSHA256");
        out.put(HMAC_SHA384, "HmacSHA384");
        out.put(HMAC_SHA512, "HmacSHA512");
        algMap = Collections.unmodifiableMap(out);
        FUDGE = Duration.ofSeconds(300L);
    }

    public static class StreamVerifier {
        private final TSIG key;
        private final Mac sharedHmac;
        private final TSIGRecord queryTsig;
        private int nresponses;
        private int lastsigned;
        private String errorMessage;

        public StreamVerifier(TSIG tsig, TSIGRecord queryTsig) {
            this.key = tsig;
            this.sharedHmac = this.key.initHmac();
            this.nresponses = 0;
            this.queryTsig = queryTsig;
        }

        public int verify(Message message, byte[] messageBytes) {
            return this.verify(message, messageBytes, false);
        }

        public int verify(Message message, byte[] messageBytes, boolean isLastMessage) {
            boolean required;
            String warningPrefix = "FORMERR: {}";
            TSIGRecord tsig = message.getTSIG();
            ++this.nresponses;
            if (this.nresponses == 1) {
                if (tsig != null) {
                    int result = this.key.verify(message, messageBytes, this.queryTsig, true, this.sharedHmac);
                    TSIG.hmacAddSignature(this.sharedHmac, tsig);
                    this.lastsigned = this.nresponses;
                    return result;
                }
                this.errorMessage = "missing required signature on first message";
                log.debug("FORMERR: {}", (Object)this.errorMessage);
                message.tsigState = 4;
                return 1;
            }
            if (tsig != null) {
                int result = this.key.verify(message, messageBytes, null, false, this.sharedHmac);
                this.lastsigned = this.nresponses;
                TSIG.hmacAddSignature(this.sharedHmac, tsig);
                return result;
            }
            boolean bl = required = this.nresponses - this.lastsigned >= 100;
            if (required) {
                this.errorMessage = "Missing required signature on message #" + this.nresponses;
                log.debug("FORMERR: {}", (Object)this.errorMessage);
                message.tsigState = 4;
                return 1;
            }
            if (isLastMessage) {
                this.errorMessage = "Missing required signature on last message";
                log.debug("FORMERR: {}", (Object)this.errorMessage);
                message.tsigState = 4;
                return 1;
            }
            this.errorMessage = "Intermediate message #" + this.nresponses + " without signature";
            log.debug("FORMERR: {}", (Object)this.errorMessage);
            this.addUnsignedMessageToMac(message, messageBytes, this.sharedHmac);
            return 0;
        }

        private void addUnsignedMessageToMac(Message m4, byte[] messageBytes, Mac hmac) {
            byte[] header = m4.getHeader().toWire();
            if (log.isTraceEnabled()) {
                log.trace(hexdump.dump("TSIG-HMAC header", header));
            }
            hmac.update(header);
            int len = messageBytes.length - header.length;
            if (log.isTraceEnabled()) {
                log.trace(hexdump.dump("TSIG-HMAC message after header", messageBytes, header.length, len));
            }
            hmac.update(messageBytes, header.length, len);
            m4.tsigState = 2;
        }

        @Generated
        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static class StreamGenerator {
        private final TSIG key;
        private final Mac sharedHmac;
        private final int signEveryNthMessage;
        private int numGenerated;
        private TSIGRecord lastTsigRecord;

        public StreamGenerator(TSIG key, TSIGRecord queryTsig) {
            this(key, queryTsig, 1);
        }

        StreamGenerator(TSIG key, TSIGRecord queryTsig, int signEveryNthMessage) {
            if (signEveryNthMessage < 1 || signEveryNthMessage > 100) {
                throw new IllegalArgumentException("signEveryNthMessage must be between 1 and 100");
            }
            this.key = key;
            this.lastTsigRecord = queryTsig;
            this.signEveryNthMessage = signEveryNthMessage;
            this.sharedHmac = this.key.initHmac();
        }

        public void generate(Message message) {
            this.generate(message, true);
        }

        void generate(Message message, boolean isLastMessage) {
            boolean isFirstMessage;
            boolean isNthMessage = this.numGenerated % this.signEveryNthMessage == 0;
            boolean bl = isFirstMessage = this.numGenerated == 0;
            if (isFirstMessage || isNthMessage || isLastMessage) {
                TSIGRecord r = this.key.generate(message, message.toWire(), 0, isFirstMessage ? this.lastTsigRecord : null, isFirstMessage, this.sharedHmac);
                message.addRecord(r, 3);
                message.tsigState = 3;
                this.lastTsigRecord = r;
                TSIG.hmacAddSignature(this.sharedHmac, r);
            } else {
                byte[] responseBytes = message.toWire(65535);
                this.sharedHmac.update(responseBytes);
            }
            ++this.numGenerated;
        }
    }
}

