/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLEngine;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLEngine;
import org.bouncycastle.jsse.provider.ProvSSLEngine_8;
import org.bouncycastle.jsse.provider.ReflectionUtil;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.jsse.provider.SSLSessionUtil;

abstract class SSLEngineUtil {
    private static final Method getHandshakeSession;
    private static final Method getSSLParameters;
    private static final boolean useEngine8;

    SSLEngineUtil() {
    }

    static SSLEngine create(ContextData contextData) {
        return useEngine8 ? new ProvSSLEngine_8(contextData) : new ProvSSLEngine(contextData);
    }

    static SSLEngine create(ContextData contextData, String host, int port) {
        return useEngine8 ? new ProvSSLEngine_8(contextData, host, port) : new ProvSSLEngine(contextData, host, port);
    }

    static BCExtendedSSLSession importHandshakeSession(SSLEngine sslEngine) {
        SSLSession sslSession;
        if (sslEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sslEngine)).getBCHandshakeSession();
        }
        if (null != sslEngine && null != getHandshakeSession && null != (sslSession = (SSLSession)ReflectionUtil.invokeGetter(sslEngine, getHandshakeSession))) {
            return SSLSessionUtil.importSSLSession(sslSession);
        }
        return null;
    }

    static BCSSLParameters importSSLParameters(SSLEngine sslEngine) {
        if (sslEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sslEngine)).getParameters();
        }
        if (null == sslEngine || null == getSSLParameters) {
            return null;
        }
        SSLParameters sslParameters = (SSLParameters)ReflectionUtil.invokeGetter(sslEngine, getSSLParameters);
        if (null == sslParameters) {
            throw new RuntimeException("SSLEngine.getSSLParameters returned null");
        }
        return SSLParametersUtil.importSSLParameters(sslParameters);
    }

    static {
        Method[] methods = ReflectionUtil.getMethods("javax.net.ssl.SSLEngine");
        getHandshakeSession = ReflectionUtil.findMethod(methods, "getHandshakeSession");
        getSSLParameters = ReflectionUtil.findMethod(methods, "getSSLParameters");
        useEngine8 = ReflectionUtil.hasMethod(methods, "getApplicationProtocol");
    }
}

