/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoConfigurationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SsoConfigurationUtil.class);
    public static final String HADOOP_JWT_ENABLED = "hadoop.http.authentication.jwt.enabled";
    public static final String EXPECTED_JWT_AUDIENCES = "hadoop.http.authentication.expected.jwt.audiences";
    private static List<String> audiences = new ArrayList<String>();
    private static Map<String, String> ssoConfigMap = null;
    private static SsoConfigurationUtil ssoConfigInstance = null;
    public static final String CLIENT_ID = "clientid";
    private final String CLIENT_SECRET = "clientsecret";
    private final String PROVIDER = "providername";
    public static final String ISSUER = "issuerendpoint";
    private final String JWS_SSO_ALGORITHM = "jws.sso.algorithm";
    private final String COOKIE_DOMAIN = "jwt.cookie.domain";
    private final String COOKIE_PATH = "jwt.cookie.path";
    private final String COOKIE_NAME = "jwt.cookie.name";
    private final String USER_ATTRIBUTE_NAME = "jwt.user.attribute.name";

    private SsoConfigurationUtil() {
    }

    public static SsoConfigurationUtil getInstance() {
        if (ssoConfigInstance == null) {
            LOG.debug("Initializing SSO configuration.");
            ssoConfigInstance = new SsoConfigurationUtil();
            ssoConfigMap = new HashMap<String, String>();
            ssoConfigInstance.init();
        }
        return ssoConfigInstance;
    }

    private void init() {
        LOG.debug("Getting SSO configuration from maprcli command.");
        JsonArray result = null;
        String[] ssoConfigCommand = new String[]{"cluster", "getssoconf"};
        Map jwtMapConf = new HashMap();
        try {
            Class<?> jwtKlass = Class.forName("org.apache.hadoop.util.JWTConfiguration");
            Method executeJWTConf = jwtKlass.getMethod("getJWTConfiguration", new Class[0]);
            Object jwtConf = jwtKlass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            jwtMapConf = (Map)executeJWTConf.invoke(jwtConf, new Object[0]);
            Class<?> klass = Class.forName("org.apache.hadoop.util.MaprShellCommandExecutor");
            Method execute = klass.getMethod("execute", String[].class, Map.class, Boolean.TYPE);
            Object maprShell = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            result = (JsonArray)execute.invoke(maprShell, ssoConfigCommand, null, false);
        }
        catch (Exception ex) {
            LOG.debug("Failed to get SSO configuration from maprcli. Please check 'maprcli cluster getssoconf' command.", ex);
            this.putEmptyMap();
        }
        if (jwtMapConf != null && !jwtMapConf.isEmpty()) {
            if (jwtMapConf.get(EXPECTED_JWT_AUDIENCES) != null) {
                audiences.addAll(Arrays.asList(((String)jwtMapConf.get(EXPECTED_JWT_AUDIENCES)).split(",")));
            }
            ssoConfigMap.put("jws.sso.algorithm", (String)jwtMapConf.get("jws.sso.algorithm"));
            ssoConfigMap.put("jwt.cookie.domain", (String)jwtMapConf.get("jwt.cookie.domain"));
            ssoConfigMap.put("jwt.cookie.path", (String)jwtMapConf.get("jwt.cookie.path"));
            ssoConfigMap.put("jwt.cookie.name", (String)jwtMapConf.get("jwt.cookie.name"));
            ssoConfigMap.put("jwt.user.attribute.name", (String)jwtMapConf.get("jwt.user.attribute.name"));
        }
        if (result != null && !result.isEmpty()) {
            JsonElement clientIdJson = result.get(0).getAsJsonObject().get(CLIENT_ID);
            JsonElement clientSecretJson = result.get(0).getAsJsonObject().get("clientsecret");
            ssoConfigMap.put(CLIENT_ID, clientIdJson != null ? clientIdJson.getAsString() : "");
            ssoConfigMap.put("clientsecret", clientSecretJson != null ? clientSecretJson.getAsString() : "");
            ssoConfigMap.put("providername", result.get(0).getAsJsonObject().get("providername").getAsString());
            ssoConfigMap.put(ISSUER, result.get(0).getAsJsonObject().get(ISSUER).getAsString());
        } else {
            this.putEmptyMap();
        }
    }

    private void putEmptyMap() {
        ssoConfigMap.put(CLIENT_ID, "");
        ssoConfigMap.put("clientsecret", "");
        ssoConfigMap.put("providername", "");
        ssoConfigMap.put(ISSUER, "");
    }

    public Map<String, String> getFullSsoConfig() {
        return ssoConfigMap;
    }

    public String getConf(String key) {
        return ssoConfigMap.get(key);
    }

    public String getClientId() {
        return ssoConfigMap.get(CLIENT_ID);
    }

    public String getClientSecret() {
        return ssoConfigMap.get("clientsecret");
    }

    public String getClientIssuer() {
        return ssoConfigMap.get(ISSUER);
    }

    public String getProvider() {
        return ssoConfigMap.get("providername");
    }

    public String getCookieDomain() {
        return ssoConfigMap.get("jwt.cookie.domain");
    }

    public String getCookiePath() {
        return ssoConfigMap.get("jwt.cookie.path");
    }

    public String getCookieName() {
        return ssoConfigMap.get("jwt.cookie.name");
    }

    public String getUserAttrName() {
        return ssoConfigMap.get("jwt.user.attribute.name");
    }

    public List<String> getAudiences() {
        return audiences;
    }

    public String getJwsSsoAlgorithm() {
        return ssoConfigMap.get("jws.sso.algorithm");
    }

    public boolean isSsoEnabled() {
        return !this.getClientIssuer().isEmpty() && !this.getClientId().isEmpty() && !this.getClientSecret().isEmpty() && !this.getProvider().isEmpty();
    }
}

