/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics.impl;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.MeanStatistic;
import org.apache.hadoop.fs.statistics.impl.DynamicIOStatistics;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.util.Preconditions;

public class DynamicIOStatisticsBuilder {
    private DynamicIOStatistics instance = new DynamicIOStatistics();

    public IOStatistics build() {
        DynamicIOStatistics stats = this.activeInstance();
        this.instance = null;
        return stats;
    }

    private DynamicIOStatistics activeInstance() {
        Preconditions.checkState(this.instance != null, "Already built");
        return this.instance;
    }

    public DynamicIOStatisticsBuilder withLongFunctionCounter(String key, ToLongFunction<String> eval) {
        this.activeInstance().addCounterFunction(key, eval::applyAsLong);
        return this;
    }

    public DynamicIOStatisticsBuilder withAtomicLongCounter(String key, AtomicLong source) {
        this.withLongFunctionCounter(key, s2 -> source.get());
        return this;
    }

    public DynamicIOStatisticsBuilder withAtomicIntegerCounter(String key, AtomicInteger source) {
        this.withLongFunctionCounter(key, s2 -> source.get());
        return this;
    }

    public DynamicIOStatisticsBuilder withMutableCounter(String key, MutableCounterLong source) {
        this.withLongFunctionCounter(key, s2 -> source.value());
        return this;
    }

    public DynamicIOStatisticsBuilder withLongFunctionGauge(String key, ToLongFunction<String> eval) {
        this.activeInstance().addGaugeFunction(key, eval::applyAsLong);
        return this;
    }

    public DynamicIOStatisticsBuilder withAtomicLongGauge(String key, AtomicLong source) {
        this.withLongFunctionGauge(key, s2 -> source.get());
        return this;
    }

    public DynamicIOStatisticsBuilder withAtomicIntegerGauge(String key, AtomicInteger source) {
        this.withLongFunctionGauge(key, s2 -> source.get());
        return this;
    }

    public DynamicIOStatisticsBuilder withLongFunctionMinimum(String key, ToLongFunction<String> eval) {
        this.activeInstance().addMinimumFunction(key, eval::applyAsLong);
        return this;
    }

    public DynamicIOStatisticsBuilder withAtomicLongMinimum(String key, AtomicLong source) {
        this.withLongFunctionMinimum(key, s2 -> source.get());
        return this;
    }

    public DynamicIOStatisticsBuilder withAtomicIntegerMinimum(String key, AtomicInteger source) {
        this.withLongFunctionMinimum(key, s2 -> source.get());
        return this;
    }

    public DynamicIOStatisticsBuilder withLongFunctionMaximum(String key, ToLongFunction<String> eval) {
        this.activeInstance().addMaximumFunction(key, eval::applyAsLong);
        return this;
    }

    public DynamicIOStatisticsBuilder withAtomicLongMaximum(String key, AtomicLong source) {
        this.withLongFunctionMaximum(key, s2 -> source.get());
        return this;
    }

    public DynamicIOStatisticsBuilder withAtomicIntegerMaximum(String key, AtomicInteger source) {
        this.withLongFunctionMaximum(key, s2 -> source.get());
        return this;
    }

    public DynamicIOStatisticsBuilder withMeanStatisticFunction(String key, Function<String, MeanStatistic> eval) {
        this.activeInstance().addMeanStatisticFunction(key, eval);
        return this;
    }
}

