/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsTracer;
import org.apache.hadoop.fs.GlobExpander;
import org.apache.hadoop.fs.GlobFilter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.maprfs.AbstractMapRFileSystem;
import org.apache.hadoop.tracing.TraceScope;
import org.apache.hadoop.tracing.Tracer;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Globber {
    public static final Logger LOG = LoggerFactory.getLogger(Globber.class.getName());
    private final FileSystem fs;
    private final FileContext fc;
    private final Path pathPattern;
    private final PathFilter filter;
    private final Tracer tracer;
    private final boolean resolveSymlinks;

    Globber(FileSystem fs, Path pathPattern, PathFilter filter) {
        this.fs = fs;
        this.fc = null;
        this.pathPattern = pathPattern;
        this.filter = filter;
        this.tracer = FsTracer.get(fs.getConf());
        this.resolveSymlinks = true;
    }

    Globber(FileContext fc, Path pathPattern, PathFilter filter) {
        this.fs = null;
        this.fc = fc;
        this.pathPattern = pathPattern;
        this.filter = filter;
        this.tracer = fc.getTracer();
        this.resolveSymlinks = true;
    }

    private Globber(FileSystem fs, Path pathPattern, PathFilter filter, boolean resolveSymlinks) {
        this.fs = fs;
        this.fc = null;
        this.pathPattern = pathPattern;
        this.filter = filter;
        this.resolveSymlinks = resolveSymlinks;
        this.tracer = FsTracer.get(fs.getConf());
        LOG.debug("Created Globber for path={}, symlinks={}", (Object)pathPattern, (Object)resolveSymlinks);
    }

    private Globber(FileContext fc, Path pathPattern, PathFilter filter, boolean resolveSymlinks) {
        this.fs = null;
        this.fc = fc;
        this.pathPattern = pathPattern;
        this.filter = filter;
        this.resolveSymlinks = resolveSymlinks;
        this.tracer = fc.getTracer();
        LOG.debug("Created Globber path={}, symlinks={}", (Object)pathPattern, (Object)resolveSymlinks);
    }

    private FileStatus getFileStatus(Path path) throws IOException {
        try {
            if (this.fs != null) {
                return this.fs.getFileStatus(path);
            }
            return this.fc.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            LOG.debug("getFileStatus({}) failed; returning null", (Object)path, (Object)e);
            return null;
        }
    }

    private FileStatus[] listStatus(Path path) throws IOException {
        try {
            if (this.fs != null) {
                return this.fs.listStatus(path);
            }
            return this.fc.util().listStatus(path);
        }
        catch (FileNotFoundException e) {
            LOG.debug("listStatus({}) failed; returning empty array", (Object)path, (Object)e);
            return new FileStatus[0];
        }
    }

    private Path fixRelativePart(Path path) {
        if (this.fs != null) {
            return this.fs.fixRelativePart(path);
        }
        return this.fc.fixRelativePart(path);
    }

    private static String unescapePathComponent(String name) {
        return name.replaceAll("\\\\(.)", "$1");
    }

    private static List<String> getPathComponents(String path) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        for (String component : path.split("/")) {
            if (component.isEmpty()) continue;
            ret.add(component);
        }
        return ret;
    }

    private String schemeFromPath(Path path) throws IOException {
        String scheme = path.toUri().getScheme();
        if (scheme == null) {
            scheme = this.fs != null ? this.fs.getUri().getScheme() : this.fc.getFSofPath(this.fc.fixRelativePart(path)).getUri().getScheme();
        }
        return scheme;
    }

    private String authorityFromPath(Path path) throws IOException {
        String authority = path.toUri().getAuthority();
        if (authority == null) {
            authority = this.fs != null ? this.fs.getUri().getAuthority() : this.fc.getFSofPath(this.fc.fixRelativePart(path)).getUri().getAuthority();
        }
        return authority;
    }

    public FileStatus[] glob() throws IOException {
        scope.addKVAnnotation("pattern", this.pathPattern.toUri().getPath());
        try (TraceScope scope = this.tracer.newScope("Globber#glob");){
            DurationInfo ignored = new DurationInfo(LOG, false, "glob %s", this.pathPattern);
            try {
                FileStatus[] fileStatusArray = this.doGlob();
                ignored.close();
                return fileStatusArray;
            }
            catch (Throwable throwable) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private FileStatus[] doGlob() throws IOException {
        String scheme = this.schemeFromPath(this.pathPattern);
        String authority = this.authorityFromPath(this.pathPattern);
        String pathPatternString = this.pathPattern.toUri().getPath();
        List<String> flattenedPatterns = GlobExpander.expand(pathPatternString);
        LOG.debug("Filesystem glob {}", (Object)pathPatternString);
        ArrayList<FileStatus> results = new ArrayList<FileStatus>(flattenedPatterns.size());
        boolean sawWildcard = false;
        for (String flatPattern : flattenedPatterns) {
            FileStatus rootPlaceholder;
            Path absPattern = this.fixRelativePart(new Path(flatPattern.isEmpty() ? "." : flatPattern));
            LOG.debug("Pattern: {}", (Object)absPattern);
            List<String> components = Globber.getPathComponents(absPattern.toUri().getPath());
            ArrayList<FileStatus> candidates = new ArrayList<FileStatus>(1);
            if (Path.WINDOWS && !components.isEmpty() && Path.isWindowsAbsolutePath(absPattern.toUri().getPath(), true)) {
                String driveLetter = components.remove(0);
                rootPlaceholder = new FileStatus(0L, true, 0, 0L, 0L, new Path(scheme, authority, "/" + driveLetter + "/"));
            } else {
                rootPlaceholder = new FileStatus(0L, true, 0, 0L, 0L, new Path(scheme, authority, "/"));
            }
            candidates.add(rootPlaceholder);
            for (int componentIdx = 0; componentIdx < components.size(); ++componentIdx) {
                ArrayList<FileStatus> newCandidates = new ArrayList<FileStatus>(candidates.size());
                GlobFilter globFilter = new GlobFilter(components.get(componentIdx));
                String component = Globber.unescapePathComponent(components.get(componentIdx));
                if (globFilter.hasPattern()) {
                    sawWildcard = true;
                }
                LOG.debug("Component {}, patterned={}", (Object)component, (Object)sawWildcard);
                if (candidates.isEmpty() && sawWildcard) break;
                if (componentIdx < components.size() - 1 && !globFilter.hasPattern()) {
                    for (FileStatus candidate : candidates) {
                        candidate.setPath(new Path(candidate.getPath(), component));
                    }
                    continue;
                }
                for (FileStatus candidate : candidates) {
                    FileStatus candidateStatus;
                    if (this.fs instanceof AbstractMapRFileSystem && this.fs.exists(candidate.getPath()) && (candidateStatus = this.fs.getFileStatus(candidate.getPath())).isSymlink()) {
                        candidate = this.fs.getFileStatus(FileUtil.fixSymlinkFileStatus(candidateStatus));
                    }
                    if (globFilter.hasPattern()) {
                        FileStatus[] children = this.listStatus(candidate.getPath());
                        if (children.length == 1) {
                            if (this.resolveSymlinks) {
                                LOG.debug("listStatus found one entry; disambiguating {}", (Object)children[0]);
                                Path path = candidate.getPath();
                                FileStatus status = this.getFileStatus(path);
                                if (status == null) {
                                    LOG.warn("File/directory {} not found: it may have been deleted. If this is an object store, this can be a sign of eventual consistency problems.", (Object)path);
                                    continue;
                                }
                                if (!status.isDirectory()) {
                                    LOG.debug("Resolved entry is a file; skipping: {}", (Object)status);
                                    continue;
                                }
                            } else if (children[0].getPath().equals(candidate.getPath())) continue;
                        }
                        for (FileStatus child : children) {
                            if (componentIdx < components.size() - 1 && !child.isDirectory()) continue;
                            child.setPath(new Path(candidate.getPath(), child.getPath().getName()));
                            if (!globFilter.accept(child.getPath())) continue;
                            newCandidates.add(child);
                        }
                        continue;
                    }
                    FileStatus childStatus = this.getFileStatus(new Path(candidate.getPath(), component));
                    if (childStatus == null) continue;
                    newCandidates.add(childStatus);
                }
                candidates = newCandidates;
            }
            for (FileStatus status : candidates) {
                if (status == rootPlaceholder && (status = this.getFileStatus(rootPlaceholder.getPath())) == null || !this.filter.accept(status.getPath())) continue;
                results.add(status);
            }
        }
        if (!sawWildcard && results.isEmpty() && flattenedPatterns.size() <= 1) {
            LOG.debug("No matches found and there was no wildcard in the path {}", (Object)this.pathPattern);
            return null;
        }
        Object[] ret = results.toArray(new FileStatus[0]);
        Arrays.sort(ret);
        return ret;
    }

    public static GlobBuilder createGlobber(FileSystem filesystem) {
        return new GlobBuilder(filesystem);
    }

    public static GlobBuilder createGlobber(FileContext fileContext) {
        return new GlobBuilder(fileContext);
    }

    @InterfaceAudience.Private
    public static class GlobBuilder {
        private final FileSystem fs;
        private final FileContext fc;
        private Path pathPattern;
        private PathFilter filter;
        private boolean resolveSymlinks = true;

        public GlobBuilder(FileContext fc) {
            this.fs = null;
            this.fc = Preconditions.checkNotNull(fc);
        }

        public GlobBuilder(FileSystem fs) {
            this.fs = Preconditions.checkNotNull(fs);
            this.fc = null;
        }

        public GlobBuilder withPathPattern(Path pattern) {
            this.pathPattern = pattern;
            return this;
        }

        public GlobBuilder withPathFiltern(PathFilter pathFilter) {
            this.filter = pathFilter;
            return this;
        }

        public GlobBuilder withResolveSymlinks(boolean resolve) {
            this.resolveSymlinks = resolve;
            return this;
        }

        public Globber build() {
            return this.fs != null ? new Globber(this.fs, this.pathPattern, this.filter, this.resolveSymlinks) : new Globber(this.fc, this.pathPattern, this.filter, this.resolveSymlinks);
        }
    }
}

