/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.parameter.multivalued;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

final class PrimitiveMapper {
    static final Map<Class, Class> primitiveToClassMap = PrimitiveMapper.getPrimitiveToClassMap();
    static final Map<Class, Object> primitiveToDefaultValueMap = PrimitiveMapper.getPrimitiveToDefaultValueMap();

    PrimitiveMapper() {
    }

    private static Map<Class, Class> getPrimitiveToClassMap() {
        WeakHashMap<Class<Comparable<Boolean>>, Class<Double>> m4 = new WeakHashMap<Class<Comparable<Boolean>>, Class<Double>>();
        m4.put(Boolean.TYPE, Boolean.class);
        m4.put(Byte.TYPE, Byte.class);
        m4.put(Short.TYPE, Short.class);
        m4.put(Integer.TYPE, Integer.class);
        m4.put(Long.TYPE, Long.class);
        m4.put(Float.TYPE, Float.class);
        m4.put(Double.TYPE, Double.class);
        return Collections.unmodifiableMap(m4);
    }

    private static Map<Class, Object> getPrimitiveToDefaultValueMap() {
        WeakHashMap<Class<Double>, Comparable<Boolean>> m4 = new WeakHashMap<Class<Double>, Comparable<Boolean>>();
        m4.put(Boolean.class, Boolean.valueOf(false));
        m4.put(Byte.class, Byte.valueOf((byte)0));
        m4.put(Short.class, Short.valueOf((short)0));
        m4.put(Integer.class, Integer.valueOf(0));
        m4.put(Long.class, Long.valueOf(0L));
        m4.put(Float.class, Float.valueOf(0.0f));
        m4.put(Double.class, Double.valueOf(0.0));
        return Collections.unmodifiableMap(m4);
    }
}

