/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ScalarResult;

abstract class AbstractHotspotProfiler
implements InternalProfiler {
    private final Method getListMethod;
    private final Object bean;
    private Map<String, Long> prevs;

    public AbstractHotspotProfiler(String beanName, String methodName) throws ProfilerException {
        try {
            Class<?> helper = Class.forName("sun.management.ManagementFactoryHelper");
            this.bean = helper.getMethod("get" + beanName, new Class[0]).invoke(null, new Object[0]);
            this.getListMethod = this.bean.getClass().getMethod(methodName, new Class[0]);
            this.getListMethod.setAccessible(true);
            this.getListMethod.invoke(this.bean, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ProfilerException("Problem initializing profiler (" + e.getMessage() + "), are you running HotSpot VM?");
        }
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult result) {
        HotspotInternalResult res = this.counters();
        ArrayList<ScalarResult> results = new ArrayList<ScalarResult>();
        for (Map.Entry<String, Long> e : res.getDiff().entrySet()) {
            results.add(new ScalarResult("\u00b7" + e.getKey(), e.getValue().longValue(), "?", AggregationPolicy.AVG));
        }
        return results;
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        this.prevs = new HashMap<String, Long>();
        for (HotspotCounter counter : this.getCounters()) {
            this.prevs.put(counter.getName(), AbstractHotspotProfiler.convert(counter.getValue()));
        }
    }

    public static Long convert(Object o) {
        try {
            return Long.valueOf(String.valueOf(o));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    protected HotspotInternalResult counters() {
        TreeMap<String, Long> difference = new TreeMap<String, Long>();
        TreeMap<String, Long> current = new TreeMap<String, Long>();
        for (HotspotCounter counter : this.getCounters()) {
            Long prev = this.prevs.get(counter.getName());
            if (prev == null) continue;
            long diff = AbstractHotspotProfiler.convert(counter.getValue()) - prev;
            difference.put(counter.getName(), diff);
            current.put(counter.getName(), AbstractHotspotProfiler.convert(counter.getValue()));
        }
        return new HotspotInternalResult(current, difference);
    }

    public List<HotspotCounter> getCounters() {
        try {
            ArrayList<HotspotCounter> counters = new ArrayList<HotspotCounter>();
            for (Object c : (List)this.getListMethod.invoke(this.bean, new Object[0])) {
                try {
                    counters.add(new HotspotCounter(c));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
            return counters;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Should not be here", e);
        }
    }

    private static class HotspotCounter {
        private static final Method GET_VALUE;
        private static final Method GET_NAME;
        private final Object proxy;

        public HotspotCounter(Object proxy) throws UnsupportedOperationException {
            this.proxy = proxy;
            if (GET_NAME == null || GET_VALUE == null) {
                throw new UnsupportedOperationException();
            }
            try {
                String k = (String)GET_NAME.invoke(proxy, new Object[0]);
                Object object = GET_VALUE.invoke(proxy, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public String getName() {
            try {
                return (String)GET_NAME.invoke(this.proxy, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Cannot be here");
            }
        }

        public Object getValue() {
            try {
                return GET_VALUE.invoke(this.proxy, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Cannot be here");
            }
        }

        static {
            Method value;
            Method name;
            block6: {
                name = null;
                value = null;
                try {
                    Class<?> cntClass = Class.forName("sun.management.counter.Counter");
                    if (cntClass == null) break block6;
                    try {
                        name = cntClass.getMethod("getName", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    try {
                        value = cntClass.getMethod("getValue", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            GET_NAME = name;
            GET_VALUE = value;
        }
    }

    static class HotspotInternalResult {
        private final Map<String, Long> current;
        private final Map<String, Long> diff;

        public HotspotInternalResult(Map<String, Long> current, Map<String, Long> diff) {
            this.current = current;
            this.diff = diff;
        }

        public Map<String, Long> getCurrent() {
            return this.current;
        }

        public Map<String, Long> getDiff() {
            return this.diff;
        }

        public String toString() {
            return "difference: " + this.diff.toString();
        }
    }
}

