/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DTLSProtocol;
import org.bouncycastle.tls.DTLSRecordLayer;
import org.bouncycastle.tls.DTLSReliableHandshake;
import org.bouncycastle.tls.DTLSRequest;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HeartbeatExtension;
import org.bouncycastle.tls.KeyExchangeAlgorithm;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.NullOutputStream;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerHello;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsHeartbeat;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerContextImpl;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;

public class DTLSServerProtocol
extends DTLSProtocol {
    protected boolean verifyRequests = true;

    public boolean getVerifyRequests() {
        return this.verifyRequests;
    }

    public void setVerifyRequests(boolean verifyRequests) {
        this.verifyRequests = verifyRequests;
    }

    public DTLSTransport accept(TlsServer server, DatagramTransport transport) throws IOException {
        return this.accept(server, transport, null);
    }

    public DTLSTransport accept(TlsServer server, DatagramTransport transport, DTLSRequest request) throws IOException {
        if (server == null) {
            throw new IllegalArgumentException("'server' cannot be null");
        }
        if (transport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        ServerHandshakeState state = new ServerHandshakeState();
        state.server = server;
        state.serverContext = new TlsServerContextImpl(server.getCrypto());
        server.init(state.serverContext);
        state.serverContext.handshakeBeginning(server);
        SecurityParameters securityParameters = state.serverContext.getSecurityParametersHandshake();
        securityParameters.extendedPadding = server.shouldUseExtendedPadding();
        DTLSRecordLayer recordLayer = new DTLSRecordLayer(state.serverContext, state.server, transport);
        server.notifyCloseHandle(recordLayer);
        try {
            DTLSTransport dTLSTransport = this.serverHandshake(state, recordLayer, request);
            return dTLSTransport;
        }
        catch (TlsFatalAlert fatalAlert) {
            this.abortServerHandshake(state, recordLayer, fatalAlert.getAlertDescription());
            throw fatalAlert;
        }
        catch (IOException e) {
            this.abortServerHandshake(state, recordLayer, (short)80);
            throw e;
        }
        catch (RuntimeException e) {
            this.abortServerHandshake(state, recordLayer, (short)80);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        finally {
            securityParameters.clear();
        }
    }

    protected void abortServerHandshake(ServerHandshakeState state, DTLSRecordLayer recordLayer, short alertDescription) {
        recordLayer.fail(alertDescription);
        this.invalidateSession(state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DTLSTransport serverHandshake(ServerHandshakeState state, DTLSRecordLayer recordLayer, DTLSRequest request) throws IOException {
        byte[] serverKeyExchange;
        CertificateStatus certificateStatus;
        SecurityParameters securityParameters = state.serverContext.getSecurityParametersHandshake();
        DTLSReliableHandshake handshake = new DTLSReliableHandshake(state.serverContext, recordLayer, state.server.getHandshakeTimeoutMillis(), request);
        DTLSReliableHandshake.Message clientMessage = null;
        if (null == request) {
            clientMessage = handshake.receiveMessage();
            if (clientMessage.getType() != 1) throw new TlsFatalAlert(10);
            this.processClientHello(state, clientMessage.getBody());
        } else {
            this.processClientHello(state, request.getClientHello());
        }
        state.tlsSession = TlsUtils.importSession(TlsUtils.EMPTY_BYTES, null);
        state.sessionParameters = null;
        state.sessionMasterSecret = null;
        securityParameters.sessionID = state.tlsSession.getSessionID();
        state.server.notifySession(state.tlsSession);
        byte[] serverHelloBody = this.generateServerHello(state, recordLayer);
        ProtocolVersion recordLayerVersion = state.serverContext.getServerVersion();
        recordLayer.setReadVersion(recordLayerVersion);
        recordLayer.setWriteVersion(recordLayerVersion);
        handshake.sendMessage((short)2, serverHelloBody);
        handshake.getHandshakeHash().notifyPRFDetermined();
        Vector serverSupplementalData = state.server.getServerSupplementalData();
        if (serverSupplementalData != null) {
            byte[] supplementalDataBody = DTLSServerProtocol.generateSupplementalData(serverSupplementalData);
            handshake.sendMessage((short)23, supplementalDataBody);
        }
        state.keyExchange = TlsUtils.initKeyExchangeServer(state.serverContext, state.server);
        state.serverCredentials = null;
        if (!KeyExchangeAlgorithm.isAnonymous(securityParameters.getKeyExchangeAlgorithm())) {
            state.serverCredentials = TlsUtils.establishServerCredentials(state.server);
        }
        Certificate serverCertificate = null;
        ByteArrayOutputStream endPointHash = new ByteArrayOutputStream();
        if (state.serverCredentials == null) {
            state.keyExchange.skipServerCredentials();
        } else {
            state.keyExchange.processServerCredentials(state.serverCredentials);
            serverCertificate = state.serverCredentials.getCertificate();
            DTLSServerProtocol.sendCertificateMessage(state.serverContext, handshake, serverCertificate, endPointHash);
        }
        securityParameters.tlsServerEndPoint = endPointHash.toByteArray();
        if (serverCertificate == null || serverCertificate.isEmpty()) {
            securityParameters.statusRequestVersion = 0;
        }
        if (securityParameters.getStatusRequestVersion() > 0 && (certificateStatus = state.server.getCertificateStatus()) != null) {
            byte[] certificateStatusBody = this.generateCertificateStatus(state, certificateStatus);
            handshake.sendMessage((short)22, certificateStatusBody);
        }
        if ((serverKeyExchange = state.keyExchange.generateServerKeyExchange()) != null) {
            handshake.sendMessage((short)12, serverKeyExchange);
        }
        if (state.serverCredentials != null) {
            state.certificateRequest = state.server.getCertificateRequest();
            if (null == state.certificateRequest) {
                if (!state.keyExchange.requiresCertificateVerify()) {
                    throw new TlsFatalAlert(80);
                }
            } else {
                if (TlsUtils.isTLSv12(state.serverContext) != (state.certificateRequest.getSupportedSignatureAlgorithms() != null)) {
                    throw new TlsFatalAlert(80);
                }
                state.certificateRequest = TlsUtils.validateCertificateRequest(state.certificateRequest, state.keyExchange);
                TlsUtils.establishServerSigAlgs(securityParameters, state.certificateRequest);
                if (ProtocolVersion.DTLSv12.equals(securityParameters.getNegotiatedVersion())) {
                    TlsUtils.trackHashAlgorithms(handshake.getHandshakeHash(), securityParameters.getServerSigAlgs());
                    if (state.serverContext.getCrypto().hasAnyStreamVerifiers(securityParameters.getServerSigAlgs())) {
                        handshake.getHandshakeHash().forceBuffering();
                    }
                } else if (state.serverContext.getCrypto().hasAnyStreamVerifiersLegacy(state.certificateRequest.getCertificateTypes())) {
                    handshake.getHandshakeHash().forceBuffering();
                }
            }
        }
        handshake.getHandshakeHash().sealHashAlgorithms();
        if (null != state.certificateRequest) {
            byte[] certificateRequestBody = this.generateCertificateRequest(state, state.certificateRequest);
            handshake.sendMessage((short)13, certificateRequestBody);
        }
        handshake.sendMessage((short)14, TlsUtils.EMPTY_BYTES);
        clientMessage = handshake.receiveMessage();
        if (clientMessage.getType() == 23) {
            this.processClientSupplementalData(state, clientMessage.getBody());
            clientMessage = handshake.receiveMessage();
        } else {
            state.server.processClientSupplementalData(null);
        }
        if (state.certificateRequest == null) {
            state.keyExchange.skipClientCredentials();
        } else if (clientMessage.getType() == 11) {
            this.processClientCertificate(state, clientMessage.getBody());
            clientMessage = handshake.receiveMessage();
        } else {
            if (TlsUtils.isTLSv12(state.serverContext)) {
                throw new TlsFatalAlert(10);
            }
            this.notifyClientCertificate(state, Certificate.EMPTY_CHAIN);
        }
        if (clientMessage.getType() != 16) {
            throw new TlsFatalAlert(10);
        }
        this.processClientKeyExchange(state, clientMessage.getBody());
        securityParameters.sessionHash = TlsUtils.getCurrentPRFHash(handshake.getHandshakeHash());
        TlsProtocol.establishMasterSecret(state.serverContext, state.keyExchange);
        recordLayer.initPendingEpoch(TlsUtils.initCipher(state.serverContext));
        if (this.expectCertificateVerifyMessage(state)) {
            clientMessage = handshake.receiveMessageDelayedDigest((short)15);
            byte[] certificateVerifyBody = clientMessage.getBody();
            this.processCertificateVerify(state, certificateVerifyBody, handshake.getHandshakeHash());
            handshake.prepareToFinish();
            handshake.updateHandshakeMessagesDigest(clientMessage);
        } else {
            handshake.prepareToFinish();
        }
        securityParameters.peerVerifyData = TlsUtils.calculateVerifyData(state.serverContext, handshake.getHandshakeHash(), false);
        this.processFinished(handshake.receiveMessageBody((short)20), securityParameters.getPeerVerifyData());
        if (state.expectSessionTicket) {
            NewSessionTicket newSessionTicket = state.server.getNewSessionTicket();
            byte[] newSessionTicketBody = this.generateNewSessionTicket(state, newSessionTicket);
            handshake.sendMessage((short)4, newSessionTicketBody);
        }
        securityParameters.localVerifyData = TlsUtils.calculateVerifyData(state.serverContext, handshake.getHandshakeHash(), true);
        handshake.sendMessage((short)20, securityParameters.getLocalVerifyData());
        handshake.finish();
        state.sessionMasterSecret = securityParameters.getMasterSecret();
        state.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setCompressionAlgorithm(securityParameters.getCompressionAlgorithm()).setExtendedMasterSecret(securityParameters.isExtendedMasterSecret()).setLocalCertificate(securityParameters.getLocalCertificate()).setMasterSecret(state.serverContext.getCrypto().adoptSecret(state.sessionMasterSecret)).setNegotiatedVersion(securityParameters.getNegotiatedVersion()).setPeerCertificate(securityParameters.getPeerCertificate()).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(state.serverExtensions).build();
        state.tlsSession = TlsUtils.importSession(state.tlsSession.getSessionID(), state.sessionParameters);
        securityParameters.tlsUnique = securityParameters.getPeerVerifyData();
        state.serverContext.handshakeComplete(state.server, state.tlsSession);
        recordLayer.initHeartbeat(state.heartbeat, 1 == state.heartbeatPolicy);
        return new DTLSTransport(recordLayer);
    }

    protected byte[] generateCertificateRequest(ServerHandshakeState state, CertificateRequest certificateRequest) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        certificateRequest.encode(state.serverContext, buf);
        return buf.toByteArray();
    }

    protected byte[] generateCertificateStatus(ServerHandshakeState state, CertificateStatus certificateStatus) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        certificateStatus.encode(buf);
        return buf.toByteArray();
    }

    protected byte[] generateNewSessionTicket(ServerHandshakeState state, NewSessionTicket newSessionTicket) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        newSessionTicket.encode(buf);
        return buf.toByteArray();
    }

    protected byte[] generateServerHello(ServerHandshakeState state, DTLSRecordLayer recordLayer) throws IOException {
        int cipherSuite;
        TlsServerContextImpl context = state.serverContext;
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        ProtocolVersion server_version = state.server.getServerVersion();
        if (!ProtocolVersion.contains(context.getClientSupportedVersions(), server_version)) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.negotiatedVersion = server_version;
        TlsUtils.negotiatedVersionDTLSServer(context);
        boolean useGMTUnixTime = ProtocolVersion.DTLSv12.isEqualOrLaterVersionOf(server_version) && state.server.shouldUseGMTUnixTime();
        securityParameters.serverRandom = TlsProtocol.createRandomBlock(useGMTUnixTime, context);
        if (!server_version.equals(ProtocolVersion.getLatestDTLS(state.server.getProtocolVersions()))) {
            TlsUtils.writeDowngradeMarker(server_version, securityParameters.getServerRandom());
        }
        if (!TlsUtils.isValidCipherSuiteSelection(state.offeredCipherSuites, cipherSuite = DTLSServerProtocol.validateSelectedCipherSuite(state.server.getSelectedCipherSuite(), (short)80)) || !TlsUtils.isValidVersionForCipherSuite(cipherSuite, securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.negotiatedCipherSuite(securityParameters, cipherSuite);
        state.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(state.server.getServerExtensions());
        state.server.getServerExtensionsForConnection(state.serverExtensions);
        ProtocolVersion legacy_version = server_version;
        if (server_version.isLaterVersionOf(ProtocolVersion.DTLSv12)) {
            legacy_version = ProtocolVersion.DTLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionServer(state.serverExtensions, server_version);
        }
        if (securityParameters.isSecureRenegotiation()) {
            boolean noRenegExt;
            byte[] renegExtData = TlsUtils.getExtensionData(state.serverExtensions, TlsProtocol.EXT_RenegotiationInfo);
            boolean bl = noRenegExt = null == renegExtData;
            if (noRenegExt) {
                state.serverExtensions.put(TlsProtocol.EXT_RenegotiationInfo, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (TlsUtils.isTLSv13(server_version)) {
            securityParameters.extendedMasterSecret = true;
        } else {
            boolean bl = securityParameters.extendedMasterSecret = state.offeredExtendedMasterSecret && state.server.shouldUseExtendedMasterSecret();
            if (securityParameters.isExtendedMasterSecret()) {
                TlsExtensionsUtils.addExtendedMasterSecretExtension(state.serverExtensions);
            } else {
                if (state.server.requiresExtendedMasterSecret()) {
                    throw new TlsFatalAlert(40);
                }
                if (state.resumedSession && !state.server.allowLegacyResumption()) {
                    throw new TlsFatalAlert(80);
                }
            }
        }
        if (null != state.heartbeat || 1 == state.heartbeatPolicy) {
            TlsExtensionsUtils.addHeartbeatExtension(state.serverExtensions, new HeartbeatExtension(state.heartbeatPolicy));
        }
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(state.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        if (!state.serverExtensions.isEmpty()) {
            securityParameters.encryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(state.serverExtensions);
            securityParameters.maxFragmentLength = DTLSServerProtocol.evaluateMaxFragmentLengthExtension(state.resumedSession, state.clientExtensions, state.serverExtensions, (short)80);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(state.serverExtensions);
            if (!state.resumedSession) {
                if (TlsUtils.hasExpectedEmptyExtensionData(state.serverExtensions, TlsExtensionsUtils.EXT_status_request_v2, (short)80)) {
                    securityParameters.statusRequestVersion = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData(state.serverExtensions, TlsExtensionsUtils.EXT_status_request, (short)80)) {
                    securityParameters.statusRequestVersion = 1;
                }
            }
            state.expectSessionTicket = !state.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(state.serverExtensions, TlsProtocol.EXT_SessionTicket, (short)80);
        }
        DTLSServerProtocol.applyMaxFragmentLengthExtension(recordLayer, securityParameters.getMaxFragmentLength());
        ServerHello serverHello = new ServerHello(legacy_version, securityParameters.getServerRandom(), state.tlsSession.getSessionID(), securityParameters.getCipherSuite(), state.serverExtensions);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        serverHello.encode(state.serverContext, buf);
        return buf.toByteArray();
    }

    protected void invalidateSession(ServerHandshakeState state) {
        if (state.sessionMasterSecret != null) {
            state.sessionMasterSecret.destroy();
            state.sessionMasterSecret = null;
        }
        if (state.sessionParameters != null) {
            state.sessionParameters.clear();
            state.sessionParameters = null;
        }
        if (state.tlsSession != null) {
            state.tlsSession.invalidate();
            state.tlsSession = null;
        }
    }

    protected void notifyClientCertificate(ServerHandshakeState state, Certificate clientCertificate) throws IOException {
        if (null == state.certificateRequest) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.processClientCertificate(state.serverContext, clientCertificate, state.keyExchange, state.server);
    }

    protected void processClientCertificate(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        Certificate.ParseOptions options = new Certificate.ParseOptions().setCertificateType(TlsExtensionsUtils.getClientCertificateTypeExtensionServer(state.clientExtensions, (short)0)).setMaxChainLength(state.server.getMaxCertificateChainLength());
        Certificate clientCertificate = Certificate.parse(options, state.serverContext, buf, null);
        TlsProtocol.assertEmpty(buf);
        this.notifyClientCertificate(state, clientCertificate);
    }

    protected void processCertificateVerify(ServerHandshakeState state, byte[] body, TlsHandshakeHash handshakeHash) throws IOException {
        if (state.certificateRequest == null) {
            throw new IllegalStateException();
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        TlsServerContextImpl context = state.serverContext;
        DigitallySigned certificateVerify = DigitallySigned.parse(context, buf);
        TlsProtocol.assertEmpty(buf);
        TlsUtils.verifyCertificateVerifyClient(context, state.certificateRequest, certificateVerify, handshakeHash);
    }

    protected void processClientHello(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        ClientHello clientHello = ClientHello.parse(buf, NullOutputStream.INSTANCE);
        this.processClientHello(state, clientHello);
    }

    protected void processClientHello(ServerHandshakeState state, ClientHello clientHello) throws IOException {
        byte[] renegExtData;
        ProtocolVersion legacy_version = clientHello.getVersion();
        state.offeredCipherSuites = clientHello.getCipherSuites();
        state.clientExtensions = clientHello.getExtensions();
        TlsServerContextImpl context = state.serverContext;
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        if (!legacy_version.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        context.setRSAPreMasterSecretVersion(legacy_version);
        context.setClientSupportedVersions(TlsExtensionsUtils.getSupportedVersionsExtensionClient(state.clientExtensions));
        ProtocolVersion client_version = legacy_version;
        if (null == context.getClientSupportedVersions()) {
            if (client_version.isLaterVersionOf(ProtocolVersion.DTLSv12)) {
                client_version = ProtocolVersion.DTLSv12;
            }
            context.setClientSupportedVersions(client_version.downTo(ProtocolVersion.DTLSv10));
        } else {
            client_version = ProtocolVersion.getLatestDTLS(context.getClientSupportedVersions());
        }
        if (!ProtocolVersion.SERVER_EARLIEST_SUPPORTED_DTLS.isEqualOrEarlierVersionOf(client_version)) {
            throw new TlsFatalAlert(70);
        }
        context.setClientVersion(client_version);
        state.server.notifyClientVersion(context.getClientVersion());
        securityParameters.clientRandom = clientHello.getRandom();
        state.server.notifyFallback(Arrays.contains(state.offeredCipherSuites, 22016));
        state.server.notifyOfferedCipherSuites(state.offeredCipherSuites);
        if (Arrays.contains(state.offeredCipherSuites, 255)) {
            securityParameters.secureRenegotiation = true;
        }
        if ((renegExtData = TlsUtils.getExtensionData(state.clientExtensions, TlsProtocol.EXT_RenegotiationInfo)) != null) {
            securityParameters.secureRenegotiation = true;
            if (!Arrays.constantTimeAreEqual(renegExtData, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        state.server.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        state.offeredExtendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension(state.clientExtensions);
        if (state.clientExtensions != null) {
            TlsExtensionsUtils.getPaddingExtension(state.clientExtensions);
            securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(state.clientExtensions);
            if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(client_version)) {
                TlsUtils.establishClientSigAlgs(securityParameters, state.clientExtensions);
            }
            securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(state.clientExtensions);
            HeartbeatExtension heartbeatExtension = TlsExtensionsUtils.getHeartbeatExtension(state.clientExtensions);
            if (null != heartbeatExtension) {
                if (1 == heartbeatExtension.getMode()) {
                    state.heartbeat = state.server.getHeartbeat();
                }
                state.heartbeatPolicy = state.server.getHeartbeatPolicy();
            }
            state.server.processClientExtensions(state.clientExtensions);
        }
    }

    protected void processClientKeyExchange(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        state.keyExchange.processClientKeyExchange(buf);
        TlsProtocol.assertEmpty(buf);
    }

    protected void processClientSupplementalData(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        Vector clientSupplementalData = TlsProtocol.readSupplementalDataMessage(buf);
        state.server.processClientSupplementalData(clientSupplementalData);
    }

    protected boolean expectCertificateVerifyMessage(ServerHandshakeState state) {
        if (null == state.certificateRequest) {
            return false;
        }
        Certificate clientCertificate = state.serverContext.getSecurityParametersHandshake().getPeerCertificate();
        return null != clientCertificate && !clientCertificate.isEmpty() && (null == state.keyExchange || state.keyExchange.requiresCertificateVerify());
    }

    protected static class ServerHandshakeState {
        TlsServer server = null;
        TlsServerContextImpl serverContext = null;
        TlsSession tlsSession = null;
        SessionParameters sessionParameters = null;
        TlsSecret sessionMasterSecret = null;
        SessionParameters.Builder sessionParametersBuilder = null;
        int[] offeredCipherSuites = null;
        Hashtable clientExtensions = null;
        Hashtable serverExtensions = null;
        boolean offeredExtendedMasterSecret = false;
        boolean resumedSession = false;
        boolean expectSessionTicket = false;
        TlsKeyExchange keyExchange = null;
        TlsCredentials serverCredentials = null;
        CertificateRequest certificateRequest = null;
        TlsHeartbeat heartbeat = null;
        short heartbeatPolicy = (short)2;

        protected ServerHandshakeState() {
        }
    }
}

