/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

public class ContentType {
    public static final short change_cipher_spec = 20;
    public static final short alert = 21;
    public static final short handshake = 22;
    public static final short application_data = 23;
    public static final short heartbeat = 24;

    public static String getName(short contentType) {
        switch (contentType) {
            case 21: {
                return "alert";
            }
            case 23: {
                return "application_data";
            }
            case 20: {
                return "change_cipher_spec";
            }
            case 22: {
                return "handshake";
            }
            case 24: {
                return "heartbeat";
            }
        }
        return "UNKNOWN";
    }

    public static String getText(short contentType) {
        return ContentType.getName(contentType) + "(" + contentType + ")";
    }
}

