/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCloseable;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHeartbeat;
import org.bouncycastle.tls.TlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.crypto.TlsCrypto;

public abstract class AbstractTlsPeer
implements TlsPeer {
    private final TlsCrypto crypto;
    private volatile TlsCloseable closeHandle;

    protected AbstractTlsPeer(TlsCrypto crypto) {
        this.crypto = crypto;
    }

    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv13.downTo(ProtocolVersion.TLSv12);
    }

    protected abstract int[] getSupportedCipherSuites();

    public void cancel() throws IOException {
        TlsCloseable closeHandle = this.closeHandle;
        if (null != closeHandle) {
            closeHandle.close();
        }
    }

    public TlsCrypto getCrypto() {
        return this.crypto;
    }

    public void notifyCloseHandle(TlsCloseable closeHandle) {
        this.closeHandle = closeHandle;
    }

    public void notifyHandshakeBeginning() throws IOException {
    }

    public int getHandshakeTimeoutMillis() {
        return 0;
    }

    public boolean allowLegacyResumption() {
        return false;
    }

    public int getMaxCertificateChainLength() {
        return 10;
    }

    public int getMaxHandshakeMessageSize() {
        return 32768;
    }

    public short[] getPskKeyExchangeModes() {
        return new short[]{1};
    }

    public boolean requiresCloseNotify() {
        return true;
    }

    public boolean requiresExtendedMasterSecret() {
        return false;
    }

    public boolean shouldCheckSigAlgOfPeerCerts() {
        return true;
    }

    public boolean shouldUseExtendedMasterSecret() {
        return true;
    }

    public boolean shouldUseExtendedPadding() {
        return false;
    }

    public boolean shouldUseGMTUnixTime() {
        return false;
    }

    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        if (!secureRenegotiation) {
            throw new TlsFatalAlert(40);
        }
    }

    public TlsKeyExchangeFactory getKeyExchangeFactory() throws IOException {
        return new DefaultTlsKeyExchangeFactory();
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
    }

    public void notifyHandshakeComplete() throws IOException {
    }

    public TlsHeartbeat getHeartbeat() {
        return null;
    }

    public short getHeartbeatPolicy() {
        return 2;
    }

    public int getRenegotiationPolicy() {
        return 0;
    }
}

