/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.client.request;

import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.KrbContext;
import org.apache.kerby.kerberos.kerb.client.KrbOption;
import org.apache.kerby.kerberos.kerb.client.request.KdcRequest;
import org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.kdc.EncTgsRepPart;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcRep;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcReqBody;
import org.apache.kerby.kerberos.kerb.type.kdc.TgsRep;
import org.apache.kerby.kerberos.kerb.type.kdc.TgsReq;
import org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TgsRequest
extends KdcRequest {
    private static final Logger LOG = LoggerFactory.getLogger(TgsRequest.class);

    public TgsRequest(KrbContext context) {
        super(context);
    }

    @Override
    public PrincipalName getClientPrincipal() {
        return null;
    }

    @Override
    public EncryptionKey getClientKey() throws KrbException {
        return null;
    }

    public EncryptionKey getSessionKey() {
        return null;
    }

    @Override
    public void process() throws KrbException {
        if (this.getServerPrincipal() == null) {
            String serverPrincipalString = this.getRequestOptions().getStringOption(KrbOption.SERVER_PRINCIPAL);
            if (serverPrincipalString == null) {
                LOG.warn("Server principal is null.");
            }
            this.setServerPrincipal(new PrincipalName(serverPrincipalString));
        }
        super.process();
        TgsReq tgsReq = new TgsReq();
        KdcReqBody tgsReqBody = this.getReqBody(null);
        tgsReq.setReqBody(tgsReqBody);
        tgsReq.setPaData(this.getPreauthContext().getOutputPaData());
        this.setKdcReq(tgsReq);
    }

    @Override
    public void processResponse(KdcRep kdcRep) throws KrbException {
        EncTgsRepPart encTgsRepPart;
        this.setKdcRep(kdcRep);
        TgsRep tgsRep = (TgsRep)this.getKdcRep();
        try {
            encTgsRepPart = EncryptionUtil.unseal(tgsRep.getEncryptedEncPart(), this.getSessionKey(), KeyUsage.TGS_REP_ENCPART_SESSKEY, EncTgsRepPart.class);
        }
        catch (KrbException e) {
            encTgsRepPart = EncryptionUtil.unseal(tgsRep.getEncryptedEncPart(), this.getSessionKey(), KeyUsage.TGS_REP_ENCPART_SUBKEY, EncTgsRepPart.class);
        }
        tgsRep.setEncPart(encTgsRepPart);
        if (this.getChosenNonce() != encTgsRepPart.getNonce()) {
            LOG.error("Nonce " + this.getChosenNonce() + "didn't match " + encTgsRepPart.getNonce());
            throw new KrbException("Nonce didn't match");
        }
    }

    public SgtTicket getSgt() {
        SgtTicket serviceTkt = new SgtTicket(this.getKdcRep().getTicket(), (EncTgsRepPart)this.getKdcRep().getEncPart());
        return serviceTkt;
    }
}

