/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseMapRUtil {
    private static final String MAPR_ENV_VAR = "MAPR_HOME";
    private static final String MAPR_PROPERTY_HOME = "mapr.home.dir";
    private static final String MAPR_HOME_PATH_DEFAULT = "/opt/mapr";
    public static final String HOST_NAME_FILE_PATH = BaseMapRUtil.getPathToMaprHome() + "/hostname";
    private static String hostname = null;
    private static final Logger LOG = LoggerFactory.getLogger(BaseMapRUtil.class);

    public static String getPathToMaprHome() {
        String maprHome = System.getenv(MAPR_ENV_VAR);
        if (maprHome == null && (maprHome = System.getProperty(MAPR_PROPERTY_HOME)) == null) {
            return MAPR_HOME_PATH_DEFAULT;
        }
        return maprHome;
    }

    public static synchronized String getMapRHostName() {
        if (hostname == null) {
            hostname = BaseMapRUtil.readMapRHostNameFromFile(HOST_NAME_FILE_PATH);
        }
        return hostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readMapRHostNameFromFile(String filePath) {
        if (!new File(filePath).exists()) {
            LOG.debug(filePath + " does not exist. Assuming client-only installation..");
            return "MAPR_CLIENT";
        }
        FileReader freader = null;
        BufferedReader breader = null;
        try {
            freader = new FileReader(filePath);
            breader = new BufferedReader(freader);
            String string = breader.readLine();
            return string;
        }
        catch (Exception e) {
            LOG.warn("Error while reading " + filePath, e);
        }
        finally {
            try {
                if (breader != null) {
                    breader.close();
                }
            }
            catch (IOException t2) {
                LOG.error("Failed to close buffered reader", t2);
            }
            try {
                if (freader != null) {
                    freader.close();
                }
            }
            catch (IOException t3) {
                LOG.error("Failed to close " + filePath, t3);
            }
        }
        return null;
    }

    public static synchronized void setMapRHostName(String host) {
        if (hostname == null) {
            hostname = host;
        }
    }
}

