/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.DynamicLoginConfiguration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.KerberosAuthException;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.login.HadoopLoginModule;
import org.apache.hadoop.security.rpcauth.RpcAuthMethod;
import org.apache.hadoop.security.rpcauth.RpcAuthRegistry;
import org.apache.hadoop.security.scram.ScramSaslClientProvider;
import org.apache.hadoop.security.scram.ScramSaslServerProvider;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class UserGroupInformation {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(UserGroupInformation.class);
    private static final float TICKET_RENEW_WINDOW = 0.8f;
    private static boolean shouldRenewImmediatelyForTests = false;
    static final String HADOOP_USER_NAME = "HADOOP_USER_NAME";
    static final String HADOOP_PROXY_USER = "HADOOP_PROXY_USER";
    private static final String HADOOP_SECURITY_SPOOF_USER = "hadoop.spoof.user";
    private static final String HADOOP_SECURITY_SPOOFED_USER = "hadoop.spoofed.user.username";
    private static boolean spoofUser = false;
    private static String spoofedUser;
    static UgiMetrics metrics;
    private static AuthenticationMethod authenticationMethod;
    private static Groups groups;
    private static long kerberosMinSecondsBeforeRelogin;
    private static boolean kerberosKeyTabLoginRenewalEnabled;
    private static Optional<ExecutorService> kerberosLoginRenewalExecutor;
    private static Configuration conf;
    private static String userJAASConfName;
    private static String serviceJAASConfName;
    public static final String HADOOP_TOKEN_FILE_LOCATION = "HADOOP_TOKEN_FILE_LOCATION";
    public static final String HADOOP_TOKEN = "HADOOP_TOKEN";
    private static Class<? extends Principal> customAuthPrincipalClass;
    private static Class<? extends RpcAuthMethod> customRpcAuthMethodClass;
    public static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    public static final String DEFAULT_JAVA_SECURITY_AUTH_LOGIN_CONFIG;
    public static final String SCRAM_AUTH_MECHANISM = "SCRAM-SHA-256";
    public static final String DIGEST_AUTH_MECHANISM = "DIGEST-MD5";
    private static final AtomicReference<UserGroupInformation> loginUserRef;
    private final Subject subject;
    private final User user;
    private List<RpcAuthMethod> rpcAuthMethodList;
    private static final boolean windows;

    @VisibleForTesting
    public static void setShouldRenewImmediatelyForTests(boolean immediate) {
        shouldRenewImmediatelyForTests = immediate;
    }

    private static void checkSpoofing(Configuration conf) {
        spoofUser = conf.getBoolean(HADOOP_SECURITY_SPOOF_USER, windows);
        if (!spoofUser) {
            return;
        }
        spoofedUser = conf.get(HADOOP_SECURITY_SPOOFED_USER, "root");
    }

    public static void reattachMetrics() {
        UgiMetrics.reattach();
    }

    public static boolean isInitialized() {
        return conf != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureInitialized() {
        if (UserGroupInformation.isInitialized()) return;
        Class<UserGroupInformation> clazz = UserGroupInformation.class;
        synchronized (UserGroupInformation.class) {
            if (UserGroupInformation.isInitialized()) return;
            UserGroupInformation.initialize(new Configuration(), false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static synchronized void initialize(Configuration conf, boolean overrideNameRules) {
        int[] intervals;
        String loginConfPath;
        AuthenticationMethod authenticationMethodFromConf = UserGroupInformation.getAuthenticationMethodFromConfiguration(conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("HADOOP_SECURITY_AUTHENTICATION is set to: " + (Object)((Object)authenticationMethodFromConf));
        }
        if (authenticationMethodFromConf == null || authenticationMethodFromConf.equals((Object)AuthenticationMethod.SIMPLE)) {
            UserGroupInformation.checkSpoofing(conf);
        } else {
            customAuthPrincipalClass = SecurityUtil.getCustomAuthPrincipal(conf);
            customRpcAuthMethodClass = SecurityUtil.getCustomRpcAuthMethod(conf);
        }
        String jaasConfName = null;
        if (authenticationMethodFromConf == AuthenticationMethod.SIMPLE) {
            jaasConfName = "simple";
        } else {
            LOG.debug("Security is enabled.");
            jaasConfName = System.getProperty("hadoop.login");
            if (jaasConfName == null) {
                jaasConfName = conf.get("hadoop.login", "default");
            }
        }
        userJAASConfName = jaasConfName.startsWith("hadoop_") ? jaasConfName : "hadoop_" + jaasConfName;
        String string = serviceJAASConfName = userJAASConfName.endsWith("_keytab") ? userJAASConfName : userJAASConfName + "_keytab";
        if (LOG.isDebugEnabled()) {
            LOG.debug("Login configuration entry is " + userJAASConfName);
        }
        if ((loginConfPath = System.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG)) == null && (loginConfPath = conf.get(JAVA_SECURITY_AUTH_LOGIN_CONFIG, DEFAULT_JAVA_SECURITY_AUTH_LOGIN_CONFIG)) != null) {
            System.setProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG, loginConfPath);
            loginConfPath = System.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG);
            LOG.info("Java System property 'java.security.auth.login.config' not set, unilaterally setting to " + loginConfPath);
        }
        if (loginConfPath == null || !new File(loginConfPath).canRead()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(loginConfPath + " either null or can not be read. Trying to load 'java.security.auth.login.config' from jar");
            }
            String javaSecurityJarPath = conf.get("hadoop.security.java.security.login.config.jar.path");
            URL javaSecurityURL = null;
            if (javaSecurityJarPath != null && (javaSecurityURL = UserGroupInformation.class.getResource(javaSecurityJarPath)) != null) {
                loginConfPath = javaSecurityURL.toExternalForm();
                System.setProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG, loginConfPath);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Loading 'java.security.auth.login.config' from: " + loginConfPath);
                }
            }
            if (javaSecurityJarPath == null || javaSecurityURL == null) {
                LOG.warn("'java.security.auth.login.config' is not configured either in Hadoop configuration or via Java property or not loaded from jar, may cause login failure");
            }
        }
        UserGroupInformation.setUGIAuthenticationMethodFromJAASConfiguration(jaasConfName);
        String authTokenMethod = conf.get("hadoop.security.token.authentication.method", DIGEST_AUTH_MECHANISM);
        if (authTokenMethod.equalsIgnoreCase(SCRAM_AUTH_MECHANISM)) {
            ScramSaslClientProvider.initialize();
            ScramSaslServerProvider.initialize();
        }
        if (overrideNameRules || !HadoopKerberosName.hasRulesBeenSet()) {
            try {
                HadoopKerberosName.setConfiguration(conf);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Problem with Kerberos auth_to_local name configuration", ioe);
            }
        }
        try {
            kerberosMinSecondsBeforeRelogin = 1000L * conf.getLong("hadoop.kerberos.min.seconds.before.relogin", 60L);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid attribute value for hadoop.kerberos.min.seconds.before.relogin of " + conf.get("hadoop.kerberos.min.seconds.before.relogin"));
        }
        kerberosKeyTabLoginRenewalEnabled = conf.getBoolean("hadoop.kerberos.keytab.login.autorenewal.enabled", false);
        if (!(groups instanceof TestingGroups)) {
            groups = Groups.getUserToGroupsMappingService(conf);
        }
        UserGroupInformation.conf = conf;
        if (UserGroupInformation.metrics.getGroupsQuantiles == null && (intervals = conf.getInts("hadoop.user.group.metrics.percentiles.intervals")) != null && intervals.length > 0) {
            int length = intervals.length;
            MutableQuantiles[] getGroupsQuantiles = new MutableQuantiles[length];
            for (int i = 0; i < length; ++i) {
                getGroupsQuantiles[i] = UserGroupInformation.metrics.registry.newQuantiles("getGroups" + intervals[i] + "s", "Get groups", "ops", "latency", intervals[i]);
            }
            UserGroupInformation.metrics.getGroupsQuantiles = getGroupsQuantiles;
        }
    }

    private static AuthenticationMethod getAuthenticationMethodFromConfiguration(Configuration conf) {
        String value = conf.get("hadoop.security.authentication", "simple");
        try {
            return Enum.valueOf(AuthenticationMethod.class, value.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Invalid attribute value for hadoop.security.authentication of " + value);
        }
    }

    private static void setUGIAuthenticationMethodFromJAASConfiguration(String jaasConfName) {
        authenticationMethod = jaasConfName.contains("simple") ? AuthenticationMethod.SIMPLE : (jaasConfName.contains("kerberos") ? AuthenticationMethod.KERBEROS : AuthenticationMethod.CUSTOM);
        if (LOG.isDebugEnabled()) {
            LOG.debug("authenticationMethod from JAAS configuration:" + (Object)((Object)authenticationMethod));
        }
    }

    public static AuthenticationMethod getUGIAuthenticationMethod() {
        if (authenticationMethod == null) {
            UserGroupInformation.ensureInitialized();
        }
        return authenticationMethod;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void setConfiguration(Configuration conf) {
        UserGroupInformation.initialize(conf, true);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static void reset() {
        authenticationMethod = null;
        conf = null;
        groups = null;
        kerberosMinSecondsBeforeRelogin = 0L;
        kerberosKeyTabLoginRenewalEnabled = false;
        kerberosLoginRenewalExecutor = Optional.empty();
        UserGroupInformation.setLoginUser(null);
        HadoopKerberosName.setRules(null);
    }

    public static boolean isSecurityEnabled() {
        return !UserGroupInformation.isAuthenticationMethodEnabled(AuthenticationMethod.SIMPLE);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    private static boolean isAuthenticationMethodEnabled(AuthenticationMethod method) {
        UserGroupInformation.ensureInitialized();
        return authenticationMethod == method;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    @VisibleForTesting
    static boolean isKerberosKeyTabLoginRenewalEnabled() {
        UserGroupInformation.ensureInitialized();
        return kerberosKeyTabLoginRenewalEnabled;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    @VisibleForTesting
    static Optional<ExecutorService> getKerberosLoginRenewalExecutor() {
        UserGroupInformation.ensureInitialized();
        return kerberosLoginRenewalExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HadoopLoginContext newLoginContext(String appName, Subject subject, Map<String, ?> overrideOptions) throws LoginException {
        Thread t2 = Thread.currentThread();
        ClassLoader oldCCL = t2.getContextClassLoader();
        t2.setContextClassLoader(HadoopLoginModule.class.getClassLoader());
        try {
            if (overrideOptions != null) {
                DynamicLoginConfiguration cfg = new DynamicLoginConfiguration(UserGroupInformation.getJAASConf(), overrideOptions);
                HadoopLoginContext hadoopLoginContext = new HadoopLoginContext(appName, subject, cfg);
                return hadoopLoginContext;
            }
            HadoopLoginContext hadoopLoginContext = new HadoopLoginContext(appName, subject);
            return hadoopLoginContext;
        }
        finally {
            t2.setContextClassLoader(oldCCL);
        }
    }

    private static javax.security.auth.login.Configuration getJAASConf() {
        return javax.security.auth.login.Configuration.getConfiguration();
    }

    private HadoopLoginContext getLogin() {
        LoginContext login = this.user.getLogin();
        return login instanceof HadoopLoginContext ? (HadoopLoginContext)login : null;
    }

    private void setLogin(LoginContext login) {
        this.user.setLogin(login);
    }

    private void setLastLogin(long loginTime) {
        this.user.setLastLogin(loginTime);
    }

    private void configureRpcAuthMethods(String confName) {
        ArrayList authMethodList = new ArrayList();
        if (UserGroupInformation.isSecurityEnabled() && confName != null) {
            LinkedHashSet<RpcAuthMethod> authMethods = new LinkedHashSet<RpcAuthMethod>();
            AppConfigurationEntry[] appInfo = UserGroupInformation.getJAASConf().getAppConfigurationEntry(confName);
            for (int i = 0; appInfo != null && i < appInfo.length; ++i) {
                String module = appInfo[i].getLoginModuleName();
                RpcAuthMethod rpcAuthMethod = RpcAuthRegistry.getAuthMethodForLoginModule(module);
                if (rpcAuthMethod == null) continue;
                authMethods.add(rpcAuthMethod);
            }
            if (UserGroupInformation.isSecurityEnabled() && !"hadoop_simple".equals(confName) && authMethods.size() == 0) {
                LOG.warn("Security is enabled but no suitable RPC authentication method is found in the provided JAAS configuration: " + confName);
            }
            authMethodList.addAll(authMethods);
        } else {
            authMethodList.add(RpcAuthRegistry.SIMPLE);
        }
        this.rpcAuthMethodList = Collections.unmodifiableList(authMethodList);
    }

    UserGroupInformation(Subject subject) {
        this(subject, userJAASConfName);
    }

    UserGroupInformation(Subject subject, String loginConfName) {
        this.subject = subject;
        this.user = subject.getPrincipals(User.class).iterator().next();
        if (this.user == null || this.user.getName() == null) {
            throw new IllegalStateException("Subject does not contain a valid User");
        }
        this.configureRpcAuthMethods(loginConfName);
        if (!subject.getPrincipals(KerberosPrincipal.class).isEmpty()) {
            this.user.setAuthenticationMethod(AuthenticationMethod.KERBEROS);
            LOG.debug("found Kerberos Principal in subject, marking as such");
        } else if (customAuthPrincipalClass != null && !subject.getPrincipals(customAuthPrincipalClass).isEmpty()) {
            this.user.setAuthenticationMethod(AuthenticationMethod.CUSTOM);
            LOG.debug("found custom auth principal " + customAuthPrincipalClass.getName() + "  in subject. marking authentication method as " + (Object)((Object)AuthenticationMethod.CUSTOM));
        }
    }

    public boolean hasKerberosCredentials() {
        return this.user.getAuthenticationMethod() == AuthenticationMethod.KERBEROS;
    }

    public List<RpcAuthMethod> getRpcAuthMethodList() {
        return this.rpcAuthMethodList;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation getCurrentUser() throws IOException {
        UserGroupInformation.ensureInitialized();
        AccessControlContext context = AccessController.getContext();
        Subject subject = Subject.getSubject(context);
        if (subject == null || subject.getPrincipals(User.class).isEmpty()) {
            return UserGroupInformation.getLoginUser();
        }
        return new UserGroupInformation(subject);
    }

    public static UserGroupInformation getBestUGI(String ticketCachePath, String user) throws IOException {
        if (ticketCachePath != null) {
            return UserGroupInformation.getUGIFromTicketCache(ticketCachePath, user);
        }
        if (user == null) {
            return UserGroupInformation.getCurrentUser();
        }
        return UserGroupInformation.createRemoteUser(user);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation getUGIFromTicketCache(String ticketCache, String user) throws IOException {
        if (!UserGroupInformation.isAuthenticationMethodEnabled(AuthenticationMethod.KERBEROS)) {
            return UserGroupInformation.getBestUGI(null, user);
        }
        LoginParams params = new LoginParams();
        params.put(LoginParam.PRINCIPAL, user);
        params.put(LoginParam.CCACHE, ticketCache);
        return UserGroupInformation.doSubjectLogin(null, params);
    }

    public static UserGroupInformation getUGIFromSubject(Subject subject) throws IOException {
        if (subject == null) {
            throw new KerberosAuthException("Subject must not be null");
        }
        if (subject.getPrincipals(KerberosPrincipal.class).isEmpty()) {
            throw new KerberosAuthException("Provided Subject must contain a KerberosPrincipal");
        }
        return UserGroupInformation.doSubjectLogin(subject, null);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation getLoginUser() throws IOException {
        UserGroupInformation.ensureInitialized();
        UserGroupInformation loginUser = loginUserRef.get();
        if (loginUser == null) {
            UserGroupInformation newLoginUser = UserGroupInformation.createLoginUser(null);
            do {
                if (loginUserRef.compareAndSet(null, newLoginUser)) {
                    loginUser = newLoginUser;
                    loginUser.spawnAutoRenewalThreadForUserCreds(false);
                    continue;
                }
                loginUser = loginUserRef.get();
            } while (loginUser == null);
        }
        return loginUser;
    }

    public static String trimLoginMethod(String userName) {
        int spaceIndex = userName.indexOf(32);
        if (spaceIndex >= 0) {
            userName = userName.substring(0, spaceIndex);
        }
        return userName;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void loginUserFromSubject(Subject subject) throws IOException {
        UserGroupInformation.setLoginUser(UserGroupInformation.createLoginUser(subject));
    }

    private static UserGroupInformation createLoginUser(Subject subject) throws IOException {
        UserGroupInformation realUser = UserGroupInformation.doSubjectLogin(subject, null);
        UserGroupInformation loginUser = null;
        try {
            String proxyUser = System.getenv(HADOOP_PROXY_USER);
            if (proxyUser == null) {
                proxyUser = System.getProperty(HADOOP_PROXY_USER);
            }
            loginUser = proxyUser == null ? realUser : UserGroupInformation.createProxyUser(proxyUser, realUser);
            LinkedHashSet<String> tokenFileLocations = new LinkedHashSet<String>();
            tokenFileLocations.addAll(StringUtils.getTrimmedStringCollection(System.getProperty("hadoop.token.files")));
            tokenFileLocations.addAll(StringUtils.getTrimmedStringCollection(conf.get("hadoop.token.files")));
            tokenFileLocations.addAll(StringUtils.getTrimmedStringCollection(System.getenv(HADOOP_TOKEN_FILE_LOCATION)));
            for (String tokenFileLocation : tokenFileLocations) {
                if (tokenFileLocation == null || tokenFileLocation.length() <= 0) continue;
                File tokenFile = new File(tokenFileLocation);
                LOG.debug("Reading credentials from location {}", (Object)tokenFile.getCanonicalPath());
                if (tokenFile.exists() && tokenFile.isFile()) {
                    Credentials cred = Credentials.readTokenStorageFile(tokenFile, conf);
                    LOG.debug("Loaded {} tokens from {}", (Object)cred.numberOfTokens(), (Object)tokenFile.getCanonicalPath());
                    loginUser.addCredentials(cred);
                    continue;
                }
                LOG.info("Token file {} does not exist", (Object)tokenFile.getCanonicalPath());
            }
            LinkedHashSet<String> tokensBase64 = new LinkedHashSet<String>();
            tokensBase64.addAll(StringUtils.getTrimmedStringCollection(System.getProperty("hadoop.tokens")));
            tokensBase64.addAll(StringUtils.getTrimmedStringCollection(conf.get("hadoop.tokens")));
            tokensBase64.addAll(StringUtils.getTrimmedStringCollection(System.getenv(HADOOP_TOKEN)));
            int numTokenBase64 = 0;
            for (String tokenBase64 : tokensBase64) {
                if (tokenBase64 == null || tokenBase64.length() <= 0) continue;
                try {
                    Token token = new Token();
                    token.decodeFromUrlString(tokenBase64);
                    Credentials cred = new Credentials();
                    cred.addToken(token.getService(), token);
                    loginUser.addCredentials(cred);
                    ++numTokenBase64;
                }
                catch (IOException ioe) {
                    LOG.error("Cannot add token {}: {}", (Object)tokenBase64, (Object)ioe.getMessage());
                }
            }
            if (numTokenBase64 > 0) {
                LOG.debug("Loaded {} base64 tokens", (Object)numTokenBase64);
            }
        }
        catch (IOException ioe) {
            LOG.debug("Failure to load login credentials", ioe);
            throw ioe;
        }
        LOG.debug("UGI loginUser: {}", (Object)loginUser);
        return loginUser;
    }

    private static void setUserAuthenticationMethod(UserGroupInformation realUser) {
        if (realUser.user.getAuthenticationMethod() == null) {
            switch (authenticationMethod) {
                case TOKEN: 
                case CERTIFICATE: 
                case KERBEROS_SSL: 
                case PROXY: {
                    throw new UnsupportedOperationException((Object)((Object)authenticationMethod) + " login authentication is not supported");
                }
            }
            LOG.debug("Found no authentication principals in subject. Simple?");
            realUser.user.setAuthenticationMethod(authenticationMethod);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public static void setLoginUser(UserGroupInformation ugi) {
        loginUserRef.set(ugi);
    }

    private String getKeytab() {
        HadoopLoginContext login = this.getLogin();
        return login != null && login.getConfiguration() != null ? (String)login.getConfiguration().getOverrideOptions().get("keyTab") : null;
    }

    private boolean isHadoopLogin() {
        return this.getLogin() != null;
    }

    public boolean isFromKeytab() {
        return this.hasKerberosCredentials() && this.isHadoopLogin() && this.getKeytab() != null;
    }

    private boolean isFromTicket() {
        return this.hasKerberosCredentials() && this.isHadoopLogin() && this.getKeytab() == null;
    }

    private KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            if (!SecurityUtil.isOriginalTGT(ticket)) continue;
            return ticket;
        }
        return null;
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long end = tgt.getEndTime().getTime();
        return start + (long)((float)(end - start) * 0.8f);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public boolean shouldRelogin() {
        return this.hasKerberosCredentials() && this.isHadoopLogin();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    void spawnAutoRenewalThreadForUserCreds(boolean force) {
        if (!(force || this.shouldRelogin() && !this.isFromKeytab())) {
            return;
        }
        KerberosTicket tgt = this.getTGT();
        if (tgt == null) {
            return;
        }
        String cmd = conf.get("hadoop.kerberos.kinit.command", "kinit");
        long nextRefresh = this.getRefreshTime(tgt);
        this.executeAutoRenewalTask(this.getUserName(), new TicketCacheRenewalRunnable(tgt, cmd, nextRefresh));
    }

    private void spawnAutoRenewalThreadForKeytab() {
        if (!this.shouldRelogin() || this.isFromTicket()) {
            return;
        }
        KerberosTicket tgt = this.getTGT();
        if (tgt == null) {
            return;
        }
        long nextRefresh = this.getRefreshTime(tgt);
        this.executeAutoRenewalTask(this.getUserName(), new KeytabRenewalRunnable(tgt, nextRefresh));
    }

    private void executeAutoRenewalTask(final String userName, AutoRenewalForUserCredsRunnable task) {
        kerberosLoginRenewalExecutor = Optional.of(Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t2 = new Thread(r);
                t2.setDaemon(true);
                t2.setName("TGT Renewer for " + userName);
                return t2;
            }
        }));
        kerberosLoginRenewalExecutor.get().submit(task);
    }

    @VisibleForTesting
    static long getNextTgtRenewalTime(long tgtEndTime, long now, RetryPolicy rp) throws Exception {
        long lastRetryTime = tgtEndTime - kerberosMinSecondsBeforeRelogin;
        RetryPolicy.RetryAction ra = rp.shouldRetry(null, metrics.renewalFailures.value(), 0, false);
        return Math.min(lastRetryTime, now + ra.delayMillis);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void loginUserFromKeytab(String user, String path) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        UserGroupInformation u = UserGroupInformation.loginUserFromKeytabAndReturnUGI(user, path);
        if (UserGroupInformation.isKerberosKeyTabLoginRenewalEnabled()) {
            u.spawnAutoRenewalThreadForKeytab();
        }
        UserGroupInformation.setLoginUser(u);
        String keytabFileName = path == null ? null : new File(path).getName();
        LOG.info("Login successful for user {} using keytab file {}. Keytab auto renewal enabled : {}", user, keytabFileName, UserGroupInformation.isKerberosKeyTabLoginRenewalEnabled());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public void logoutUserFromKeytab() throws IOException {
        if (!this.hasKerberosCredentials()) {
            return;
        }
        if (UserGroupInformation.getKerberosLoginRenewalExecutor().isPresent()) {
            UserGroupInformation.getKerberosLoginRenewalExecutor().get().shutdownNow();
        }
        HadoopLoginContext login = this.getLogin();
        String keytabFile = this.getKeytab();
        if (login == null || keytabFile == null) {
            throw new KerberosAuthException("loginUserFromKeyTab must be done first");
        }
        try {
            LOG.debug("Initiating logout for {}", (Object)this.getUserName());
            login.logout();
        }
        catch (LoginException le) {
            KerberosAuthException kae = new KerberosAuthException("Logout failure", le);
            kae.setUser(this.user.toString());
            kae.setKeytabFile(keytabFile);
            throw kae;
        }
        LOG.info("Logout successful for user " + this.getUserName() + " using keytab file " + keytabFile);
    }

    public void checkTGTAndReloginFromKeytab() throws IOException {
        this.reloginFromKeytab(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void fixKerberosTicketOrder() {
        Set<Object> creds;
        Set<Object> set = creds = this.getSubject().getPrivateCredentials();
        synchronized (set) {
            Iterator<Object> iter = creds.iterator();
            while (iter.hasNext()) {
                Object cred = iter.next();
                if (!(cred instanceof KerberosTicket)) continue;
                KerberosTicket ticket = (KerberosTicket)cred;
                if (ticket.isDestroyed() || ticket.getServer() == null) {
                    LOG.warn("Ticket is already destroyed, remove it.");
                    iter.remove();
                    continue;
                }
                if (!ticket.getServer().getName().startsWith("krbtgt")) {
                    LOG.warn("The first kerberos ticket is not TGT(the server principal is {}), remove and destroy it.", (Object)ticket.getServer());
                    iter.remove();
                    try {
                        ticket.destroy();
                    }
                    catch (DestroyFailedException e) {
                        LOG.warn("destroy ticket failed", e);
                    }
                    continue;
                }
                return;
            }
        }
        LOG.warn("Warning, no kerberos ticket found while attempting to renew ticket");
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public void reloginFromKeytab() throws IOException {
        this.reloginFromKeytab(false);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public void forceReloginFromKeytab() throws IOException {
        this.reloginFromKeytab(false, true);
    }

    private void reloginFromKeytab(boolean checkTGT) throws IOException {
        this.reloginFromKeytab(checkTGT, false);
    }

    private void reloginFromKeytab(boolean checkTGT, boolean ignoreLastLoginTime) throws IOException {
        KerberosTicket tgt;
        if (!this.shouldRelogin() || !this.isFromKeytab()) {
            return;
        }
        HadoopLoginContext login = this.getLogin();
        if (login == null) {
            throw new KerberosAuthException("loginUserFromKeyTab must be done first");
        }
        if (checkTGT && (tgt = this.getTGT()) != null && !shouldRenewImmediatelyForTests && Time.now() < this.getRefreshTime(tgt)) {
            return;
        }
        this.relogin(login, ignoreLastLoginTime);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public void reloginFromTicketCache() throws IOException, LoginException {
        if (!this.shouldRelogin() || !this.isFromTicket()) {
            return;
        }
        HadoopLoginContext login = this.getLogin();
        LOG.debug("Trying re-login for " + this.getUserName() + " from ticket cache");
        if (login == null) {
            throw new KerberosAuthException("login must be done first");
        }
        this.relogin(login, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void relogin(HadoopLoginContext login, boolean ignoreLastLoginTime) throws IOException {
        Object object = login.getSubjectLock();
        synchronized (object) {
            if (login == this.getLogin()) {
                this.unprotectedRelogin(login, ignoreLastLoginTime);
            }
        }
    }

    private void unprotectedRelogin(HadoopLoginContext login, boolean ignoreLastLoginTime) throws IOException {
        assert (Thread.holdsLock(login.getSubjectLock()));
        long now = Time.now();
        if (!this.hasSufficientTimeElapsed(now) && !ignoreLastLoginTime) {
            return;
        }
        this.user.setLastLogin(now);
        try {
            LOG.debug("Initiating logout for {}", (Object)this.getUserName());
            login.logout();
            login = login.getConfiguration() != null ? UserGroupInformation.newLoginContext(login.getAppName(), login.getSubject(), login.getConfiguration().getOverrideOptions()) : UserGroupInformation.newLoginContext(login.getAppName(), login.getSubject(), null);
            LOG.debug("Initiating re-login for {}", (Object)this.getUserName());
            login.login();
            this.fixKerberosTicketOrder();
            this.setLogin(login);
        }
        catch (LoginException le) {
            KerberosAuthException kae = new KerberosAuthException("Login failure", le);
            kae.setUser(this.getUserName());
            throw kae;
        }
    }

    public static UserGroupInformation loginUserFromKeytabAndReturnUGI(String user, String path) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return UserGroupInformation.getCurrentUser();
        }
        LoginParams params = new LoginParams();
        params.put(LoginParam.PRINCIPAL, user);
        params.put(LoginParam.KEYTAB, path);
        return UserGroupInformation.doSubjectLogin(null, params);
    }

    private boolean hasSufficientTimeElapsed(long now) {
        if (!shouldRenewImmediatelyForTests && now - this.user.getLastLogin() < kerberosMinSecondsBeforeRelogin) {
            LOG.warn("Not attempting to re-login since the last re-login was attempted less than " + kerberosMinSecondsBeforeRelogin / 1000L + " seconds before. Last Login=" + this.user.getLastLogin());
            return false;
        }
        return true;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static boolean isLoginKeytabBased() throws IOException {
        return UserGroupInformation.getLoginUser().isFromKeytab();
    }

    public static boolean isLoginTicketBased() throws IOException {
        return UserGroupInformation.getLoginUser().isFromTicket();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation createRemoteUser(String user) {
        return UserGroupInformation.createRemoteUser(user, SaslRpcServer.AuthMethod.SIMPLE);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation createRemoteUser(String user, SaslRpcServer.AuthMethod authMethod) {
        if (user == null || user.isEmpty()) {
            throw new IllegalArgumentException("Null user");
        }
        Subject subject = new Subject();
        subject.getPrincipals().add(new User(user));
        UserGroupInformation result = new UserGroupInformation(subject);
        result.setAuthenticationMethod(authMethod);
        return result;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation createProxyUser(String user, UserGroupInformation realUser) {
        if (user == null || user.isEmpty()) {
            throw new IllegalArgumentException("Null user");
        }
        if (realUser == null) {
            throw new IllegalArgumentException("Null real user");
        }
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add(new User(user, AuthenticationMethod.PROXY, null));
        principals.add(new RealUser(realUser));
        return new UserGroupInformation(subject);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public UserGroupInformation getRealUser() {
        Iterator<RealUser> iterator = this.subject.getPrincipals(RealUser.class).iterator();
        if (iterator.hasNext()) {
            RealUser p = iterator.next();
            return p.getRealUser();
        }
        return null;
    }

    public static UserGroupInformation getRealUserOrSelf(UserGroupInformation user) {
        if (user == null) {
            return null;
        }
        UserGroupInformation real = user.getRealUser();
        return real != null ? real : user;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation createUserForTesting(String user, String[] userGroups) {
        UserGroupInformation.ensureInitialized();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser(user);
        if (!(groups instanceof TestingGroups)) {
            groups = new TestingGroups(groups);
        }
        ((TestingGroups)UserGroupInformation.groups).setUserGroups(ugi.getShortUserName(), userGroups);
        return ugi;
    }

    public static UserGroupInformation createProxyUserForTesting(String user, UserGroupInformation realUser, String[] userGroups) {
        UserGroupInformation.ensureInitialized();
        UserGroupInformation ugi = UserGroupInformation.createProxyUser(user, realUser);
        if (!(groups instanceof TestingGroups)) {
            groups = new TestingGroups(groups);
        }
        ((TestingGroups)UserGroupInformation.groups).setUserGroups(ugi.getShortUserName(), userGroups);
        return ugi;
    }

    public String getShortUserName() {
        if (windows && spoofUser) {
            return spoofedUser;
        }
        return this.user.getShortName();
    }

    public String getPrimaryGroupName() throws IOException {
        List<String> groups = this.getGroups();
        if (groups.isEmpty()) {
            throw new IOException("There is no primary group for UGI " + this);
        }
        return groups.get(0);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public String getUserName() {
        if (windows && spoofUser) {
            return spoofedUser;
        }
        return this.user.getName();
    }

    public synchronized boolean addTokenIdentifier(TokenIdentifier tokenId) {
        return this.subject.getPublicCredentials().add(tokenId);
    }

    public synchronized Set<TokenIdentifier> getTokenIdentifiers() {
        return this.subject.getPublicCredentials(TokenIdentifier.class);
    }

    public boolean addToken(Token<? extends TokenIdentifier> token) {
        return token != null ? this.addToken(token.getService(), token) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToken(Text alias, Token<? extends TokenIdentifier> token) {
        Subject subject = this.subject;
        synchronized (subject) {
            this.getCredentialsInternal().addToken(alias, token);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Token<? extends TokenIdentifier>> getTokens() {
        Subject subject = this.subject;
        synchronized (subject) {
            return Collections.unmodifiableCollection(new ArrayList<Token<? extends TokenIdentifier>>(this.getCredentialsInternal().getAllTokens()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credentials getCredentials() {
        Subject subject = this.subject;
        synchronized (subject) {
            Credentials creds = new Credentials(this.getCredentialsInternal());
            Iterator<Token<? extends TokenIdentifier>> iter = creds.getAllTokens().iterator();
            while (iter.hasNext()) {
                if (!iter.next().isPrivate()) continue;
                iter.remove();
            }
            return creds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCredentials(Credentials credentials) {
        Subject subject = this.subject;
        synchronized (subject) {
            this.getCredentialsInternal().addAll(credentials);
        }
    }

    private synchronized Credentials getCredentialsInternal() {
        Credentials credentials;
        Set<Credentials> credentialsSet = this.subject.getPrivateCredentials(Credentials.class);
        if (!credentialsSet.isEmpty()) {
            credentials = credentialsSet.iterator().next();
        } else {
            credentials = new Credentials();
            this.subject.getPrivateCredentials().add(credentials);
        }
        return credentials;
    }

    public String[] getGroupNames() {
        List<String> groups = this.getGroups();
        return groups.toArray(new String[groups.size()]);
    }

    public List<String> getGroups() {
        UserGroupInformation.ensureInitialized();
        try {
            return groups.getGroups(this.getShortUserName());
        }
        catch (IOException ie) {
            LOG.debug("Failed to get groups for user {}", (Object)this.getShortUserName(), (Object)ie);
            return Collections.emptyList();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getUserName());
        sb.append(" (auth:" + (Object)((Object)this.getAuthenticationMethod()) + ")");
        if (this.getRealUser() != null) {
            sb.append(" via ").append(this.getRealUser().toString());
        }
        return sb.toString();
    }

    public synchronized void setAuthenticationMethod(AuthenticationMethod authMethod) {
        this.user.setAuthenticationMethod(authMethod);
    }

    public void setAuthenticationMethod(SaslRpcServer.AuthMethod authMethod) {
        switch (authMethod) {
            case SIMPLE: {
                this.user.setAuthenticationMethod(AuthenticationMethod.SIMPLE);
                break;
            }
            case KERBEROS: {
                this.user.setAuthenticationMethod(AuthenticationMethod.KERBEROS);
                break;
            }
            case DIGEST: 
            case TOKEN: {
                this.user.setAuthenticationMethod(AuthenticationMethod.TOKEN);
                break;
            }
            default: {
                this.user.setAuthenticationMethod(null);
            }
        }
    }

    public synchronized AuthenticationMethod getAuthenticationMethod() {
        return this.user.getAuthenticationMethod();
    }

    public synchronized AuthenticationMethod getRealAuthenticationMethod() {
        UserGroupInformation ugi = this.getRealUser();
        if (ugi == null) {
            ugi = this;
        }
        return ugi.getAuthenticationMethod();
    }

    public static AuthenticationMethod getRealAuthenticationMethod(UserGroupInformation ugi) {
        AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.subject == ((UserGroupInformation)o).subject;
    }

    public int hashCode() {
        return System.identityHashCode(this.subject);
    }

    public Subject getSubject() {
        return this.subject;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public <T> T doAs(PrivilegedAction<T> action) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("PrivilegedAction [as: {}][action: {}]", this, action, new Exception());
        }
        return Subject.doAs(this.subject, action);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public <T> T doAs(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PrivilegedAction [as: {}][action: {}]", this, action, new Exception());
            }
            return Subject.doAs(this.subject, action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            LOG.debug("PrivilegedActionException as: {}", (Object)this, (Object)cause);
            if (cause == null) {
                throw new RuntimeException("PrivilegedActionException with no underlying cause. UGI [" + this + "]: " + pae, pae);
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "KMS"})
    @InterfaceStability.Unstable
    public static void logUserInfo(Logger log, String caption, UserGroupInformation ugi) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(caption + " UGI: " + ugi);
            for (Token<? extends TokenIdentifier> token : ugi.getTokens()) {
                log.debug("+token:" + token);
            }
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "KMS"})
    @InterfaceStability.Unstable
    public static void logAllUserInfo(Logger log, UserGroupInformation ugi) throws IOException {
        if (log.isDebugEnabled()) {
            UserGroupInformation.logUserInfo(log, "Current", ugi.getCurrentUser());
            if (ugi.getRealUser() != null) {
                UserGroupInformation.logUserInfo(log, "Real", ugi.getRealUser());
            }
            UserGroupInformation.logUserInfo(log, "Login", ugi.getLoginUser());
        }
    }

    public static void logAllUserInfo(UserGroupInformation ugi) throws IOException {
        UserGroupInformation.logAllUserInfo(LOG, ugi);
    }

    private void print() throws IOException {
        System.out.println("User: " + this.getUserName());
        System.out.print("Group Ids: ");
        System.out.println();
        String[] groups = this.getGroupNames();
        System.out.print("Groups: ");
        for (int i = 0; i < groups.length; ++i) {
            System.out.print(groups[i] + " ");
        }
        System.out.println();
    }

    private static UserGroupInformation doSubjectLogin(Subject subject, LoginParams params) throws IOException {
        UserGroupInformation.ensureInitialized();
        boolean setLoginUser = false;
        if (subject == null) {
            subject = new Subject();
            setLoginUser = true;
        }
        try {
            HadoopLoginContext login;
            if (params == null) {
                login = UserGroupInformation.newLoginContext(userJAASConfName, subject, null);
                params = LoginParams.getDefaults();
            } else {
                HashMap<String, String> overrideOptions = new HashMap<String, String>();
                overrideOptions.put("keyTab", (String)params.get((Object)LoginParam.KEYTAB));
                overrideOptions.put("principal", (String)params.get((Object)LoginParam.PRINCIPAL));
                login = UserGroupInformation.newLoginContext(serviceJAASConfName, subject, overrideOptions);
            }
            login.login();
            UserGroupInformation ugi = new UserGroupInformation(login.getSubject(), userJAASConfName);
            UserGroupInformation.setUserAuthenticationMethod(ugi);
            ugi = new UserGroupInformation(login.getSubject(), userJAASConfName);
            if (subject == null || setLoginUser) {
                if (authenticationMethod == AuthenticationMethod.KERBEROS) {
                    params.put(LoginParam.PRINCIPAL, ugi.getUserName());
                }
                ugi.setLogin(login);
                ugi.setLastLogin(Time.now());
            }
            return ugi;
        }
        catch (LoginException le) {
            KerberosAuthException kae = new KerberosAuthException("failure to login:", le);
            if (params != null) {
                kae.setPrincipal((String)params.get((Object)LoginParam.PRINCIPAL));
                kae.setKeytabFile((String)params.get((Object)LoginParam.KEYTAB));
                kae.setTicketCacheFile((String)params.get((Object)LoginParam.CCACHE));
            }
            throw kae;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Getting UGI for current user");
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        ugi.print();
        System.out.println("UGI: " + ugi);
        System.out.println("Auth method " + (Object)((Object)ugi.user.getAuthenticationMethod()));
        System.out.println("Keytab " + ugi.isFromKeytab());
        System.out.println("============================================================");
        if (args.length == 2) {
            System.out.println("Getting UGI from keytab....");
            UserGroupInformation.loginUserFromKeytab(args[0], args[1]);
            UserGroupInformation.getCurrentUser().print();
            System.out.println("Keytab: " + ugi);
            UserGroupInformation loginUgi = UserGroupInformation.getLoginUser();
            System.out.println("Auth method " + (Object)((Object)loginUgi.getAuthenticationMethod()));
            System.out.println("Keytab " + loginUgi.isFromKeytab());
        }
    }

    static {
        metrics = UgiMetrics.create();
        kerberosLoginRenewalExecutor = Optional.empty();
        DEFAULT_JAVA_SECURITY_AUTH_LOGIN_CONFIG = System.getenv("JAVA_SECURITY_AUTH");
        loginUserRef = new AtomicReference();
        windows = System.getProperty("os.name").startsWith("Windows");
    }

    private static class HadoopLoginContext
    extends LoginContext {
        private final String appName;
        DynamicLoginConfiguration conf;
        private AtomicBoolean isLoggedIn = new AtomicBoolean();

        HadoopLoginContext(String appName, Subject subject, DynamicLoginConfiguration conf) throws LoginException {
            super(appName, subject, null, conf);
            this.appName = appName;
            this.conf = conf;
        }

        HadoopLoginContext(String appName, Subject subject) throws LoginException {
            super(appName, subject);
            this.appName = appName;
        }

        String getAppName() {
            return this.appName;
        }

        DynamicLoginConfiguration getConfiguration() {
            return this.conf;
        }

        Object getSubjectLock() {
            Subject subject = this.getSubject();
            return subject == null ? this : subject.getPrivateCredentials();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void login() throws LoginException {
            Object object = this.getSubjectLock();
            synchronized (object) {
                MutableRate metric = UserGroupInformation.metrics.loginFailure;
                long start = Time.monotonicNow();
                try {
                    super.login();
                    this.isLoggedIn.set(true);
                    metric = UserGroupInformation.metrics.loginSuccess;
                }
                finally {
                    metric.add(Time.monotonicNow() - start);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void logout() throws LoginException {
            Object object = this.getSubjectLock();
            synchronized (object) {
                if (this.isLoggedIn.compareAndSet(true, false)) {
                    super.logout();
                }
            }
        }
    }

    private static class LoginParams
    extends EnumMap<LoginParam, String>
    implements Configuration.Parameters {
        LoginParams() {
            super(LoginParam.class);
        }

        @Override
        public String put(LoginParam param, String val) {
            boolean add = val != null && !this.containsKey((Object)param);
            return add ? super.put(param, val) : null;
        }

        static LoginParams getDefaults() {
            LoginParams params = new LoginParams();
            params.put(LoginParam.PRINCIPAL, System.getenv("KRB5PRINCIPAL"));
            params.put(LoginParam.KEYTAB, System.getenv("KRB5KEYTAB"));
            params.put(LoginParam.CCACHE, System.getenv("KRB5CCNAME"));
            return params;
        }

        EnumMap getParams() {
            return this;
        }
    }

    static enum LoginParam {
        PRINCIPAL,
        KEYTAB,
        CCACHE;

    }

    private static class TestingGroups
    extends Groups {
        private final Map<String, List<String>> userToGroupsMapping = new HashMap<String, List<String>>();
        private Groups underlyingImplementation;

        private TestingGroups(Groups underlyingImplementation) {
            super(new Configuration());
            this.underlyingImplementation = underlyingImplementation;
        }

        @Override
        public List<String> getGroups(String user) throws IOException {
            List<String> result = this.userToGroupsMapping.get(user);
            if (result == null) {
                result = this.underlyingImplementation.getGroups(user);
            }
            return result;
        }

        private void setUserGroups(String user, String[] groups) {
            this.userToGroupsMapping.put(user, Arrays.asList(groups));
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum AuthenticationMethod {
        SIMPLE(false),
        KERBEROS(true),
        TOKEN(false),
        CERTIFICATE(true),
        KERBEROS_SSL(true),
        PROXY(false),
        CUSTOM(true);

        private final boolean allowsDelegation;

        private AuthenticationMethod(boolean allowsDelegation) {
            this.allowsDelegation = allowsDelegation;
        }

        public boolean allowsDelegation() {
            return this.allowsDelegation;
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    final class KeytabRenewalRunnable
    extends AutoRenewalForUserCredsRunnable {
        KeytabRenewalRunnable(KerberosTicket tgt, long nextRefresh) {
            super(tgt, nextRefresh);
        }

        @Override
        public void relogin() throws IOException {
            UserGroupInformation.this.reloginFromKeytab();
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    final class TicketCacheRenewalRunnable
    extends AutoRenewalForUserCredsRunnable {
        private String kinitCmd;

        TicketCacheRenewalRunnable(KerberosTicket tgt, String kinitCmd, long nextRefresh) {
            super(tgt, nextRefresh);
            this.kinitCmd = kinitCmd;
        }

        @Override
        public void relogin() throws IOException, LoginException {
            String output = Shell.execCommand(this.kinitCmd, "-R");
            LOG.debug("Renewed ticket. kinit output: {}", (Object)output);
            UserGroupInformation.this.reloginFromTicketCache();
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    abstract class AutoRenewalForUserCredsRunnable
    implements Runnable {
        private KerberosTicket tgt;
        private RetryPolicy rp;
        private long nextRefresh;
        private boolean runRenewalLoop = true;

        AutoRenewalForUserCredsRunnable(KerberosTicket tgt, long nextRefresh) {
            this.tgt = tgt;
            this.nextRefresh = nextRefresh;
            this.rp = null;
        }

        public void setRunRenewalLoop(boolean runRenewalLoop) {
            this.runRenewalLoop = runRenewalLoop;
        }

        protected abstract void relogin() throws IOException, LoginException;

        @Override
        public void run() {
            do {
                try {
                    long now = Time.now();
                    LOG.debug("Current time is {}, next refresh is {}", (Object)now, (Object)this.nextRefresh);
                    if (now < this.nextRefresh) {
                        Thread.sleep(this.nextRefresh - now);
                    }
                    this.relogin();
                    this.tgt = UserGroupInformation.this.getTGT();
                    if (this.tgt == null) {
                        LOG.warn("No TGT after renewal. Aborting renew thread for " + UserGroupInformation.this.getUserName());
                        return;
                    }
                    this.nextRefresh = Math.max(UserGroupInformation.this.getRefreshTime(this.tgt), now + kerberosMinSecondsBeforeRelogin);
                    metrics.renewalFailures.set(0);
                    this.rp = null;
                }
                catch (InterruptedException ie) {
                    LOG.warn("Terminating renewal thread");
                    return;
                }
                catch (IOException ie) {
                    long tgtEndTime;
                    metrics.renewalFailuresTotal.incr();
                    long now = Time.now();
                    if (this.tgt.isDestroyed()) {
                        LOG.error(String.format("TGT is destroyed. Aborting renew thread for %s.", UserGroupInformation.this.getUserName()), ie);
                        return;
                    }
                    try {
                        tgtEndTime = this.tgt.getEndTime().getTime();
                    }
                    catch (NullPointerException npe) {
                        LOG.error("NPE thrown while getting KerberosTicket endTime. Aborting renew thread for {}.", (Object)UserGroupInformation.this.getUserName(), (Object)ie);
                        return;
                    }
                    LOG.warn("Exception encountered while running the renewal command for {}. (TGT end time:{}, renewalFailures: {}, renewalFailuresTotal: {})", UserGroupInformation.this.getUserName(), tgtEndTime, metrics.renewalFailures.value(), metrics.renewalFailuresTotal.value(), ie);
                    if (this.rp == null) {
                        this.rp = RetryPolicies.exponentialBackoffRetry(62, kerberosMinSecondsBeforeRelogin, TimeUnit.MILLISECONDS);
                    }
                    try {
                        this.nextRefresh = UserGroupInformation.getNextTgtRenewalTime(tgtEndTime, now, this.rp);
                    }
                    catch (Exception e) {
                        LOG.error("Exception when calculating next tgt renewal time", e);
                        return;
                    }
                    metrics.renewalFailures.incr();
                    if (now <= this.nextRefresh) continue;
                    LOG.error("TGT is expired. Aborting renew thread for {}.", (Object)UserGroupInformation.this.getUserName());
                    return;
                }
                catch (LoginException e) {
                    e.printStackTrace();
                }
            } while (this.runRenewalLoop);
        }
    }

    private static class RealUser
    implements Principal {
        private final UserGroupInformation realUser;

        RealUser(UserGroupInformation realUser) {
            this.realUser = realUser;
        }

        @Override
        public String getName() {
            return this.realUser.getUserName();
        }

        public UserGroupInformation getRealUser() {
            return this.realUser;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.realUser.equals(((RealUser)o).realUser);
        }

        @Override
        public int hashCode() {
            return this.realUser.hashCode();
        }

        @Override
        public String toString() {
            return this.realUser.toString();
        }
    }

    @Metrics(about="User and group related metrics", context="ugi")
    static class UgiMetrics {
        final MetricsRegistry registry = new MetricsRegistry("UgiMetrics");
        @Metric(value={"Rate of successful kerberos logins and latency (milliseconds)"})
        MutableRate loginSuccess;
        @Metric(value={"Rate of failed kerberos logins and latency (milliseconds)"})
        MutableRate loginFailure;
        @Metric(value={"GetGroups"})
        MutableRate getGroups;
        MutableQuantiles[] getGroupsQuantiles;
        @Metric(value={"Renewal failures since startup"})
        private MutableGaugeLong renewalFailuresTotal;
        @Metric(value={"Renewal failures since last successful login"})
        private MutableGaugeInt renewalFailures;

        UgiMetrics() {
        }

        static UgiMetrics create() {
            return DefaultMetricsSystem.instance().register(new UgiMetrics());
        }

        static void reattach() {
            metrics = UgiMetrics.create();
        }

        void addGetGroups(long latency) {
            this.getGroups.add(latency);
            if (this.getGroupsQuantiles != null) {
                for (MutableQuantiles q : this.getGroupsQuantiles) {
                    q.add(latency);
                }
            }
        }

        MutableGaugeInt getRenewalFailures() {
            return this.renewalFailures;
        }
    }
}

