/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.utils;

import java.lang.reflect.Method;
import org.apache.curator.utils.InjectSessionExpiration;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compatibility {
    private static final boolean hasZooKeeperAdmin;
    private static final Method queueEventMethod;
    private static final Logger logger;

    public static boolean isZK34() {
        return !hasZooKeeperAdmin;
    }

    public static void injectSessionExpiration(ZooKeeper zooKeeper) {
        if (Compatibility.isZK34() || queueEventMethod == null) {
            InjectSessionExpiration.injectSessionExpiration(zooKeeper);
        } else {
            try {
                WatchedEvent event = new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null);
                queueEventMethod.invoke((Object)zooKeeper.getTestable(), event);
            }
            catch (Exception e) {
                logger.error("Could not call Testable.queueEvent()", e);
            }
        }
    }

    static {
        Method localQueueEventMethod;
        boolean localHasZooKeeperAdmin;
        logger = LoggerFactory.getLogger(Compatibility.class);
        try {
            Class.forName("org.apache.zookeeper.admin.ZooKeeperAdmin");
            localHasZooKeeperAdmin = true;
        }
        catch (ClassNotFoundException e) {
            localHasZooKeeperAdmin = false;
            logger.info("Running in ZooKeeper 3.4.x compatibility mode");
        }
        hasZooKeeperAdmin = localHasZooKeeperAdmin;
        try {
            Class<?> testableClass = Class.forName("org.apache.zookeeper.Testable");
            localQueueEventMethod = testableClass.getMethod("queueEvent", WatchedEvent.class);
        }
        catch (ReflectiveOperationException ignore) {
            localQueueEventMethod = null;
            LoggerFactory.getLogger(Compatibility.class).info("Using emulated InjectSessionExpiration");
        }
        queueEventMethod = localQueueEventMethod;
    }
}

