/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.constants.HttpOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsAHCHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsManagedHttpClientContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class ITestAbfsHttpClientRequestExecutor
extends AbstractAbfsIntegrationTest {
    @Test
    public void testExpect100ContinueHandling() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path path = new Path("/testExpect100ContinueHandling");
        Configuration conf = new Configuration(fs.getConf());
        conf.set("fs.azure.networking.library", HttpOperationType.APACHE_HTTP_CLIENT.toString());
        AzureBlobFileSystem fs2 = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf)));
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs2.getAbfsStore());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs2)).getAbfsStore();
        AbfsClient client = (AbfsClient)Mockito.spy((Object)store.getClient());
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)client).when((Object)store)).getClient();
        int[] invocation = new int[]{0};
        ((AbfsClient)Mockito.doAnswer(answer -> {
            AbfsRestOperation op = (AbfsRestOperation)Mockito.spy((Object)((AbfsRestOperation)answer.callRealMethod()));
            ConnectionInfo connectionInfo = new ConnectionInfo();
            this.mockHttpOperationBehavior(connectionInfo, op);
            ((AbfsRestOperation)Mockito.doAnswer(executeAnswer -> {
                Throwable throwable;
                invocation[0] = invocation[0] + 1;
                if (invocation[0] == 3) {
                    executeAnswer.callRealMethod();
                    throwable = null;
                } else {
                    throwable = LambdaTestUtils.intercept(IOException.class, () -> {
                        try {
                            executeAnswer.callRealMethod();
                        }
                        catch (IOException ex) {
                            throw ex;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                }
                if (invocation[0] == 1) {
                    Assertions.assertThat((int)connectionInfo.getSendHeaderInvocation()).isEqualTo(1);
                    Assertions.assertThat((int)connectionInfo.getSendBodyInvocation()).isEqualTo(0);
                    Assertions.assertThat((int)connectionInfo.getReceiveResponseInvocation()).isEqualTo(1);
                    Assertions.assertThat((int)connectionInfo.getReceiveResponseBodyInvocation()).isEqualTo(1);
                }
                if (invocation[0] == 2) {
                    Assertions.assertThat((int)connectionInfo.getSendHeaderInvocation()).isEqualTo(1);
                    Assertions.assertThat((int)connectionInfo.getSendBodyInvocation()).isEqualTo(1);
                    Assertions.assertThat((int)connectionInfo.getReceiveResponseInvocation()).isEqualTo(1);
                    Assertions.assertThat((int)connectionInfo.getReceiveResponseBodyInvocation()).isEqualTo(1);
                }
                if (invocation[0] == 3) {
                    Assertions.assertThat((int)connectionInfo.getSendHeaderInvocation()).isEqualTo(1);
                    Assertions.assertThat((int)connectionInfo.getSendBodyInvocation()).isEqualTo(1);
                    Assertions.assertThat((int)connectionInfo.getReceiveResponseInvocation()).isEqualTo(2);
                    Assertions.assertThat((int)connectionInfo.getReceiveResponseBodyInvocation()).isEqualTo(1);
                }
                Assertions.assertThat((int)invocation[0]).isLessThanOrEqualTo(3);
                if (throwable != null) {
                    throw throwable;
                }
                return null;
            }).when((Object)op)).execute((TracingContext)Mockito.any(TracingContext.class));
            return op;
        }).when((Object)client)).getAbfsRestOperation((AbfsRestOperationType)Mockito.any(AbfsRestOperationType.class), Mockito.anyString(), (URL)Mockito.any(URL.class), Mockito.anyList(), (byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt(), (String)Mockito.nullable(String.class));
        FSDataOutputStream os = fs2.create(path);
        fs.delete(path, true);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> ITestAbfsHttpClientRequestExecutor.lambda$testExpect100ContinueHandling$3((OutputStream)os));
        FSDataOutputStream os2 = fs2.create(path);
        os2.write(1);
        os2.close();
    }

    private void mockHttpOperationBehavior(ConnectionInfo connectionInfo, AbfsRestOperation op) throws IOException {
        ((AbfsRestOperation)Mockito.doAnswer(httpOpCreationAnswer -> {
            AbfsAHCHttpOperation httpOperation = (AbfsAHCHttpOperation)Mockito.spy((Object)((AbfsAHCHttpOperation)httpOpCreationAnswer.callRealMethod()));
            ((AbfsAHCHttpOperation)Mockito.doAnswer(createContextAnswer -> {
                AbfsManagedHttpClientContext context = (AbfsManagedHttpClientContext)Mockito.spy((Object)((AbfsManagedHttpClientContext)createContextAnswer.callRealMethod()));
                ((AbfsManagedHttpClientContext)Mockito.doAnswer(connectionSpyIntercept -> this.interceptedConn(connectionInfo, (HttpClientConnection)connectionSpyIntercept.getArgument(0))).when((Object)context)).interceptConnectionActivity((HttpClientConnection)Mockito.any(HttpClientConnection.class));
                return context;
            }).when((Object)httpOperation)).getHttpClientContext();
            return httpOperation;
        }).when((Object)op)).createHttpOperation();
    }

    private HttpClientConnection interceptedConn(ConnectionInfo connectionInfo, HttpClientConnection connection) throws IOException, HttpException {
        HttpClientConnection interceptedConn = (HttpClientConnection)Mockito.spy((Object)connection);
        ((HttpClientConnection)Mockito.doAnswer(answer -> {
            connectionInfo.incrementSendHeaderInvocation();
            long start = System.currentTimeMillis();
            Object result = answer.callRealMethod();
            connectionInfo.addSendTime(System.currentTimeMillis() - start);
            return result;
        }).when((Object)interceptedConn)).sendRequestHeader((HttpRequest)Mockito.any(HttpRequest.class));
        ((HttpClientConnection)Mockito.doAnswer(answer -> {
            connectionInfo.incrementSendBodyInvocation();
            long start = System.currentTimeMillis();
            Object result = answer.callRealMethod();
            connectionInfo.addSendTime(System.currentTimeMillis() - start);
            return result;
        }).when((Object)interceptedConn)).sendRequestEntity((HttpEntityEnclosingRequest)Mockito.any(HttpEntityEnclosingRequest.class));
        ((HttpClientConnection)Mockito.doAnswer(answer -> {
            connectionInfo.incrementReceiveResponseInvocation();
            long start = System.currentTimeMillis();
            Object result = answer.callRealMethod();
            connectionInfo.addReadTime(System.currentTimeMillis() - start);
            return result;
        }).when((Object)interceptedConn)).receiveResponseHeader();
        ((HttpClientConnection)Mockito.doAnswer(answer -> {
            connectionInfo.incrementReceiveResponseBodyInvocation();
            long start = System.currentTimeMillis();
            Object result = answer.callRealMethod();
            connectionInfo.addReadTime(System.currentTimeMillis() - start);
            return result;
        }).when((Object)interceptedConn)).receiveResponseEntity((HttpResponse)Mockito.any(HttpResponse.class));
        return interceptedConn;
    }

    @Test
    public void testConnectionReadRecords() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path path = new Path("/testConnectionRecords");
        Configuration conf = new Configuration(fs.getConf());
        conf.set("fs.azure.networking.library", HttpOperationType.APACHE_HTTP_CLIENT.toString());
        AzureBlobFileSystem fs2 = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf)));
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs2.getAbfsStore());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs2)).getAbfsStore();
        AbfsClient client = (AbfsClient)Mockito.spy((Object)store.getClient());
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)client).when((Object)store)).getClient();
        try (FSDataOutputStream os = fs.create(path);){
            os.write(1);
        }
        FSDataInputStream is = fs2.open(path);
        ((AbfsClient)Mockito.doAnswer(answer -> {
            AbfsRestOperation op = (AbfsRestOperation)Mockito.spy((Object)((AbfsRestOperation)answer.callRealMethod()));
            ConnectionInfo connectionInfo = new ConnectionInfo();
            this.mockHttpOperationBehavior(connectionInfo, op);
            ((AbfsRestOperation)Mockito.doAnswer(executeAnswer -> {
                executeAnswer.callRealMethod();
                Assertions.assertThat((int)connectionInfo.getSendHeaderInvocation()).isEqualTo(1);
                Assertions.assertThat((int)connectionInfo.getSendBodyInvocation()).isEqualTo(0);
                Assertions.assertThat((int)connectionInfo.getReceiveResponseInvocation()).isEqualTo(1);
                Assertions.assertThat((int)connectionInfo.getReceiveResponseBodyInvocation()).isEqualTo(1);
                return null;
            }).when((Object)op)).execute((TracingContext)Mockito.any(TracingContext.class));
            return op;
        }).when((Object)client)).getAbfsRestOperation((AbfsRestOperationType)Mockito.any(AbfsRestOperationType.class), Mockito.anyString(), (URL)Mockito.any(URL.class), Mockito.anyList(), (byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt(), (String)Mockito.nullable(String.class));
        is.read();
        is.close();
    }

    private static /* synthetic */ void lambda$testExpect100ContinueHandling$3(OutputStream os) throws Exception {
        os.write(1);
        os.close();
    }

    private static class ConnectionInfo {
        private long connectTime;
        private long readTime;
        private long sendTime;
        private int sendHeaderInvocation;
        private int sendBodyInvocation;
        private int receiveResponseInvocation;
        private int receiveResponseBodyInvocation;

        private ConnectionInfo() {
        }

        private void incrementSendHeaderInvocation() {
            ++this.sendHeaderInvocation;
        }

        private void incrementSendBodyInvocation() {
            ++this.sendBodyInvocation;
        }

        private void incrementReceiveResponseInvocation() {
            ++this.receiveResponseInvocation;
        }

        private void incrementReceiveResponseBodyInvocation() {
            ++this.receiveResponseBodyInvocation;
        }

        private void addConnectTime(long connectTime) {
            this.connectTime += connectTime;
        }

        private void addReadTime(long readTime) {
            this.readTime += readTime;
        }

        private void addSendTime(long sendTime) {
            this.sendTime += sendTime;
        }

        private long getConnectTime() {
            return this.connectTime;
        }

        private long getReadTime() {
            return this.readTime;
        }

        private long getSendTime() {
            return this.sendTime;
        }

        private int getSendHeaderInvocation() {
            return this.sendHeaderInvocation;
        }

        private int getSendBodyInvocation() {
            return this.sendBodyInvocation;
        }

        private int getReceiveResponseInvocation() {
            return this.receiveResponseInvocation;
        }

        private int getReceiveResponseBodyInvocation() {
            return this.receiveResponseBodyInvocation;
        }
    }
}

