/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.enums.Trilean;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ITestGetNameSpaceEnabled
extends AbstractAbfsIntegrationTest {
    private static final String TRUE_STR = "true";
    private static final String FALSE_STR = "false";
    private boolean isUsingXNSAccount = this.getConfiguration().getBoolean("fs.azure.test.namespace.enabled", false);

    @Test
    public void testXNSAccount() throws IOException {
        Assume.assumeTrue((String)"Skip this test because the account being used for test is a non XNS account", (boolean)this.isUsingXNSAccount);
        ITestGetNameSpaceEnabled.assertTrue((String)"Expecting getIsNamespaceEnabled() return true", (boolean)this.getIsNamespaceEnabled(this.getFileSystem()));
    }

    @Test
    public void testNonXNSAccount() throws IOException {
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.test.namespace.enabled");
        Assume.assumeFalse((String)"Skip this test because the account being used for test is a XNS account", (boolean)this.isUsingXNSAccount);
        ITestGetNameSpaceEnabled.assertFalse((String)"Expecting getIsNamespaceEnabled() return false", (boolean)this.getIsNamespaceEnabled(this.getFileSystem()));
    }

    @Test
    public void testGetIsNamespaceEnabledWhenConfigIsTrue() throws Exception {
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.test.namespace.enabled");
        AzureBlobFileSystem fs = this.getNewFSWithHnsConf(TRUE_STR);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.getIsNamespaceEnabled(fs)).describedAs("getIsNamespaceEnabled should return true when the config is set as true", new Object[0])).isTrue();
        fs.getAbfsStore().deleteFilesystem(this.getTestTracingContext(fs, false));
        this.unsetAndAssert();
    }

    @Test
    public void testGetIsNamespaceEnabledWhenConfigIsFalse() throws Exception {
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.test.namespace.enabled");
        AzureBlobFileSystem fs = this.getNewFSWithHnsConf(FALSE_STR);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.getIsNamespaceEnabled(fs)).describedAs("getIsNamespaceEnabled should return false when the config is set as false", new Object[0])).isFalse();
        fs.getAbfsStore().deleteFilesystem(this.getTestTracingContext(fs, false));
        this.unsetAndAssert();
    }

    private void unsetAndAssert() throws Exception {
        AzureBlobFileSystem fs = this.getNewFSWithHnsConf("");
        boolean expectedValue = this.getConfiguration().getBoolean("fs.azure.test.namespace.enabled", false);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.getIsNamespaceEnabled(fs)).describedAs("getIsNamespaceEnabled should return the value configured for fs.azure.test.namespace.enabled", new Object[0])).isEqualTo(expectedValue);
        fs.getAbfsStore().deleteFilesystem(this.getTestTracingContext(fs, false));
    }

    private AzureBlobFileSystem getNewFSWithHnsConf(String isNamespaceEnabledAccount) throws Exception {
        Configuration rawConfig = new Configuration();
        rawConfig.addResource("azure-test.xml");
        rawConfig.set("fs.azure.account.hns.enabled", isNamespaceEnabledAccount);
        rawConfig.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", true);
        rawConfig.set("fs.defaultFS", this.getNonExistingUrl());
        return (AzureBlobFileSystem)FileSystem.get((Configuration)rawConfig);
    }

    private String getNonExistingUrl() {
        String testUri = this.getTestUrl();
        return this.getAbfsScheme() + "://" + UUID.randomUUID() + testUri.substring(testUri.indexOf("@"));
    }

    @Test
    public void testFailedRequestWhenFSNotExist() throws Exception {
        AbfsConfiguration config = this.getConfiguration();
        config.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", false);
        String testUri = this.getTestUrl();
        String nonExistingFsUrl = this.getAbfsScheme() + "://" + UUID.randomUUID() + testUri.substring(testUri.indexOf("@"));
        AzureBlobFileSystem fs = this.getFileSystem(nonExistingFsUrl);
        LambdaTestUtils.intercept(FileNotFoundException.class, (String)"\"The specified filesystem does not exist.\", 404", () -> fs.getFileStatus(new Path("/")));
    }

    @Test
    public void testEnsureGetAclCallIsMadeOnceWhenConfigIsInvalid() throws Exception {
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
        this.ensureGetAclCallIsMadeOnceForInvalidConf(" ");
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
        this.ensureGetAclCallIsMadeOnceForInvalidConf("Invalid conf");
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
    }

    @Test
    public void testEnsureGetAclCallIsNeverMadeWhenConfigIsValid() throws Exception {
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
        this.ensureGetAclCallIsNeverMadeForValidConf(FALSE_STR.toLowerCase());
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
        this.ensureGetAclCallIsNeverMadeForValidConf(FALSE_STR.toUpperCase());
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
        this.ensureGetAclCallIsNeverMadeForValidConf(TRUE_STR.toLowerCase());
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
        this.ensureGetAclCallIsNeverMadeForValidConf(TRUE_STR.toUpperCase());
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
    }

    @Test
    public void testEnsureGetAclCallIsMadeOnceWhenConfigIsNotPresent() throws IOException {
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
    }

    private void ensureGetAclCallIsMadeOnceForInvalidConf(String invalidConf) throws Exception {
        this.getFileSystem().getAbfsStore().setNamespaceEnabled(Trilean.getTrilean((String)invalidConf));
        AbfsClient mockClient = this.callAbfsGetIsNamespaceEnabledAndReturnMockAbfsClient();
        ((AbfsClient)Mockito.verify((Object)mockClient, (VerificationMode)Mockito.times((int)1))).getAclStatus(ArgumentMatchers.anyString(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
    }

    private void ensureGetAclCallIsNeverMadeForValidConf(String validConf) throws Exception {
        this.getFileSystem().getAbfsStore().setNamespaceEnabled(Trilean.getTrilean((String)validConf));
        AbfsClient mockClient = this.callAbfsGetIsNamespaceEnabledAndReturnMockAbfsClient();
        ((AbfsClient)Mockito.verify((Object)mockClient, (VerificationMode)Mockito.never())).getAclStatus(ArgumentMatchers.anyString(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
    }

    private void unsetConfAndEnsureGetAclCallIsMadeOnce() throws IOException {
        this.getFileSystem().getAbfsStore().setNamespaceEnabled(Trilean.UNKNOWN);
        AbfsClient mockClient = this.callAbfsGetIsNamespaceEnabledAndReturnMockAbfsClient();
        ((AbfsClient)Mockito.verify((Object)mockClient, (VerificationMode)Mockito.times((int)1))).getAclStatus(ArgumentMatchers.anyString(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
    }

    private AbfsClient callAbfsGetIsNamespaceEnabledAndReturnMockAbfsClient() throws IOException {
        AzureBlobFileSystem abfs = this.getFileSystem();
        AzureBlobFileSystemStore abfsStore = abfs.getAbfsStore();
        AbfsClient mockClient = (AbfsClient)Mockito.mock(AbfsClient.class);
        ((AbfsClient)Mockito.doReturn((Object)Mockito.mock(AbfsRestOperation.class)).when((Object)mockClient)).getAclStatus(ArgumentMatchers.anyString(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
        abfsStore.setClient(mockClient);
        this.getIsNamespaceEnabled(abfs);
        return mockClient;
    }

    @Test
    public void ensureGetAclDetermineHnsStatusAccurately() throws Exception {
        this.ensureGetAclDetermineHnsStatusAccuratelyInternal(400, false, false);
        this.ensureGetAclDetermineHnsStatusAccuratelyInternal(404, true, true);
        this.ensureGetAclDetermineHnsStatusAccuratelyInternal(500, true, true);
        this.ensureGetAclDetermineHnsStatusAccuratelyInternal(503, true, true);
    }

    private void ensureGetAclDetermineHnsStatusAccuratelyInternal(int statusCode, boolean expectedValue, boolean isExceptionExpected) throws Exception {
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)this.getFileSystem().getAbfsStore());
        AbfsClient mockClient = (AbfsClient)Mockito.mock(AbfsClient.class);
        store.setNamespaceEnabled(Trilean.UNKNOWN);
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)mockClient).when((Object)store)).getClient();
        AbfsRestOperationException ex = new AbfsRestOperationException(statusCode, null, Integer.toString(statusCode), null);
        ((AbfsClient)Mockito.doThrow((Throwable[])new Throwable[]{ex}).when((Object)mockClient)).getAclStatus(ArgumentMatchers.anyString(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
        if (isExceptionExpected) {
            try {
                store.getIsNamespaceEnabled(this.getTestTracingContext(this.getFileSystem(), false));
                Assertions.fail((String)("Exception Should have been thrown with status code: " + statusCode));
            }
            catch (AbfsRestOperationException caughtEx) {
                Assertions.assertThat((int)caughtEx.getStatusCode()).isEqualTo(statusCode);
                Assertions.assertThat((String)caughtEx.getErrorMessage()).isEqualTo((Object)ex.getErrorMessage());
            }
        }
        boolean isHnsEnabled = store.getIsNamespaceEnabled(this.getTestTracingContext(this.getFileSystem(), false));
        Assertions.assertThat((boolean)isHnsEnabled).isEqualTo(expectedValue);
        ((AbfsClient)Mockito.verify((Object)mockClient, (VerificationMode)Mockito.times((int)1))).getAclStatus(ArgumentMatchers.anyString(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
    }
}

