/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.blob.BlockListingFilter;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.BlockBlobAppendStream;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.PageBlobOutputStream;
import org.apache.hadoop.fs.azure.SyncableDataOutputStream;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.junit.Test;

public class ITestOutputStreamSemantics
extends AbstractWasbTestBase {
    private static final String PAGE_BLOB_DIR = "/pageblob";
    private static final String BLOCK_BLOB_DIR = "/blockblob";
    private static final String BLOCK_BLOB_COMPACTION_DIR = "/compaction";

    private byte[] getRandomBytes() {
        byte[] buffer = new byte[510];
        Random rand = new Random();
        rand.nextBytes(buffer);
        return buffer;
    }

    private Path getBlobPathWithTestName(String parentDir) {
        return new Path(parentDir + "/" + this.methodName.getMethodName());
    }

    private void validate(Path path, byte[] writeBuffer, boolean isEqual) throws IOException {
        String blobPath = path.toUri().getPath();
        try (FSDataInputStream inputStream = this.fs.open(path);){
            byte[] readBuffer = new byte[510];
            int numBytesRead = inputStream.read(readBuffer, 0, readBuffer.length);
            if (isEqual) {
                ITestOutputStreamSemantics.assertArrayEquals((String)String.format("Bytes read do not match bytes written to %1$s", blobPath), (byte[])writeBuffer, (byte[])readBuffer);
            } else {
                ITestOutputStreamSemantics.assertThat((String)String.format("Bytes read unexpectedly match bytes written to %1$s", blobPath), (Object)readBuffer, (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)writeBuffer)));
            }
        }
    }

    private boolean isBlockBlobAppendStreamWrapper(FSDataOutputStream stream) {
        return ((SyncableDataOutputStream)((NativeAzureFileSystem.NativeAzureFsOutputStream)stream.getWrappedStream()).getOutStream()).getOutStream() instanceof BlockBlobAppendStream;
    }

    private boolean isPageBlobStreamWrapper(FSDataOutputStream stream) {
        return ((SyncableDataOutputStream)stream.getWrappedStream()).getOutStream() instanceof PageBlobOutputStream;
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.azure.page.blob.dir", PAGE_BLOB_DIR);
        conf.set("fs.azure.block.blob.with.compaction.dir", BLOCK_BLOB_COMPACTION_DIR);
        return AzureBlobStorageTestAccount.create("", EnumSet.of(AzureBlobStorageTestAccount.CreateOptions.CreateContainer), conf);
    }

    @Test
    public void testPageBlobFlush() throws IOException {
        Path path = this.getBlobPathWithTestName(PAGE_BLOB_DIR);
        try (FSDataOutputStream stream = this.fs.create(path);){
            byte[] buffer = this.getRandomBytes();
            stream.write(buffer);
            stream.flush();
            SyncableDataOutputStream syncStream = (SyncableDataOutputStream)stream.getWrappedStream();
            PageBlobOutputStream pageBlobStream = (PageBlobOutputStream)syncStream.getOutStream();
            pageBlobStream.waitForLastFlushCompletion();
            this.validate(path, buffer, true);
        }
    }

    @Test
    public void testPageBlobHFlush() throws IOException {
        Path path = this.getBlobPathWithTestName(PAGE_BLOB_DIR);
        try (FSDataOutputStream stream = this.fs.create(path);){
            ITestOutputStreamSemantics.assertTrue((boolean)this.isPageBlobStreamWrapper(stream));
            byte[] buffer = this.getRandomBytes();
            stream.write(buffer);
            stream.hflush();
            this.validate(path, buffer, true);
        }
    }

    @Test
    public void testPageBlobHSync() throws IOException {
        Path path = this.getBlobPathWithTestName(PAGE_BLOB_DIR);
        try (FSDataOutputStream stream = this.fs.create(path);){
            ITestOutputStreamSemantics.assertTrue((boolean)this.isPageBlobStreamWrapper(stream));
            byte[] buffer = this.getRandomBytes();
            stream.write(buffer);
            stream.hsync();
            this.validate(path, buffer, true);
        }
    }

    @Test
    public void testPageBlobClose() throws IOException {
        Path path = this.getBlobPathWithTestName(PAGE_BLOB_DIR);
        try (FSDataOutputStream stream = this.fs.create(path);){
            ITestOutputStreamSemantics.assertTrue((boolean)this.isPageBlobStreamWrapper(stream));
            byte[] buffer = this.getRandomBytes();
            stream.write(buffer);
            stream.close();
            this.validate(path, buffer, true);
        }
    }

    @Test
    public void testPageBlobCapabilities() throws IOException {
        Path path = this.getBlobPathWithTestName(PAGE_BLOB_DIR);
        try (FSDataOutputStream stream = this.fs.create(path);){
            ContractTestUtils.assertHasStreamCapabilities((Object)stream, (String[])new String[]{"hflush", "hsync"});
            ContractTestUtils.assertLacksStreamCapabilities((Object)stream, (String[])new String[]{"dropbehind", "in:readahead", "in:unbuffer"});
            stream.write(this.getRandomBytes());
        }
    }

    @Test
    public void testBlockBlobFlush() throws Exception {
        Path path = this.getBlobPathWithTestName(BLOCK_BLOB_DIR);
        byte[] buffer = this.getRandomBytes();
        try (FSDataOutputStream stream = this.fs.create(path);){
            for (int i = 0; i < 10; ++i) {
                stream.write(buffer);
                stream.flush();
            }
        }
        String blobPath = path.toUri().getPath();
        CloudBlockBlob blob = this.testAccount.getBlobReference(blobPath.substring(1));
        ArrayList blockList = blob.downloadBlockList(BlockListingFilter.COMMITTED, null, null, null);
        ITestOutputStreamSemantics.assertEquals((long)1L, (long)blockList.size());
    }

    @Test
    public void testBlockBlobHFlush() throws Exception {
        Path path = this.getBlobPathWithTestName(BLOCK_BLOB_DIR);
        byte[] buffer = this.getRandomBytes();
        try (FSDataOutputStream stream = this.fs.create(path);){
            for (int i = 0; i < 10; ++i) {
                stream.write(buffer);
                stream.hflush();
            }
        }
        String blobPath = path.toUri().getPath();
        CloudBlockBlob blob = this.testAccount.getBlobReference(blobPath.substring(1));
        ArrayList blockList = blob.downloadBlockList(BlockListingFilter.COMMITTED, null, null, null);
        ITestOutputStreamSemantics.assertEquals((long)1L, (long)blockList.size());
    }

    @Test
    public void testBlockBlobHSync() throws Exception {
        Path path = this.getBlobPathWithTestName(BLOCK_BLOB_DIR);
        byte[] buffer = this.getRandomBytes();
        try (FSDataOutputStream stream = this.fs.create(path);){
            for (int i = 0; i < 10; ++i) {
                stream.write(buffer);
                stream.hsync();
            }
        }
        String blobPath = path.toUri().getPath();
        CloudBlockBlob blob = this.testAccount.getBlobReference(blobPath.substring(1));
        ArrayList blockList = blob.downloadBlockList(BlockListingFilter.COMMITTED, null, null, null);
        ITestOutputStreamSemantics.assertEquals((long)1L, (long)blockList.size());
    }

    @Test
    public void testBlockBlobClose() throws IOException {
        Path path = this.getBlobPathWithTestName(BLOCK_BLOB_DIR);
        try (FSDataOutputStream stream = this.fs.create(path);){
            byte[] buffer = this.getRandomBytes();
            stream.write(buffer);
            stream.close();
            this.validate(path, buffer, true);
        }
    }

    @Test
    public void testBlockBlobCapabilities() throws IOException {
        Path path = this.getBlobPathWithTestName(BLOCK_BLOB_DIR);
        try (FSDataOutputStream stream = this.fs.create(path);){
            ContractTestUtils.assertLacksStreamCapabilities((Object)stream, (String[])new String[]{"hflush", "hsync", "dropbehind", "in:readahead", "in:unbuffer"});
            stream.write(this.getRandomBytes());
        }
    }

    @Test
    public void testBlockBlobCompactionFlush() throws Exception {
        Path path = this.getBlobPathWithTestName(BLOCK_BLOB_COMPACTION_DIR);
        byte[] buffer = this.getRandomBytes();
        try (FSDataOutputStream stream = this.fs.create(path);){
            ITestOutputStreamSemantics.assertTrue((boolean)this.isBlockBlobAppendStreamWrapper(stream));
            for (int i = 0; i < 10; ++i) {
                stream.write(buffer);
                stream.flush();
            }
        }
        String blobPath = path.toUri().getPath();
        CloudBlockBlob blob = this.testAccount.getBlobReference(blobPath.substring(1));
        ArrayList blockList = blob.downloadBlockList(BlockListingFilter.COMMITTED, null, null, null);
        ITestOutputStreamSemantics.assertEquals((long)1L, (long)blockList.size());
    }

    @Test
    public void testBlockBlobCompactionHFlush() throws Exception {
        Path path = this.getBlobPathWithTestName(BLOCK_BLOB_COMPACTION_DIR);
        byte[] buffer = this.getRandomBytes();
        try (FSDataOutputStream stream = this.fs.create(path);){
            ITestOutputStreamSemantics.assertTrue((boolean)this.isBlockBlobAppendStreamWrapper(stream));
            for (int i = 0; i < 10; ++i) {
                stream.write(buffer);
                stream.hflush();
            }
        }
        String blobPath = path.toUri().getPath();
        CloudBlockBlob blob = this.testAccount.getBlobReference(blobPath.substring(1));
        ArrayList blockList = blob.downloadBlockList(BlockListingFilter.COMMITTED, null, null, null);
        ITestOutputStreamSemantics.assertEquals((long)10L, (long)blockList.size());
    }

    @Test
    public void testBlockBlobCompactionHSync() throws Exception {
        Path path = this.getBlobPathWithTestName(BLOCK_BLOB_COMPACTION_DIR);
        byte[] buffer = this.getRandomBytes();
        try (FSDataOutputStream stream = this.fs.create(path);){
            ITestOutputStreamSemantics.assertTrue((boolean)this.isBlockBlobAppendStreamWrapper(stream));
            for (int i = 0; i < 10; ++i) {
                stream.write(buffer);
                stream.hsync();
            }
        }
        String blobPath = path.toUri().getPath();
        CloudBlockBlob blob = this.testAccount.getBlobReference(blobPath.substring(1));
        ArrayList blockList = blob.downloadBlockList(BlockListingFilter.COMMITTED, null, null, null);
        ITestOutputStreamSemantics.assertEquals((long)10L, (long)blockList.size());
    }

    @Test
    public void testBlockBlobCompactionClose() throws IOException {
        Path path = this.getBlobPathWithTestName(BLOCK_BLOB_COMPACTION_DIR);
        try (FSDataOutputStream stream = this.fs.create(path);){
            ITestOutputStreamSemantics.assertTrue((boolean)this.isBlockBlobAppendStreamWrapper(stream));
            byte[] buffer = this.getRandomBytes();
            stream.write(buffer);
            stream.close();
            this.validate(path, buffer, true);
        }
    }

    @Test
    public void testBlockBlobCompactionCapabilities() throws IOException {
        Path path = this.getBlobPathWithTestName(BLOCK_BLOB_COMPACTION_DIR);
        try (FSDataOutputStream stream = this.fs.create(path);){
            ContractTestUtils.assertHasStreamCapabilities((Object)stream, (String[])new String[]{"hflush", "hsync"});
            ContractTestUtils.assertLacksStreamCapabilities((Object)stream, (String[])new String[]{"dropbehind", "in:readahead", "in:unbuffer"});
            stream.write(this.getRandomBytes());
        }
    }

    @Test
    public void testPageBlobSmallWrite() throws IOException {
        Path path = this.getBlobPathWithTestName(PAGE_BLOB_DIR);
        try (FSDataOutputStream stream = this.fs.create(path);){
            ITestOutputStreamSemantics.assertTrue((boolean)this.isPageBlobStreamWrapper(stream));
            byte[] buffer = this.getRandomBytes();
            stream.write(buffer);
            this.validate(path, buffer, false);
        }
    }

    @Test
    public void testBlockBlobSmallWrite() throws IOException {
        Path path = this.getBlobPathWithTestName(BLOCK_BLOB_DIR);
        try (FSDataOutputStream stream = this.fs.create(path);){
            byte[] buffer = this.getRandomBytes();
            stream.write(buffer);
            this.validate(path, buffer, false);
        }
    }

    @Test
    public void testBlockBlobCompactionSmallWrite() throws IOException {
        Path path = this.getBlobPathWithTestName(BLOCK_BLOB_COMPACTION_DIR);
        try (FSDataOutputStream stream = this.fs.create(path);){
            ITestOutputStreamSemantics.assertTrue((boolean)this.isBlockBlobAppendStreamWrapper(stream));
            byte[] buffer = this.getRandomBytes();
            stream.write(buffer);
            this.validate(path, buffer, false);
        }
    }
}

