/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsTestWithTimeout;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.constants.HttpOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsAHCHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsApacheHttpClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsJdkHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.AbfsThrottlingIntercept;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class TestApacheHttpClientFallback
extends AbstractAbfsTestWithTimeout {
    private TracingContext getSampleTracingContext(int[] jdkCallsRegister, int[] apacheCallsRegister) {
        String correlationId = "test-corr-id";
        String fsId = "test-filesystem-id";
        TracingHeaderFormat format = TracingHeaderFormat.ALL_ID_FORMAT;
        TracingContext tc = (TracingContext)Mockito.spy((Object)new TracingContext(correlationId, fsId, FSOperationType.TEST_OP, true, format, null));
        ((TracingContext)Mockito.doAnswer(answer -> {
            answer.callRealMethod();
            AbfsHttpOperation op = (AbfsHttpOperation)answer.getArgument(0);
            if (op instanceof AbfsAHCHttpOperation) {
                Assertions.assertThat((String)tc.getHeader()).endsWith((CharSequence)"Apache");
                apacheCallsRegister[0] = apacheCallsRegister[0] + 1;
            }
            if (op instanceof AbfsJdkHttpOperation) {
                jdkCallsRegister[0] = jdkCallsRegister[0] + 1;
                if (AbfsApacheHttpClient.usable()) {
                    Assertions.assertThat((String)tc.getHeader()).endsWith((CharSequence)"JDK");
                } else {
                    Assertions.assertThat((String)tc.getHeader()).endsWith((CharSequence)"JDK_fallback");
                }
            }
            return null;
        }).when((Object)tc)).constructHeader((AbfsHttpOperation)Mockito.any(AbfsHttpOperation.class), (String)Mockito.nullable(String.class), (String)Mockito.nullable(String.class));
        return tc;
    }

    @Test
    public void testMultipleFailureLeadToFallback() throws Exception {
        int[] apacheCallsTest1 = new int[]{0};
        int[] jdkCallsTest1 = new int[]{0};
        TracingContext tcTest1 = this.getSampleTracingContext(jdkCallsTest1, apacheCallsTest1);
        int[] retryIterationTest1 = new int[]{0};
        LambdaTestUtils.intercept(IOException.class, () -> this.getMockRestOperation(retryIterationTest1).execute(tcTest1));
        Assertions.assertThat((int)apacheCallsTest1[0]).isEqualTo(3);
        Assertions.assertThat((int)jdkCallsTest1[0]).isEqualTo(1);
        int[] retryIteration1 = new int[]{0};
        int[] apacheCallsTest2 = new int[]{0};
        int[] jdkCallsTest2 = new int[]{0};
        TracingContext tcTest2 = this.getSampleTracingContext(jdkCallsTest2, apacheCallsTest2);
        LambdaTestUtils.intercept(IOException.class, () -> this.getMockRestOperation(retryIteration1).execute(tcTest2));
        Assertions.assertThat((int)apacheCallsTest2[0]).isEqualTo(0);
        Assertions.assertThat((int)jdkCallsTest2[0]).isEqualTo(4);
    }

    private AbfsRestOperation getMockRestOperation(int[] retryIteration) throws IOException {
        AbfsConfiguration configuration = (AbfsConfiguration)Mockito.mock(AbfsConfiguration.class);
        ((AbfsConfiguration)Mockito.doReturn((Object)HttpOperationType.APACHE_HTTP_CLIENT).when((Object)configuration)).getPreferredHttpOperationType();
        ((AbfsConfiguration)Mockito.doReturn((Object)3).when((Object)configuration)).getMaxApacheHttpClientIoExceptionsRetries();
        AbfsClient client = (AbfsClient)Mockito.mock(AbfsClient.class);
        ((AbfsClient)Mockito.doReturn((Object)Mockito.mock(ExponentialRetryPolicy.class)).when((Object)client)).getExponentialRetryPolicy();
        AbfsRetryPolicy retryPolicy = (AbfsRetryPolicy)Mockito.mock(AbfsRetryPolicy.class);
        ((AbfsClient)Mockito.doReturn((Object)retryPolicy).when((Object)client)).getRetryPolicy((String)Mockito.nullable(String.class));
        ((AbfsRetryPolicy)Mockito.doAnswer(answer -> {
            if (retryIteration[0] < 3) {
                retryIteration[0] = retryIteration[0] + 1;
                return true;
            }
            return false;
        }).when((Object)retryPolicy)).shouldRetry(Mockito.anyInt(), ((Integer)Mockito.nullable(Integer.class)).intValue());
        AbfsThrottlingIntercept abfsThrottlingIntercept = (AbfsThrottlingIntercept)Mockito.mock(AbfsThrottlingIntercept.class);
        ((AbfsThrottlingIntercept)Mockito.doNothing().when((Object)abfsThrottlingIntercept)).updateMetrics((AbfsRestOperationType)Mockito.any(AbfsRestOperationType.class), (AbfsHttpOperation)Mockito.any(AbfsHttpOperation.class));
        ((AbfsThrottlingIntercept)Mockito.doNothing().when((Object)abfsThrottlingIntercept)).sendingRequest((AbfsRestOperationType)Mockito.any(AbfsRestOperationType.class), (AbfsCounters)Mockito.nullable(AbfsCounters.class));
        ((AbfsClient)Mockito.doReturn((Object)abfsThrottlingIntercept).when((Object)client)).getIntercept();
        AbfsRestOperation op = (AbfsRestOperation)Mockito.spy((Object)new AbfsRestOperation(AbfsRestOperationType.ReadFile, client, "GET", new URL("http://localhost"), new ArrayList(), null, configuration));
        ((AbfsRestOperation)Mockito.doReturn(null).when((Object)op)).getClientLatency();
        ((AbfsRestOperation)Mockito.doReturn((Object)this.createApacheHttpOp()).when((Object)op)).createAbfsHttpOperation();
        ((AbfsRestOperation)Mockito.doReturn((Object)this.createAhcHttpOp()).when((Object)op)).createAbfsAHCHttpOperation();
        ((AbfsRestOperation)Mockito.doAnswer(answer -> answer.getArgument(0)).when((Object)op)).createNewTracingContext((TracingContext)Mockito.nullable(TracingContext.class));
        ((AbfsRestOperation)Mockito.doNothing().when((Object)op)).signRequest((AbfsHttpOperation)Mockito.any(AbfsHttpOperation.class), Mockito.anyInt());
        ((AbfsRestOperation)Mockito.doAnswer(answer -> {
            AbfsHttpOperation operation = (AbfsHttpOperation)Mockito.spy((Object)((AbfsHttpOperation)answer.callRealMethod()));
            Assertions.assertThat((Object)operation).isInstanceOf(retryIteration[0] < 3 && AbfsApacheHttpClient.usable() ? AbfsAHCHttpOperation.class : AbfsJdkHttpOperation.class);
            ((AbfsHttpOperation)Mockito.doReturn((Object)200).when((Object)operation)).getStatusCode();
            ((AbfsHttpOperation)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Test Exception")}).when((Object)operation)).processResponse((byte[])Mockito.nullable(byte[].class), Mockito.anyInt(), Mockito.anyInt());
            ((AbfsHttpOperation)Mockito.doCallRealMethod().when((Object)operation)).getTracingContextSuffix();
            return operation;
        }).when((Object)op)).createHttpOperation();
        return op;
    }

    private AbfsAHCHttpOperation createAhcHttpOp() {
        AbfsAHCHttpOperation ahcOp = (AbfsAHCHttpOperation)Mockito.mock(AbfsAHCHttpOperation.class);
        ((AbfsAHCHttpOperation)Mockito.doCallRealMethod().when((Object)ahcOp)).getTracingContextSuffix();
        return ahcOp;
    }

    private AbfsJdkHttpOperation createApacheHttpOp() {
        AbfsJdkHttpOperation httpOperationMock = (AbfsJdkHttpOperation)Mockito.mock(AbfsJdkHttpOperation.class);
        ((AbfsJdkHttpOperation)Mockito.doCallRealMethod().when((Object)httpOperationMock)).getTracingContextSuffix();
        return httpOperationMock;
    }

    @Test
    public void testTcHeaderOnJDKClientUse() {
        int[] jdkCallsRegister = new int[]{0};
        int[] apacheCallsRegister = new int[]{0};
        TracingContext tc = this.getSampleTracingContext(jdkCallsRegister, apacheCallsRegister);
        AbfsJdkHttpOperation op = (AbfsJdkHttpOperation)Mockito.mock(AbfsJdkHttpOperation.class);
        ((AbfsJdkHttpOperation)Mockito.doCallRealMethod().when((Object)op)).getTracingContextSuffix();
        tc.constructHeader((AbfsHttpOperation)op, null, null);
    }
}

