/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.nio.file.AccessDeniedException;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Test;

public class TestAbfsErrorTranslation
extends AbstractHadoopTestBase {
    public static final Path PATH = new Path("abfs//store/path");

    @Test
    public void testConvert403ToAccessDenied() throws Throwable {
        this.assertTranslated(403, AzureServiceErrorCode.AUTHORIZATION_PERMISSION_MISS_MATCH, AccessDeniedException.class, AzureServiceErrorCode.AUTHORIZATION_PERMISSION_MISS_MATCH.getErrorCode());
    }

    @Test
    public void testConvert404ToFNFE() throws Throwable {
        this.assertTranslated(404, AzureServiceErrorCode.PATH_NOT_FOUND, FileNotFoundException.class, AzureServiceErrorCode.PATH_NOT_FOUND.getErrorCode());
    }

    @Test
    public void testConvert409ToFileAlreadyExistsException() throws Throwable {
        this.assertTranslated(409, AzureServiceErrorCode.PATH_ALREADY_EXISTS, FileAlreadyExistsException.class, AzureServiceErrorCode.PATH_ALREADY_EXISTS.getErrorCode());
    }

    private <E extends Throwable> void assertTranslated(int httpStatus, AzureServiceErrorCode exitCode, Class<E> clazz, String expectedText) throws Exception {
        AbfsRestOperationException ex = new AbfsRestOperationException(httpStatus, exitCode.getErrorCode(), "", null);
        LambdaTestUtils.intercept(clazz, (String)expectedText, () -> {
            AzureBlobFileSystem.checkException((Path)PATH, (AzureBlobFileSystemException)ex, (AzureServiceErrorCode[])new AzureServiceErrorCode[0]);
            return "expected exception translation from " + (Object)((Object)ex);
        });
    }
}

