/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidAbfsRestOperationException;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ITestAzureBlobFileSystemE2E
extends AbstractAbfsIntegrationTest {
    private static final int TEST_BYTE = 100;
    private static final int TEST_OFFSET = 100;
    private static final int TEST_DEFAULT_BUFFER_SIZE = 0x400000;
    private static final int TEST_DEFAULT_READ_BUFFER_SIZE = 1023900;
    private static final int TEST_STABLE_DEFAULT_CONNECTION_TIMEOUT_MS = 500;
    private static final int TEST_STABLE_DEFAULT_READ_TIMEOUT_MS = 30000;
    private static final int TEST_UNSTABLE_READ_TIMEOUT_MS = 1;

    public ITestAzureBlobFileSystemE2E() throws Exception {
        AbfsConfiguration configuration = this.getConfiguration();
        configuration.set("fs.azure.readaheadqueue.depth", "0");
    }

    @Test
    public void testWriteOneByteToFile() throws Exception {
        Path testFilePath = this.path(this.methodName.getMethodName());
        this.testWriteOneByteToFile(testFilePath);
    }

    @Test
    public void testReadWriteBytesToFile() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFilePath = this.path(this.methodName.getMethodName());
        this.testWriteOneByteToFile(testFilePath);
        try (FSDataInputStream inputStream = fs.open(testFilePath, 0x400000);){
            ITestAzureBlobFileSystemE2E.assertEquals((long)100L, (long)inputStream.read());
        }
    }

    @Test(expected=IOException.class)
    public void testOOBWritesAndReadFail() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.io.read.tolerate.concurrent.append", false);
        AzureBlobFileSystem fs = this.getFileSystem();
        int readBufferSize = fs.getAbfsStore().getAbfsConfiguration().getReadBufferSize();
        byte[] bytesToRead = new byte[readBufferSize];
        byte[] b = new byte[2 * readBufferSize];
        new Random().nextBytes(b);
        Path testFilePath = this.path(this.methodName.getMethodName());
        try (FSDataOutputStream writeStream = fs.create(testFilePath);){
            writeStream.write(b);
            writeStream.flush();
        }
        try (FSDataInputStream readStream = fs.open(testFilePath);){
            ITestAzureBlobFileSystemE2E.assertEquals((long)readBufferSize, (long)readStream.read(bytesToRead, 0, readBufferSize));
            try (FSDataOutputStream writeStream = fs.create(testFilePath);){
                writeStream.write(b);
                writeStream.flush();
            }
            ITestAzureBlobFileSystemE2E.assertEquals((long)readBufferSize, (long)readStream.read(bytesToRead, 0, readBufferSize));
        }
    }

    @Test
    public void testOOBWritesAndReadSucceed() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.io.read.tolerate.concurrent.append", true);
        AzureBlobFileSystem fs = this.getFileSystem(conf);
        int readBufferSize = fs.getAbfsStore().getAbfsConfiguration().getReadBufferSize();
        byte[] bytesToRead = new byte[readBufferSize];
        byte[] b = new byte[2 * readBufferSize];
        new Random().nextBytes(b);
        Path testFilePath = this.path(this.methodName.getMethodName());
        try (FSDataOutputStream writeStream = fs.create(testFilePath);){
            writeStream.write(b);
            writeStream.flush();
        }
        try (FSDataInputStream readStream = fs.open(testFilePath);){
            ITestAzureBlobFileSystemE2E.assertEquals((long)readBufferSize, (long)readStream.read(bytesToRead, 0, readBufferSize));
            try (FSDataOutputStream writeStream = fs.create(testFilePath);){
                writeStream.write(b);
                writeStream.flush();
            }
            ITestAzureBlobFileSystemE2E.assertEquals((long)readBufferSize, (long)readStream.read(bytesToRead, 0, readBufferSize));
        }
    }

    @Test
    public void testWriteWithBufferOffset() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFilePath = this.path(this.methodName.getMethodName());
        byte[] b = new byte[1024000];
        new Random().nextBytes(b);
        try (FSDataOutputStream stream = fs.create(testFilePath);){
            stream.write(b, 100, b.length - 100);
        }
        byte[] r = new byte[1023900];
        FSDataInputStream inputStream = fs.open(testFilePath, 0x400000);
        int result = inputStream.read(r);
        ITestAzureBlobFileSystemE2E.assertNotEquals((long)-1L, (long)result);
        ITestAzureBlobFileSystemE2E.assertArrayEquals((byte[])r, (byte[])Arrays.copyOfRange(b, 100, b.length));
        inputStream.close();
    }

    @Test
    public void testReadWriteHeavyBytesToFileWithSmallerChunks() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFilePath = this.path(this.methodName.getMethodName());
        byte[] writeBuffer = new byte[5120000];
        new Random().nextBytes(writeBuffer);
        this.write(testFilePath, writeBuffer);
        byte[] readBuffer = new byte[5120000];
        FSDataInputStream inputStream = fs.open(testFilePath, 0x400000);
        int offset = 0;
        while (inputStream.read(readBuffer, offset, 100) > 0) {
            offset += 100;
        }
        ITestAzureBlobFileSystemE2E.assertArrayEquals((byte[])readBuffer, (byte[])writeBuffer);
        inputStream.close();
    }

    @Test
    public void testReadWithFileNotFoundException() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFilePath = this.path(this.methodName.getMethodName());
        this.testWriteOneByteToFile(testFilePath);
        try (FSDataInputStream inputStream = fs.open(testFilePath, 0x400000);){
            fs.delete(testFilePath, true);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)testFilePath);
            LambdaTestUtils.intercept(FileNotFoundException.class, () -> inputStream.read(new byte[1]));
        }
    }

    @Test
    public void testWriteWithFileNotFoundException() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFilePath = this.path(this.methodName.getMethodName());
        try (FSDataOutputStream stream = fs.create(testFilePath);){
            ContractTestUtils.assertPathExists((FileSystem)fs, (String)"Path should exist", (Path)testFilePath);
            stream.write(100);
            fs.delete(testFilePath, true);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)testFilePath);
            LambdaTestUtils.intercept(FileNotFoundException.class, () -> stream.close());
        }
    }

    @Test
    public void testFlushWithFileNotFoundException() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFilePath = this.path(this.methodName.getMethodName());
        if (fs.getAbfsStore().isAppendBlobKey(fs.makeQualified(testFilePath).toString())) {
            return;
        }
        try (FSDataOutputStream stream = fs.create(testFilePath);){
            ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)testFilePath);
            fs.delete(testFilePath, true);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)testFilePath);
            LambdaTestUtils.intercept(FileNotFoundException.class, () -> stream.close());
        }
    }

    private void testWriteOneByteToFile(Path testFilePath) throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        try (FSDataOutputStream stream = fs.create(testFilePath);){
            stream.write(100);
        }
        FileStatus fileStatus = fs.getFileStatus(testFilePath);
        ITestAzureBlobFileSystemE2E.assertEquals((long)1L, (long)fileStatus.getLen());
    }

    @Test
    public void testHttpConnectionTimeout() throws Exception {
        this.testHttpTimeouts(500, 30000);
    }

    @Test(expected=InvalidAbfsRestOperationException.class)
    public void testHttpReadTimeout() throws Exception {
        this.testHttpTimeouts(500, 1);
    }

    public void testHttpTimeouts(int connectionTimeoutMs, int readTimeoutMs) throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setInt("fs.azure.http.connection.timeout", connectionTimeoutMs);
        conf.setInt("fs.azure.http.read.timeout", readTimeoutMs);
        conf.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", false);
        conf.setInt("fs.azure.io.retry.max.retries", 1);
        AzureBlobFileSystem fs = this.getFileSystem(conf);
        ((AbstractIntegerAssert)Assertions.assertThat((int)fs.getAbfsStore().getAbfsConfiguration().getHttpConnectionTimeout()).describedAs("HTTP connection time should be picked from config", new Object[0])).isEqualTo(connectionTimeoutMs);
        ((AbstractIntegerAssert)Assertions.assertThat((int)fs.getAbfsStore().getAbfsConfiguration().getHttpReadTimeout()).describedAs("HTTP Read time should be picked from config", new Object[0])).isEqualTo(readTimeoutMs);
        Path testPath = this.path(this.methodName.getMethodName());
        ContractTestUtils.createFile((FileSystem)fs, (Path)testPath, (boolean)false, (byte[])new byte[0]);
    }
}

