/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultEntrySchema;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultSchema;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientTestUtil;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsJdkHttpOperation;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.functional.FunctionRaisingIOE;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Stubber;
import org.mockito.verification.VerificationMode;

public class ITestAzureBlobFileSystemListStatus
extends AbstractAbfsIntegrationTest {
    private static final int TEST_FILES_NUMBER = 6000;
    private static final String TEST_CONTINUATION_TOKEN = "continuation";

    @Test
    public void testListPath() throws Exception {
        Configuration config = new Configuration(this.getRawConfiguration());
        config.set("fs.azure.list.max.results", "5000");
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((URI)this.getFileSystem().getUri(), (Configuration)config);){
            ArrayList<Future<Void>> tasks = new ArrayList<Future<Void>>();
            ExecutorService es = Executors.newFixedThreadPool(10);
            for (int i = 0; i < 6000; ++i) {
                final Path path = new Path("/test" + i);
                Callable<Void> callable = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ITestAzureBlobFileSystemListStatus.this.touch(path);
                        return null;
                    }
                };
                tasks.add(es.submit(callable));
            }
            for (Future future : tasks) {
                future.get();
            }
            es.shutdownNow();
            fs.registerListener((Listener)new TracingHeaderValidator(this.getConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.LISTSTATUS, true, 0));
            FileStatus[] files = fs.listStatus(new Path("/"));
            ITestAzureBlobFileSystemListStatus.assertEquals((long)6000L, (long)files.length);
        }
    }

    @Test
    public void testListPathTracingContext() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        AzureBlobFileSystem spiedFs = (AzureBlobFileSystem)Mockito.spy((Object)fs);
        AzureBlobFileSystemStore spiedStore = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        AbfsClient spiedClient = (AbfsClient)Mockito.spy((Object)fs.getAbfsClient());
        TracingContext spiedTracingContext = (TracingContext)Mockito.spy((Object)new TracingContext(fs.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.LISTSTATUS, true, TracingHeaderFormat.ALL_ID_FORMAT, null));
        ((AzureBlobFileSystem)Mockito.doReturn((Object)spiedStore).when((Object)spiedFs)).getAbfsStore();
        spiedStore.setClient(spiedClient);
        spiedFs.setWorkingDirectory(new Path("/"));
        AbfsClientTestUtil.setMockAbfsRestOperationForListPathOperation(spiedClient, (FunctionRaisingIOE<AbfsJdkHttpOperation, AbfsJdkHttpOperation>)((FunctionRaisingIOE)httpOperation -> {
            ListResultEntrySchema entry = new ListResultEntrySchema().withName("a").withIsDirectory(Boolean.valueOf(true));
            ArrayList<ListResultEntrySchema> paths = new ArrayList<ListResultEntrySchema>();
            paths.add(entry);
            paths.clear();
            entry = new ListResultEntrySchema().withName("abc.txt").withIsDirectory(Boolean.valueOf(false));
            paths.add(entry);
            ListResultSchema schema1 = new ListResultSchema().withPaths(paths);
            ListResultSchema schema2 = new ListResultSchema().withPaths(paths);
            Mockito.when((Object)httpOperation.getListResultSchema()).thenReturn((Object)schema1).thenReturn((Object)schema2);
            Mockito.when((Object)httpOperation.getResponseHeader("x-ms-continuation")).thenReturn((Object)TEST_CONTINUATION_TOKEN).thenReturn((Object)"");
            Stubber stubber = Mockito.doThrow((Throwable[])new Throwable[]{new SocketTimeoutException("connect timed out")});
            ((AbfsJdkHttpOperation)stubber.doNothing().when(httpOperation)).processResponse((byte[])ArgumentMatchers.nullable(byte[].class), ((Integer)ArgumentMatchers.nullable(Integer.TYPE)).intValue(), ((Integer)ArgumentMatchers.nullable(Integer.TYPE)).intValue());
            Mockito.when((Object)httpOperation.getStatusCode()).thenReturn((Object)-1).thenReturn((Object)200);
            return httpOperation;
        }));
        ArrayList fileStatuses = new ArrayList();
        spiedStore.listStatus(new Path("/"), "", fileStatuses, true, null, spiedTracingContext);
        ((AbfsClient)Mockito.verify((Object)spiedClient, (VerificationMode)Mockito.times((int)1))).listPath("/", false, spiedFs.getAbfsStore().getAbfsConfiguration().getListMaxResults(), null, spiedTracingContext);
        ((AbfsClient)Mockito.verify((Object)spiedClient, (VerificationMode)Mockito.times((int)1))).listPath("/", false, spiedFs.getAbfsStore().getAbfsConfiguration().getListMaxResults(), TEST_CONTINUATION_TOKEN, spiedTracingContext);
        ((TracingContext)Mockito.verify((Object)spiedTracingContext, (VerificationMode)Mockito.times((int)0))).constructHeader((AbfsHttpOperation)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void testListFileVsListDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path path = this.path("/testFile");
        try (FSDataOutputStream ignored = fs.create(path);){
            FileStatus[] testFiles = fs.listStatus(path);
            ITestAzureBlobFileSystemListStatus.assertEquals((String)"length of test files", (long)1L, (long)testFiles.length);
            FileStatus status = testFiles[0];
            this.assertIsFileReference(status);
        }
    }

    @Test
    public void testListFileVsListDir2() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFolder = this.path("/testFolder");
        fs.mkdirs(testFolder);
        fs.mkdirs(new Path(testFolder + "/testFolder2"));
        fs.mkdirs(new Path(testFolder + "/testFolder2/testFolder3"));
        Path testFile0Path = new Path(testFolder + "/testFolder2/testFolder3/testFile");
        ContractTestUtils.touch((FileSystem)fs, (Path)testFile0Path);
        FileStatus[] testFiles = fs.listStatus(testFile0Path);
        ITestAzureBlobFileSystemListStatus.assertEquals((String)("Wrong listing size of file " + testFile0Path), (long)1L, (long)testFiles.length);
        FileStatus file0 = testFiles[0];
        ITestAzureBlobFileSystemListStatus.assertEquals((String)("Wrong path for " + file0), (Object)new Path(this.getTestUrl(), testFolder + "/testFolder2/testFolder3/testFile"), (Object)file0.getPath());
        this.assertIsFileReference(file0);
    }

    @Test(expected=FileNotFoundException.class)
    public void testListNonExistentDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.listStatus(new Path("/testFile/"));
    }

    @Test
    public void testListFiles() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testDir = this.path("/test");
        fs.mkdirs(testDir);
        FileStatus[] fileStatuses = fs.listStatus(new Path("/"));
        ITestAzureBlobFileSystemListStatus.assertEquals((long)1L, (long)fileStatuses.length);
        fs.mkdirs(new Path(testDir + "/sub"));
        fileStatuses = fs.listStatus(testDir);
        ITestAzureBlobFileSystemListStatus.assertEquals((long)1L, (long)fileStatuses.length);
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)"sub", (Object)fileStatuses[0].getPath().getName());
        this.assertIsDirectoryReference(fileStatuses[0]);
        Path childF = fs.makeQualified(new Path(testDir + "/f"));
        this.touch(childF);
        fileStatuses = fs.listStatus(testDir);
        ITestAzureBlobFileSystemListStatus.assertEquals((long)2L, (long)fileStatuses.length);
        FileStatus childStatus = fileStatuses[0];
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)childF, (Object)childStatus.getPath());
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)"f", (Object)childStatus.getPath().getName());
        this.assertIsFileReference(childStatus);
        ITestAzureBlobFileSystemListStatus.assertEquals((long)0L, (long)childStatus.getLen());
        FileStatus status1 = fileStatuses[1];
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)"sub", (Object)status1.getPath().getName());
        this.assertIsDirectoryReference(status1);
        LocatedFileStatus locatedChildStatus = (LocatedFileStatus)fs.listFiles(childF, false).next();
        this.assertIsFileReference((FileStatus)locatedChildStatus);
        fs.delete(testDir, true);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> (LocatedFileStatus)fs.listFiles(childF, false).next());
        ITestAzureBlobFileSystemListStatus.assertEquals((String)("Path mismatch of " + locatedChildStatus), (Object)childF, (Object)locatedChildStatus.getPath());
        ITestAzureBlobFileSystemListStatus.assertEquals((String)"locatedstatus.equals(status)", (Object)locatedChildStatus, (Object)childStatus);
        ITestAzureBlobFileSystemListStatus.assertEquals((String)"status.equals(locatedstatus)", (Object)childStatus, (Object)locatedChildStatus);
    }

    private void assertIsDirectoryReference(FileStatus status) {
        ITestAzureBlobFileSystemListStatus.assertTrue((String)("Not a directory: " + status), (boolean)status.isDirectory());
        ITestAzureBlobFileSystemListStatus.assertFalse((String)("Not a directory: " + status), (boolean)status.isFile());
        ITestAzureBlobFileSystemListStatus.assertEquals((long)0L, (long)status.getLen());
    }

    private void assertIsFileReference(FileStatus status) {
        ITestAzureBlobFileSystemListStatus.assertFalse((String)("Not a file: " + status), (boolean)status.isDirectory());
        ITestAzureBlobFileSystemListStatus.assertTrue((String)("Not a file: " + status), (boolean)status.isFile());
    }

    @Test
    public void testMkdirTrailingPeriodDirName() throws IOException {
        boolean exceptionThrown = false;
        AzureBlobFileSystem fs = this.getFileSystem();
        Path nontrailingPeriodDir = this.path("testTrailingDir/dir");
        Path trailingPeriodDir = new Path("testMkdirTrailingDir/dir.");
        ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)nontrailingPeriodDir);
        try {
            fs.mkdirs(trailingPeriodDir);
        }
        catch (IllegalArgumentException e) {
            exceptionThrown = true;
        }
        ITestAzureBlobFileSystemListStatus.assertTrue((String)"Attempt to create file that ended with a dot should throw IllegalArgumentException", (boolean)exceptionThrown);
    }

    @Test
    public void testCreateTrailingPeriodFileName() throws IOException {
        boolean exceptionThrown = false;
        AzureBlobFileSystem fs = this.getFileSystem();
        Path trailingPeriodFile = new Path("testTrailingDir/file.");
        Path nontrailingPeriodFile = this.path("testCreateTrailingDir/file");
        ContractTestUtils.createFile((FileSystem)fs, (Path)nontrailingPeriodFile, (boolean)false, (byte[])new byte[0]);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"Trailing period file does not exist", (Path)nontrailingPeriodFile);
        try {
            ContractTestUtils.createFile((FileSystem)fs, (Path)trailingPeriodFile, (boolean)false, (byte[])new byte[0]);
        }
        catch (IllegalArgumentException e) {
            exceptionThrown = true;
        }
        ITestAzureBlobFileSystemListStatus.assertTrue((String)"Attempt to create file that ended with a dot should throw IllegalArgumentException", (boolean)exceptionThrown);
    }

    @Test
    public void testRenameTrailingPeriodFile() throws IOException {
        boolean exceptionThrown = false;
        AzureBlobFileSystem fs = this.getFileSystem();
        Path nonTrailingPeriodFile = this.path("testTrailingDir/file");
        Path trailingPeriodFile = new Path("testRenameTrailingDir/file.");
        ContractTestUtils.createFile((FileSystem)fs, (Path)nonTrailingPeriodFile, (boolean)false, (byte[])new byte[0]);
        try {
            ContractTestUtils.rename((FileSystem)fs, (Path)nonTrailingPeriodFile, (Path)trailingPeriodFile);
        }
        catch (IllegalArgumentException e) {
            exceptionThrown = true;
        }
        ITestAzureBlobFileSystemListStatus.assertTrue((String)"Attempt to create file that ended with a dot should throw IllegalArgumentException", (boolean)exceptionThrown);
    }
}

