/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStreamContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStreamStatisticsImpl;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.io.IOUtils;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestAbfsInputStreamStatistics
extends AbstractAbfsIntegrationTest {
    private static final int OPERATIONS = 10;
    private static final Logger LOG = LoggerFactory.getLogger(ITestAbfsInputStreamStatistics.class);
    private static final int ONE_MB = 0x100000;
    private static final int ONE_KB = 1024;
    private static final int CUSTOM_BLOCK_BUFFER_SIZE = 4096;
    private byte[] defBuffer = new byte[0x100000];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitValues() throws IOException {
        this.describe("Testing the initial values of AbfsInputStream Statistics", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        AzureBlobFileSystemStore abfss = fs.getAbfsStore();
        Path initValuesPath = this.path(this.getMethodName());
        AbfsOutputStream outputStream = null;
        AbfsInputStream inputStream = null;
        try {
            outputStream = this.createAbfsOutputStreamWithFlushEnabled(fs, initValuesPath);
            inputStream = abfss.openFileForRead(initValuesPath, fs.getFsStatistics(), this.getTestTracingContext(fs, false));
            AbfsInputStreamStatisticsImpl stats = (AbfsInputStreamStatisticsImpl)inputStream.getStreamStatistics();
            this.checkInitValue(stats.getSeekOperations(), "seekOps");
            this.checkInitValue(stats.getForwardSeekOperations(), "forwardSeekOps");
            this.checkInitValue(stats.getBackwardSeekOperations(), "backwardSeekOps");
            this.checkInitValue(stats.getBytesRead(), "bytesRead");
            this.checkInitValue(stats.getBytesSkippedOnSeek(), "bytesSkippedOnSeek");
            this.checkInitValue(stats.getBytesBackwardsOnSeek(), "bytesBackwardsOnSeek");
            this.checkInitValue(stats.getSeekInBuffer(), "seekInBuffer");
            this.checkInitValue(stats.getReadOperations(), "readOps");
            this.checkInitValue(stats.getBytesReadFromBuffer(), "bytesReadFromBuffer");
            this.checkInitValue(stats.getRemoteReadOperations(), "remoteReadOps");
            this.checkInitValue(stats.getReadAheadBytesRead(), "readAheadBytesRead");
            this.checkInitValue(stats.getRemoteBytesRead(), "readAheadRemoteBytesRead");
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{outputStream, inputStream});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{outputStream, inputStream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSeekStatistics() throws IOException {
        this.describe("Testing the values of statistics from seek operations in AbfsInputStream", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        AzureBlobFileSystemStore abfss = fs.getAbfsStore();
        Path seekStatPath = this.path(this.getMethodName());
        AbfsOutputStream out = null;
        AbfsInputStream in = null;
        try {
            out = this.createAbfsOutputStreamWithFlushEnabled(fs, seekStatPath);
            out.write(this.defBuffer);
            out.hflush();
            in = abfss.openFileForRead(seekStatPath, fs.getFsStatistics(), this.getTestTracingContext(fs, false));
            int result = in.read(this.defBuffer, 0, 0x100000);
            LOG.info("Result of read : {}", (Object)result);
            for (int i = 0; i < 10; ++i) {
                in.seek(0L);
                in.read();
                in.seek(0x100000L);
            }
            AbfsInputStreamStatisticsImpl stats = (AbfsInputStreamStatisticsImpl)in.getStreamStatistics();
            LOG.info("STATISTICS: {}", (Object)stats.toString());
            ITestAbfsInputStreamStatistics.assertEquals((String)"Mismatch in seekOps value", (long)20L, (long)stats.getSeekOperations());
            ITestAbfsInputStreamStatistics.assertEquals((String)"Mismatch in backwardSeekOps value", (long)10L, (long)stats.getBackwardSeekOperations());
            ITestAbfsInputStreamStatistics.assertEquals((String)"Mismatch in forwardSeekOps value", (long)10L, (long)stats.getForwardSeekOperations());
            ITestAbfsInputStreamStatistics.assertEquals((String)"Mismatch in bytesBackwardsOnSeek value", (long)0xA00000L, (long)stats.getBytesBackwardsOnSeek());
            ITestAbfsInputStreamStatistics.assertEquals((String)"Mismatch in bytesSkippedOnSeek value", (long)0L, (long)stats.getBytesSkippedOnSeek());
            ITestAbfsInputStreamStatistics.assertEquals((String)"Mismatch in seekInBuffer value", (long)10L, (long)stats.getSeekInBuffer());
            in.close();
            LOG.info("STATISTICS after closing: {}", (Object)stats.toString());
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out, in});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out, in});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadStatistics() throws IOException {
        this.describe("Testing the values of statistics from read operation in AbfsInputStream", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        AzureBlobFileSystemStore abfss = fs.getAbfsStore();
        Path readStatPath = this.path(this.getMethodName());
        AbfsOutputStream out = null;
        AbfsInputStream in = null;
        try {
            out = this.createAbfsOutputStreamWithFlushEnabled(fs, readStatPath);
            out.write(this.defBuffer);
            out.hflush();
            in = abfss.openFileForRead(readStatPath, fs.getFsStatistics(), this.getTestTracingContext(fs, false));
            for (int i = 0; i < 10; ++i) {
                in.read();
            }
            AbfsInputStreamStatisticsImpl stats = (AbfsInputStreamStatisticsImpl)in.getStreamStatistics();
            LOG.info("STATISTICS: {}", (Object)stats.toString());
            ITestAbfsInputStreamStatistics.assertEquals((String)"Mismatch in bytesRead value", (long)10L, (long)stats.getBytesRead());
            ITestAbfsInputStreamStatistics.assertEquals((String)"Mismatch in readOps value", (long)10L, (long)stats.getReadOperations());
            ITestAbfsInputStreamStatistics.assertEquals((String)"Mismatch in remoteReadOps value", (long)1L, (long)stats.getRemoteReadOperations());
            in.close();
            LOG.info("STATISTICS after closing: {}", (Object)stats.toString());
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out, in});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out, in});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithNullStreamStatistics() throws IOException {
        this.describe("Testing AbfsInputStream operations with statistics as null", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        Path nullStatFilePath = this.path(this.getMethodName());
        byte[] oneKbBuff = new byte[1024];
        AbfsInputStreamContext abfsInputStreamContext = new AbfsInputStreamContext(this.getConfiguration().getSasTokenRenewPeriodForStreamsInSeconds()).withReadBufferSize(this.getConfiguration().getReadBufferSize()).withReadAheadQueueDepth(this.getConfiguration().getReadAheadQueueDepth()).withStreamStatistics(null).withReadAheadRange(this.getConfiguration().getReadAheadRange()).build();
        AbfsOutputStream out = null;
        AbfsInputStream in = null;
        try {
            out = this.createAbfsOutputStreamWithFlushEnabled(fs, nullStatFilePath);
            out.write(oneKbBuff);
            out.hflush();
            AbfsRestOperation abfsRestOperation = fs.getAbfsClient().getPathStatus(nullStatFilePath.toUri().getPath(), false, this.getTestTracingContext(fs, false), null);
            in = new AbfsInputStream(fs.getAbfsClient(), null, nullStatFilePath.toUri().getPath(), 1024L, abfsInputStreamContext, abfsRestOperation.getResult().getResponseHeader("ETag"), this.getTestTracingContext(fs, false));
            ITestAbfsInputStreamStatistics.assertNotEquals((String)"AbfsInputStream read() with null statistics should work", (long)-1L, (long)in.read());
            in.seek(1024L);
            LOG.info("AbfsInputStream: {}", (Object)in.toString());
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out, in});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out, in});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadAheadCounters() throws IOException {
        this.describe("Test to check correct values for readAhead counters in AbfsInputStream", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        AzureBlobFileSystemStore abfss = fs.getAbfsStore();
        Path readAheadCountersPath = this.path(this.getMethodName());
        abfss.getAbfsConfiguration().setReadBufferSize(4096);
        AbfsOutputStream out = null;
        AbfsInputStream in = null;
        try {
            out = this.createAbfsOutputStreamWithFlushEnabled(fs, readAheadCountersPath);
            out.write(this.defBuffer);
            out.close();
            in = abfss.openFileForRead(readAheadCountersPath, fs.getFsStatistics(), this.getTestTracingContext(fs, false));
            for (int i = 0; i < 5; ++i) {
                in.seek((long)(1024 * i));
                in.read(this.defBuffer, 1024 * i, 1024);
            }
            AbfsInputStreamStatisticsImpl stats = (AbfsInputStreamStatisticsImpl)in.getStreamStatistics();
            ((AbstractLongAssert)Assertions.assertThat((long)stats.getReadAheadBytesRead()).describedAs("Mismatch in readAheadBytesRead counter value", new Object[0])).isGreaterThanOrEqualTo(in.getBytesFromReadAhead());
            ((AbstractLongAssert)Assertions.assertThat((long)stats.getRemoteBytesRead()).describedAs("Mismatch in remoteBytesRead counter value", new Object[0])).isGreaterThanOrEqualTo(in.getBytesFromRemoteRead());
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out, in});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out, in});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testActionHttpGetRequest() throws IOException {
        this.describe("Test to check the correct value of Time taken by http get request in AbfsInputStream", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        AzureBlobFileSystemStore abfss = fs.getAbfsStore();
        Path actionHttpGetRequestPath = this.path(this.getMethodName());
        AbfsInputStream abfsInputStream = null;
        AbfsOutputStream abfsOutputStream = null;
        try {
            abfsOutputStream = this.createAbfsOutputStreamWithFlushEnabled(fs, actionHttpGetRequestPath);
            abfsOutputStream.write(97);
            abfsOutputStream.hflush();
            abfsInputStream = abfss.openFileForRead(actionHttpGetRequestPath, fs.getFsStatistics(), this.getTestTracingContext(fs, false));
            abfsInputStream.read();
            IOStatistics ioStatistics = IOStatisticAssertions.extractStatistics((Object)fs);
            LOG.info("AbfsInputStreamStats info: {}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)ioStatistics));
            ((AbstractDoubleAssert)Assertions.assertThat((double)IOStatisticAssertions.lookupMeanStatistic((IOStatistics)ioStatistics, (String)(AbfsStatistic.HTTP_GET_REQUEST.getStatName() + ".mean")).mean()).describedAs("Mismatch in time taken by a GET request", new Object[0])).isGreaterThan(0.0);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{abfsInputStream, abfsOutputStream});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{abfsInputStream, abfsOutputStream});
    }

    private void checkInitValue(long actualValue, String statistic) {
        ITestAbfsInputStreamStatistics.assertEquals((String)("Mismatch in " + statistic + " value"), (long)0L, (long)actualValue);
    }
}

