/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;

public class TracingHeaderValidator
implements Listener {
    private String clientCorrelationId;
    private String fileSystemId;
    private String primaryRequestId = "";
    private boolean needsPrimaryRequestId;
    private String streamID = "";
    private FSOperationType operation;
    private int retryNum;
    private TracingHeaderFormat format;
    private static final String GUID_PATTERN = "^[0-9a-fA-F]{8}-([0-9a-fA-F]{4}-){3}[0-9a-fA-F]{12}$";

    public void callTracingHeaderValidator(String tracingContextHeader, TracingHeaderFormat format) {
        this.format = format;
        this.validateTracingHeader(tracingContextHeader);
    }

    public TracingHeaderValidator getClone() {
        TracingHeaderValidator tracingHeaderValidator = new TracingHeaderValidator(this.clientCorrelationId, this.fileSystemId, this.operation, this.needsPrimaryRequestId, this.retryNum, this.streamID);
        tracingHeaderValidator.primaryRequestId = this.primaryRequestId;
        return tracingHeaderValidator;
    }

    public TracingHeaderValidator(String clientCorrelationId, String fileSystemId, FSOperationType operation, boolean needsPrimaryRequestId, int retryNum) {
        this.clientCorrelationId = clientCorrelationId;
        this.fileSystemId = fileSystemId;
        this.operation = operation;
        this.retryNum = retryNum;
        this.needsPrimaryRequestId = needsPrimaryRequestId;
    }

    public TracingHeaderValidator(String clientCorrelationId, String fileSystemId, FSOperationType operation, boolean needsPrimaryRequestId, int retryNum, String streamID) {
        this(clientCorrelationId, fileSystemId, operation, needsPrimaryRequestId, retryNum);
        this.streamID = streamID;
    }

    private void validateTracingHeader(String tracingContextHeader) {
        String[] idList = tracingContextHeader.split(":");
        this.validateBasicFormat(idList);
        if (this.format != TracingHeaderFormat.ALL_ID_FORMAT) {
            return;
        }
        if (!this.primaryRequestId.isEmpty() && !idList[3].isEmpty()) {
            ((AbstractStringAssert)Assertions.assertThat((String)idList[3]).describedAs("PrimaryReqID should be common for these requests", new Object[0])).isEqualTo((Object)this.primaryRequestId);
        }
        if (!this.streamID.isEmpty()) {
            ((AbstractStringAssert)Assertions.assertThat((String)idList[4]).describedAs("Stream id should be common for these requests", new Object[0])).isEqualTo((Object)this.streamID);
        }
    }

    private void validateBasicFormat(String[] idList) {
        if (this.format == TracingHeaderFormat.ALL_ID_FORMAT) {
            ((ObjectArrayAssert)Assertions.assertThat((Object[])idList).describedAs("header should have 7 elements", new Object[0])).hasSize(7);
        } else if (this.format == TracingHeaderFormat.TWO_ID_FORMAT) {
            ((ObjectArrayAssert)Assertions.assertThat((Object[])idList).describedAs("header should have 2 elements", new Object[0])).hasSize(2);
        } else {
            ((ObjectArrayAssert)Assertions.assertThat((Object[])idList).describedAs("header should have 1 element", new Object[0])).hasSize(1);
            ((AbstractStringAssert)Assertions.assertThat((String)idList[0]).describedAs("Client request ID is a guid", new Object[0])).matches((CharSequence)GUID_PATTERN);
            return;
        }
        if (this.clientCorrelationId.matches("[a-zA-Z0-9-]*")) {
            ((AbstractStringAssert)Assertions.assertThat((String)idList[0]).describedAs("Correlation ID should match config", new Object[0])).isEqualTo((Object)this.clientCorrelationId);
        } else {
            ((AbstractStringAssert)Assertions.assertThat((String)idList[0]).describedAs("Invalid config should be replaced with empty string", new Object[0])).isEmpty();
        }
        ((AbstractStringAssert)Assertions.assertThat((String)idList[1]).describedAs("Client request ID is a guid", new Object[0])).matches((CharSequence)GUID_PATTERN);
        if (this.format != TracingHeaderFormat.ALL_ID_FORMAT) {
            return;
        }
        ((AbstractStringAssert)Assertions.assertThat((String)idList[2]).describedAs("Filesystem ID incorrect", new Object[0])).isEqualTo((Object)this.fileSystemId);
        if (this.needsPrimaryRequestId && !this.operation.equals((Object)FSOperationType.READ)) {
            ((AbstractStringAssert)Assertions.assertThat((String)idList[3]).describedAs("should have primaryReqId", new Object[0])).isNotEmpty();
        }
        ((AbstractStringAssert)Assertions.assertThat((String)idList[5]).describedAs("Operation name incorrect", new Object[0])).isEqualTo((Object)this.operation.toString());
        int retryCount = Integer.parseInt(idList[6]);
        ((AbstractIntegerAssert)Assertions.assertThat((int)retryCount).describedAs("Retry was required due to issue on server side", new Object[0])).isEqualTo(this.retryNum);
    }

    public void setOperation(FSOperationType operation) {
        this.operation = operation;
    }

    public void updatePrimaryRequestID(String primaryRequestId) {
        this.primaryRequestId = primaryRequestId;
    }
}

