/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ITestAbfsOutputStream
extends AbstractAbfsIntegrationTest {
    private static final String TEST_FILE_PATH = "testfile";

    @Test
    public void testMaxRequestsAndQueueCapacityDefaults() throws Exception {
        Configuration conf = this.getRawConfiguration();
        AzureBlobFileSystem fs = this.getFileSystem(conf);
        try (FSDataOutputStream out = fs.create(this.path(TEST_FILE_PATH));){
            AbfsOutputStream stream = (AbfsOutputStream)out.getWrappedStream();
            int maxConcurrentRequests = this.getConfiguration().getWriteMaxConcurrentRequestCount();
            if (stream.isAppendBlobStream().booleanValue()) {
                maxConcurrentRequests = 1;
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)stream.getMaxConcurrentRequestCount()).describedAs("maxConcurrentRequests should be " + maxConcurrentRequests, new Object[0])).isEqualTo(maxConcurrentRequests);
            ((AbstractIntegerAssert)Assertions.assertThat((int)stream.getMaxRequestsThatCanBeQueued()).describedAs("maxRequestsToQueue should be " + this.getConfiguration().getMaxWriteRequestsToQueue(), new Object[0])).isEqualTo(this.getConfiguration().getMaxWriteRequestsToQueue());
        }
    }

    @Test
    public void testMaxRequestsAndQueueCapacity() throws Exception {
        Configuration conf = this.getRawConfiguration();
        int maxConcurrentRequests = 6;
        int maxRequestsToQueue = 10;
        conf.set("fs.azure.write.max.concurrent.requests", "" + maxConcurrentRequests);
        conf.set("fs.azure.write.max.requests.to.queue", "" + maxRequestsToQueue);
        AzureBlobFileSystem fs = this.getFileSystem(conf);
        try (FSDataOutputStream out = fs.create(this.path(TEST_FILE_PATH));){
            AbfsOutputStream stream = (AbfsOutputStream)out.getWrappedStream();
            if (stream.isAppendBlobStream().booleanValue()) {
                maxConcurrentRequests = 1;
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)stream.getMaxConcurrentRequestCount()).describedAs("maxConcurrentRequests should be " + maxConcurrentRequests, new Object[0])).isEqualTo(maxConcurrentRequests);
            ((AbstractIntegerAssert)Assertions.assertThat((int)stream.getMaxRequestsThatCanBeQueued()).describedAs("maxRequestsToQueue should be " + maxRequestsToQueue, new Object[0])).isEqualTo(maxRequestsToQueue);
        }
    }
}

