/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.metrics;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class TestNativeAzureFileSystemMetricsSystem {
    private static final String WASB_FILES_CREATED = "wasb_files_created";

    private static int getFilesCreated(AzureBlobStorageTestAccount testAccount) {
        return testAccount.getLatestMetricValue(WASB_FILES_CREATED, 0).intValue();
    }

    @Test
    public void testMetricsAcrossFileSystems() throws Exception {
        AzureBlobStorageTestAccount a1 = AzureBlobStorageTestAccount.createMock();
        this.assertFilesCreated(a1, "a1", 0);
        AzureBlobStorageTestAccount a2 = AzureBlobStorageTestAccount.createMock();
        this.assertFilesCreated(a2, "a2", 0);
        a1.getFileSystem().create(new Path("/foo")).close();
        a1.getFileSystem().create(new Path("/bar")).close();
        a2.getFileSystem().create(new Path("/baz")).close();
        this.assertFilesCreated(a1, "a1", 0);
        this.assertFilesCreated(a2, "a2", 0);
        a1.closeFileSystem();
        a2.closeFileSystem();
        this.assertFilesCreated(a1, "a1", 2);
        this.assertFilesCreated(a2, "a2", 1);
        AzureBlobStorageTestAccount a3 = AzureBlobStorageTestAccount.createMock();
        this.assertFilesCreated(a3, "a3", 0);
        a3.closeFileSystem();
        this.assertFilesCreated(a3, "a3", 0);
    }

    private void assertFilesCreated(AzureBlobStorageTestAccount account, String name, int expected) {
        Assert.assertEquals((String)("Files created in account " + name), (long)expected, (long)TestNativeAzureFileSystemMetricsSystem.getFilesCreated(account));
    }

    @Test
    public void testMetricsSourceNames() {
        String name1 = NativeAzureFileSystem.newMetricsSourceName();
        String name2 = NativeAzureFileSystem.newMetricsSourceName();
        Assert.assertTrue((boolean)name1.startsWith("AzureFileSystemMetrics"));
        Assert.assertTrue((boolean)name2.startsWith("AzureFileSystemMetrics"));
        Assert.assertTrue((!name1.equals(name2) ? 1 : 0) != 0);
    }

    @Test
    public void testSkipMetricsCollection() throws Exception {
        AzureBlobStorageTestAccount a = AzureBlobStorageTestAccount.createMock();
        a.getFileSystem().getConf().setBoolean("fs.azure.skip.metrics", true);
        a.getFileSystem().create(new Path("/foo")).close();
        a.closeFileSystem();
        this.assertFilesCreated(a, "a", 0);
    }
}

