/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestAzureConcurrentOutOfBandIo
extends AbstractWasbTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(ITestAzureConcurrentOutOfBandIo.class);
    static final int DOWNLOAD_BLOCK_SIZE = 0x800000;
    static final int UPLOAD_BLOCK_SIZE = 0x400000;
    static final int BLOB_SIZE = 0x2000000;
    static final int NUMBER_OF_BLOCKS = 2;

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.createOutOfBandStore(0x400000, 0x800000);
    }

    @Test
    public void testReadOOBWrites() throws Exception {
        byte[] dataBlockWrite = new byte[0x400000];
        byte[] dataBlockRead = new byte[0x400000];
        String key = "WASB_String" + AzureTestUtils.getForkID() + ".txt";
        DataOutputStream outputStream = this.testAccount.getStore().storefile(key, new PermissionStatus("", "", FsPermission.getDefault()), key);
        Arrays.fill(dataBlockWrite, (byte)-1);
        for (int i = 0; i < 2; ++i) {
            ((OutputStream)outputStream).write(dataBlockWrite);
        }
        ((OutputStream)outputStream).flush();
        ((OutputStream)outputStream).close();
        DataBlockWriter writeBlockTask = new DataBlockWriter(this.testAccount, key);
        writeBlockTask.startWriting();
        int count = 0;
        block8: for (int i = 0; i < 5; ++i) {
            try (InputStream inputStream = this.testAccount.getStore().retrieve(key);){
                count = 0;
                int c = 0;
                while (c >= 0) {
                    c = inputStream.read(dataBlockRead, 0, 0x400000);
                    if (c < 0) {
                        continue block8;
                    }
                    count += c;
                }
                continue;
            }
            catch (IOException e) {
                System.out.println(e.getCause().toString());
                e.printStackTrace();
                ITestAzureConcurrentOutOfBandIo.fail();
            }
        }
        writeBlockTask.stopWriting();
        ITestAzureConcurrentOutOfBandIo.assertEquals((long)0x800000L, (long)count);
    }

    class DataBlockWriter
    implements Runnable {
        Thread runner;
        AzureBlobStorageTestAccount writerStorageAccount;
        String key;
        boolean done = false;

        public DataBlockWriter(AzureBlobStorageTestAccount testAccount, String key) {
            this.writerStorageAccount = testAccount;
            this.key = key;
        }

        public void startWriting() {
            this.runner = new Thread(this);
            this.runner.start();
        }

        public void stopWriting() {
            this.done = true;
        }

        @Override
        public void run() {
            byte[] dataBlockWrite = new byte[0x400000];
            DataOutputStream outputStream = null;
            try {
                int i = 0;
                while (!this.done) {
                    outputStream = this.writerStorageAccount.getStore().storefile(this.key, new PermissionStatus("", "", FsPermission.getDefault()), this.key);
                    Arrays.fill(dataBlockWrite, (byte)(i % 256));
                    for (int j = 0; j < 2; ++j) {
                        ((OutputStream)outputStream).write(dataBlockWrite);
                    }
                    ((OutputStream)outputStream).flush();
                    ((OutputStream)outputStream).close();
                    ++i;
                }
            }
            catch (AzureException e) {
                LOG.error("DatablockWriter thread encountered a storage exception." + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error("DatablockWriter thread encountered an I/O exception." + e.getMessage(), (Throwable)e);
            }
        }
    }
}

