/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.contract;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.azurebfs.contract.ABFSContractTestBinding;
import org.apache.hadoop.fs.azurebfs.contract.AbfsFileSystemContract;
import org.apache.hadoop.fs.contract.AbstractContractUnbufferTest;

public class ITestAbfsContractUnbuffer
extends AbstractContractUnbufferTest {
    private final boolean isSecure;
    private final ABFSContractTestBinding binding = new ABFSContractTestBinding();

    public ITestAbfsContractUnbuffer() throws Exception {
        this.isSecure = this.binding.isSecureMode();
    }

    public void setup() throws Exception {
        this.binding.setup();
        super.setup();
    }

    protected Configuration createConfiguration() {
        return this.binding.getRawConfiguration();
    }

    protected AbfsFileSystemContract createContract(Configuration conf) {
        return new AbfsFileSystemContract(conf, this.isSecure);
    }

    public void testUnbufferOnClosedFile() throws IOException {
        this.describe("unbuffer a file before a read");
        try (FSDataInputStream stream = null;){
            stream = this.getFileSystem().open(this.getFile());
            this.validateFullFileContents(stream);
        }
        if (stream != null) {
            stream.unbuffer();
        }
    }
}

