/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assume;
import org.junit.Test;

public class ITestSharedKeyAuth
extends AbstractAbfsIntegrationTest {
    @Test
    public void testWithWrongSharedKey() throws Exception {
        Assume.assumeTrue((this.getAuthType() == AuthType.SharedKey ? 1 : 0) != 0);
        Configuration config = this.getRawConfiguration();
        config.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", false);
        String accountName = this.getAccountName();
        String configkKey = "fs.azure.account.key." + accountName;
        String secret = "XjUjsGherkDpljuyThd7RpljhR6uhsFjhlxRpmhgD12lnj7lhfRn8kgPt5+MJHS7UJNDER+jn6KP6Jnm2ONQlm==";
        config.set(configkKey, secret);
        AbfsClient abfsClient = this.getFileSystem(config).getAbfsClient();
        LambdaTestUtils.intercept(AbfsRestOperationException.class, (String)"\"Server failed to authenticate the request. Make sure the value of Authorization header is formed correctly including the signature.\", 403", () -> abfsClient.getAclStatus("/", this.getTestTracingContext(this.getFileSystem(), false)));
    }
}

