/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class ITestNativeAzureFileSystemContractPageBlobLive
extends FileSystemContractBaseTest {
    private AzureBlobStorageTestAccount testAccount;
    private Path basePath;
    @Rule
    public TestName methodName = new TestName();

    private void nameThread() {
        Thread.currentThread().setName("JUnit-" + this.methodName.getMethodName());
    }

    private AzureBlobStorageTestAccount createTestAccount() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.azure.page.blob.dir", "/");
        conf.set("fs.azure.atomic.rename.dir", "/");
        return AzureBlobStorageTestAccount.create(conf);
    }

    @Before
    public void setUp() throws Exception {
        this.testAccount = this.createTestAccount();
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        this.fs = this.testAccount.getFileSystem();
        this.basePath = AzureTestUtils.pathForTests(this.fs, "filesystemcontractpageblob");
    }

    public void tearDown() throws Exception {
        this.testAccount = AzureTestUtils.cleanup(this.testAccount);
        this.fs = null;
    }

    protected int getGlobalTimeout() {
        return 600000;
    }

    public Path getTestBaseDir() {
        return this.basePath;
    }

    @Ignore
    @Test
    public void testMoveFileUnderParent() throws Throwable {
    }

    @Ignore
    @Test
    public void testRenameFileToSelf() throws Throwable {
    }

    @Ignore
    @Test
    public void testRenameChildDirForbidden() throws Exception {
    }

    @Ignore
    @Test
    public void testMoveDirUnderParent() throws Throwable {
    }

    @Ignore
    @Test
    public void testRenameDirToSelf() throws Throwable {
    }
}

