/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.azurebfs.oauth2.QueryParams;
import org.junit.Assert;
import org.junit.Test;

public class TestQueryParams {
    private static final String SEPARATOR = "&";
    private static final String[][] PARAM_ARRAY = new String[][]{{"K0", "V0"}, {"K1", "V1"}, {"K2", "V2"}};

    @Test
    public void testOneParam() {
        String key = PARAM_ARRAY[0][0];
        String value = PARAM_ARRAY[0][1];
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(key, value);
        QueryParams qp = new QueryParams();
        qp.add(key, value);
        Assert.assertEquals((Object)(key + "=" + value), (Object)qp.serialize());
    }

    @Test
    public void testMultipleParams() {
        QueryParams qp = new QueryParams();
        for (String[] entry : PARAM_ARRAY) {
            qp.add(entry[0], entry[1]);
        }
        Map<String, String> paramMap = this.constructMap(qp.serialize());
        Assert.assertEquals((long)PARAM_ARRAY.length, (long)paramMap.size());
        for (String[] entry : PARAM_ARRAY) {
            Assert.assertTrue((boolean)paramMap.containsKey(entry[0]));
            Assert.assertEquals((Object)entry[1], (Object)paramMap.get(entry[0]));
        }
    }

    private Map<String, String> constructMap(String input) {
        String[] entries = input.split(SEPARATOR);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String entry : entries) {
            String[] keyValue = entry.split("=");
            paramMap.put(keyValue[0], keyValue[1]);
        }
        return paramMap;
    }
}

