/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureFileSystemThreadPoolExecutor;
import org.apache.hadoop.fs.azure.FileMetadata;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ITestFileSystemOperationsWithThreads
extends AbstractWasbTestBase {
    private final int renameThreads = 10;
    private final int deleteThreads = 20;
    private int iterations = 1;
    private GenericTestUtils.LogCapturer logs = null;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration conf = this.fs.getConf();
        conf.setInt("fs.azure.rename.threads", 10);
        conf.setInt("fs.azure.delete.threads", 20);
        conf.setBoolean("fs.azure.flatlist.enable", true);
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
        this.logs = GenericTestUtils.LogCapturer.captureLogs((Log)new Log4JLogger(Logger.getRootLogger()));
    }

    private void createFolder(FileSystem fs, String root) throws Exception {
        fs.mkdirs(new Path(root));
        for (int i = 0; i < this.iterations; ++i) {
            fs.mkdirs(new Path(root + "/" + i));
            fs.createNewFile(new Path(root + "/" + i + "/fileToRename"));
            fs.createNewFile(new Path(root + "/" + i + "/file/to/rename"));
            fs.createNewFile(new Path(root + "/" + i + "/file+to%rename"));
            fs.createNewFile(new Path(root + "/fileToRename" + i));
        }
    }

    private void validateRenameFolder(FileSystem fs, String source, String dest) throws Exception {
        this.createFolder(fs, source);
        Path sourceFolder = new Path(source);
        Path destFolder = new Path(dest);
        ITestFileSystemOperationsWithThreads.assertTrue((boolean)fs.rename(sourceFolder, destFolder));
        ITestFileSystemOperationsWithThreads.assertTrue((boolean)fs.exists(destFolder));
        for (int i = 0; i < this.iterations; ++i) {
            ITestFileSystemOperationsWithThreads.assertTrue((boolean)fs.exists(new Path(dest + "/" + i)));
            ITestFileSystemOperationsWithThreads.assertTrue((boolean)fs.exists(new Path(dest + "/" + i + "/fileToRename")));
            ITestFileSystemOperationsWithThreads.assertTrue((boolean)fs.exists(new Path(dest + "/" + i + "/file/to/rename")));
            ITestFileSystemOperationsWithThreads.assertTrue((boolean)fs.exists(new Path(dest + "/" + i + "/file+to%rename")));
            ITestFileSystemOperationsWithThreads.assertTrue((boolean)fs.exists(new Path(dest + "/fileToRename" + i)));
            ITestFileSystemOperationsWithThreads.assertFalse((boolean)fs.exists(new Path(source + "/" + i)));
            ITestFileSystemOperationsWithThreads.assertFalse((boolean)fs.exists(new Path(source + "/" + i + "/fileToRename")));
            ITestFileSystemOperationsWithThreads.assertFalse((boolean)fs.exists(new Path(source + "/" + i + "/file/to/rename")));
            ITestFileSystemOperationsWithThreads.assertFalse((boolean)fs.exists(new Path(source + "/" + i + "/file+to%rename")));
            ITestFileSystemOperationsWithThreads.assertFalse((boolean)fs.exists(new Path(source + "/fileToRename" + i)));
        }
    }

    @Test
    public void testRenameSmallFolderWithThreads() throws Exception {
        int i;
        this.validateRenameFolder((FileSystem)this.fs, "root", "rootnew");
        int expectedThreadsCreated = Math.min(7, 10);
        String content = this.logs.getOutput();
        this.assertInLog(content, "ms with threads: " + expectedThreadsCreated);
        for (i = 0; i < expectedThreadsCreated; ++i) {
            this.assertInLog(content, "AzureBlobRenameThread-" + Thread.currentThread().getName() + "-" + i);
        }
        if (expectedThreadsCreated < 10) {
            for (i = expectedThreadsCreated; i < 10; ++i) {
                this.assertNotInLog(content, "AzureBlobRenameThread-" + Thread.currentThread().getName() + "-" + i);
            }
        }
    }

    @Test
    public void testRenameLargeFolderWithThreads() throws Exception {
        this.iterations = 10;
        this.validateRenameFolder((FileSystem)this.fs, "root", "rootnew");
        String content = this.logs.getOutput();
        this.assertInLog(content, "ms with threads: 10");
        for (int i = 0; i < 10; ++i) {
            this.assertInLog(content, "AzureBlobRenameThread-" + Thread.currentThread().getName() + "-" + i);
        }
    }

    @Test
    public void testRenameLargeFolderDisableThreads() throws Exception {
        Configuration conf = this.fs.getConf();
        conf.setInt("fs.azure.rename.threads", 0);
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
        this.iterations = 10;
        this.validateRenameFolder((FileSystem)this.fs, "root", "rootnew");
        String content = this.logs.getOutput();
        this.assertInLog(content, "Disabling threads for Rename operation as thread count 0");
        for (int i = 0; i < 10; ++i) {
            String term = "AzureBlobRenameThread-" + Thread.currentThread().getName() + "-" + i;
            this.assertNotInLog(content, term);
        }
    }

    protected void assertInLog(String content, String term) {
        ITestFileSystemOperationsWithThreads.assertTrue((String)"Empty log", (!content.isEmpty() ? 1 : 0) != 0);
        if (!content.contains(term)) {
            String message = "No " + term + " found in logs";
            LOG.error(message);
            System.err.println(content);
            ITestFileSystemOperationsWithThreads.fail((String)message);
        }
    }

    protected void assertNotInLog(String content, String term) {
        ITestFileSystemOperationsWithThreads.assertTrue((String)"Empty log", (!content.isEmpty() ? 1 : 0) != 0);
        if (content.contains(term)) {
            String message = term + " found in logs";
            LOG.error(message);
            System.err.println(content);
            ITestFileSystemOperationsWithThreads.fail((String)message);
        }
    }

    @Test
    public void testRenameSmallFolderDisableThreadsDisableFlatListing() throws Exception {
        Configuration conf = this.fs.getConf();
        conf = this.fs.getConf();
        conf.setInt("fs.azure.rename.threads", 1);
        conf.setBoolean("fs.azure.flatlist.enable", false);
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
        this.validateRenameFolder((FileSystem)this.fs, "root", "rootnew");
        String content = this.logs.getOutput();
        this.assertInLog(content, "Disabling threads for Rename operation as thread count 1");
        for (int i = 0; i < 10; ++i) {
            this.assertNotInLog(content, "AzureBlobRenameThread-" + Thread.currentThread().getName() + "-" + i);
        }
    }

    private void validateDeleteFolder(FileSystem fs, String source) throws Exception {
        this.createFolder(fs, "root");
        Path sourceFolder = new Path(source);
        ITestFileSystemOperationsWithThreads.assertTrue((boolean)fs.delete(sourceFolder, true));
        ITestFileSystemOperationsWithThreads.assertFalse((boolean)fs.exists(sourceFolder));
        for (int i = 0; i < this.iterations; ++i) {
            ITestFileSystemOperationsWithThreads.assertFalse((boolean)fs.exists(new Path(source + "/" + i)));
            ITestFileSystemOperationsWithThreads.assertFalse((boolean)fs.exists(new Path(source + "/" + i + "/fileToRename")));
            ITestFileSystemOperationsWithThreads.assertFalse((boolean)fs.exists(new Path(source + "/" + i + "/file/to/rename")));
            ITestFileSystemOperationsWithThreads.assertFalse((boolean)fs.exists(new Path(source + "/" + i + "/file+to%rename")));
            ITestFileSystemOperationsWithThreads.assertFalse((boolean)fs.exists(new Path(source + "/fileToRename" + i)));
        }
    }

    @Test
    public void testDeleteSmallFolderWithThreads() throws Exception {
        int i;
        this.validateDeleteFolder((FileSystem)this.fs, "root");
        int expectedThreadsCreated = Math.min(7, 20);
        String content = this.logs.getOutput();
        this.assertInLog(content, "ms with threads: " + expectedThreadsCreated);
        for (i = 0; i < expectedThreadsCreated; ++i) {
            this.assertInLog(content, "AzureBlobDeleteThread-" + Thread.currentThread().getName() + "-" + i);
        }
        if (expectedThreadsCreated < 20) {
            for (i = expectedThreadsCreated; i < 20; ++i) {
                this.assertNotInLog(content, "AzureBlobDeleteThread-" + Thread.currentThread().getName() + "-" + i);
            }
        }
    }

    @Test
    public void testDeleteLargeFolderWithThreads() throws Exception {
        this.iterations = 10;
        this.validateDeleteFolder((FileSystem)this.fs, "root");
        String content = this.logs.getOutput();
        this.assertInLog(content, "ms with threads: 20");
        for (int i = 0; i < 20; ++i) {
            this.assertInLog(content, "AzureBlobDeleteThread-" + Thread.currentThread().getName() + "-" + i);
        }
    }

    @Test
    public void testDeleteLargeFolderDisableThreads() throws Exception {
        Configuration conf = this.fs.getConf();
        conf.setInt("fs.azure.delete.threads", 0);
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
        this.iterations = 10;
        this.validateDeleteFolder((FileSystem)this.fs, "root");
        String content = this.logs.getOutput();
        this.assertInLog(content, "Disabling threads for Delete operation as thread count 0");
        for (int i = 0; i < 20; ++i) {
            this.assertNotInLog(content, "AzureBlobDeleteThread-" + Thread.currentThread().getName() + "-" + i);
        }
    }

    @Test
    public void testDeleteSmallFolderDisableThreadsDisableFlatListing() throws Exception {
        Configuration conf = this.fs.getConf();
        conf.setInt("fs.azure.delete.threads", 1);
        conf.setBoolean("fs.azure.flatlist.enable", false);
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
        this.validateDeleteFolder((FileSystem)this.fs, "root");
        String content = this.logs.getOutput();
        this.assertInLog(content, "Disabling threads for Delete operation as thread count 1");
        for (int i = 0; i < 20; ++i) {
            this.assertNotInLog(content, "AzureBlobDeleteThread-" + Thread.currentThread().getName() + "-" + i);
        }
    }

    @Test
    public void testDeleteThreadPoolExceptionFailure() throws Exception {
        NativeAzureFileSystem mockFs = (NativeAzureFileSystem)Mockito.spy((Object)this.fs);
        String path = mockFs.pathToKey(mockFs.makeAbsolute(new Path("root")));
        AzureFileSystemThreadPoolExecutor mockThreadPoolExecutor = (AzureFileSystemThreadPoolExecutor)Mockito.spy((Object)mockFs.getThreadPoolExecutor(20, "AzureBlobDeleteThread", "Delete", path, "fs.azure.delete.threads"));
        Mockito.when((Object)mockThreadPoolExecutor.getThreadPool(7)).thenThrow(new Throwable[]{new Exception()});
        Mockito.when((Object)mockFs.getThreadPoolExecutor(20, "AzureBlobDeleteThread", "Delete", path, "fs.azure.delete.threads")).thenReturn((Object)mockThreadPoolExecutor);
        this.validateDeleteFolder((FileSystem)mockFs, "root");
        String content = this.logs.getOutput();
        this.assertInLog(content, "Failed to create thread pool with threads");
        this.assertInLog(content, "Serializing the Delete operation");
    }

    @Test
    public void testDeleteThreadPoolExecuteFailure() throws Exception {
        ThreadPoolExecutor mockThreadExecutor = (ThreadPoolExecutor)Mockito.mock(ThreadPoolExecutor.class);
        ((ThreadPoolExecutor)Mockito.doThrow((Throwable[])new Throwable[]{new RejectedExecutionException()}).when((Object)mockThreadExecutor)).execute((Runnable)Mockito.any(Runnable.class));
        NativeAzureFileSystem mockFs = (NativeAzureFileSystem)Mockito.spy((Object)this.fs);
        String path = mockFs.pathToKey(mockFs.makeAbsolute(new Path("root")));
        AzureFileSystemThreadPoolExecutor mockThreadPoolExecutor = (AzureFileSystemThreadPoolExecutor)Mockito.spy((Object)mockFs.getThreadPoolExecutor(20, "AzureBlobDeleteThread", "Delete", path, "fs.azure.delete.threads"));
        Mockito.when((Object)mockThreadPoolExecutor.getThreadPool(7)).thenReturn((Object)mockThreadExecutor);
        Mockito.when((Object)mockFs.getThreadPoolExecutor(20, "AzureBlobDeleteThread", "Delete", path, "fs.azure.delete.threads")).thenReturn((Object)mockThreadPoolExecutor);
        this.validateDeleteFolder((FileSystem)mockFs, "root");
        String content = this.logs.getOutput();
        this.assertInLog(content, "Rejected execution of thread for Delete operation on blob");
        this.assertInLog(content, "Serializing the Delete operation");
    }

    @Test
    public void testDeleteThreadPoolExecuteSingleThreadFailure() throws Exception {
        NativeAzureFileSystem mockFs = (NativeAzureFileSystem)Mockito.spy((Object)this.fs);
        String path = mockFs.pathToKey(mockFs.makeAbsolute(new Path("root")));
        AzureFileSystemThreadPoolExecutor mockThreadPoolExecutor = (AzureFileSystemThreadPoolExecutor)Mockito.spy((Object)mockFs.getThreadPoolExecutor(20, "AzureBlobDeleteThread", "Delete", path, "fs.azure.delete.threads"));
        Mockito.when((Object)mockFs.getThreadPoolExecutor(20, "AzureBlobDeleteThread", "Delete", path, "fs.azure.delete.threads")).thenReturn((Object)mockThreadPoolExecutor);
        ThreadPoolExecutor mockThreadExecutor = (ThreadPoolExecutor)Mockito.spy((Object)mockThreadPoolExecutor.getThreadPool(7));
        Mockito.when((Object)mockThreadPoolExecutor.getThreadPool(7)).thenReturn((Object)mockThreadExecutor);
        ((ThreadPoolExecutor)Mockito.doCallRealMethod().doThrow(new Throwable[]{new RejectedExecutionException()}).when((Object)mockThreadExecutor)).execute((Runnable)Mockito.any(Runnable.class));
        this.validateDeleteFolder((FileSystem)mockFs, "root");
        String content = this.logs.getOutput();
        this.assertInLog(content, "Using thread pool for Delete operation with threads 7");
        this.assertInLog(content, "6 threads not used for Delete operation on blob");
    }

    @Test
    public void testDeleteThreadPoolTerminationFailure() throws Exception {
        NativeAzureFileSystem mockFs = (NativeAzureFileSystem)Mockito.spy((Object)this.fs);
        String path = mockFs.pathToKey(mockFs.makeAbsolute(new Path("root")));
        AzureFileSystemThreadPoolExecutor mockThreadPoolExecutor = (AzureFileSystemThreadPoolExecutor)Mockito.spy((Object)this.fs.getThreadPoolExecutor(20, "AzureBlobDeleteThread", "Delete", path, "fs.azure.delete.threads"));
        ThreadPoolExecutor mockThreadExecutor = (ThreadPoolExecutor)Mockito.mock(ThreadPoolExecutor.class);
        ((ThreadPoolExecutor)Mockito.doNothing().when((Object)mockThreadExecutor)).execute((Runnable)Mockito.any(Runnable.class));
        Mockito.when((Object)mockThreadExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS)).thenThrow(new Throwable[]{new InterruptedException()});
        Mockito.when((Object)mockThreadPoolExecutor.getThreadPool(7)).thenReturn((Object)mockThreadExecutor);
        Mockito.when((Object)mockFs.getThreadPoolExecutor(20, "AzureBlobDeleteThread", "Delete", path, "fs.azure.delete.threads")).thenReturn((Object)mockThreadPoolExecutor);
        this.createFolder((FileSystem)mockFs, "root");
        Path sourceFolder = new Path("root");
        boolean exception = false;
        try {
            mockFs.delete(sourceFolder, true);
        }
        catch (IOException e) {
            exception = true;
        }
        ITestFileSystemOperationsWithThreads.assertTrue((boolean)exception);
        ITestFileSystemOperationsWithThreads.assertTrue((boolean)mockFs.exists(sourceFolder));
        String content = this.logs.getOutput();
        this.assertInLog(content, "Using thread pool for Delete operation with threads");
        this.assertInLog(content, "Threads got interrupted Delete blob operation");
        this.assertInLog(content, "Delete failed as operation on subfolders and files failed.");
    }

    @Test
    public void testRecursiveDirectoryDeleteWhenChildDirectoryDeleted() throws Exception {
        this.testRecusiveDirectoryDelete(true);
    }

    @Test
    public void testRecursiveDirectoryDeleteWhenDeletingChildFileReturnsFalse() throws Exception {
        this.testRecusiveDirectoryDelete(false);
    }

    private void testRecusiveDirectoryDelete(boolean useDir) throws Exception {
        String childPathToBeDeletedByExternalAgent = useDir ? "root/0" : "root/0/fileToRename";
        NativeAzureFileSystem mockFs = (NativeAzureFileSystem)Mockito.spy((Object)this.fs);
        String path = mockFs.pathToKey(mockFs.makeAbsolute(new Path(childPathToBeDeletedByExternalAgent)));
        Answer<Boolean> answer = new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                String path = (String)invocation.getArguments()[0];
                boolean isDir = (Boolean)invocation.getArguments()[1];
                boolean realResult = ITestFileSystemOperationsWithThreads.this.fs.deleteFile(path, isDir);
                Assert.assertTrue((boolean)realResult);
                boolean fakeResult = false;
                return fakeResult;
            }
        };
        Mockito.when((Object)mockFs.deleteFile(path, useDir)).thenAnswer((Answer)answer);
        this.createFolder((FileSystem)mockFs, "root");
        Path sourceFolder = new Path("root");
        ITestFileSystemOperationsWithThreads.assertTrue((boolean)mockFs.delete(sourceFolder, true));
        ITestFileSystemOperationsWithThreads.assertFalse((boolean)mockFs.exists(sourceFolder));
        String content = this.logs.getOutput();
        this.assertInLog(content, "Using thread pool for Delete operation with threads");
        this.assertInLog(content, String.format("Attempt to delete non-existent %s %s", useDir ? "directory" : "file", path));
    }

    @Test
    public void testDeleteSingleDeleteException() throws Exception {
        NativeAzureFileSystem mockFs = (NativeAzureFileSystem)Mockito.spy((Object)this.fs);
        String path = mockFs.pathToKey(mockFs.makeAbsolute(new Path("root/0")));
        ((NativeAzureFileSystem)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)mockFs)).deleteFile(path, true);
        this.createFolder((FileSystem)mockFs, "root");
        Path sourceFolder = new Path("root");
        boolean exception = false;
        try {
            mockFs.delete(sourceFolder, true);
        }
        catch (IOException e) {
            exception = true;
        }
        ITestFileSystemOperationsWithThreads.assertTrue((boolean)exception);
        ITestFileSystemOperationsWithThreads.assertTrue((boolean)mockFs.exists(sourceFolder));
        String content = this.logs.getOutput();
        this.assertInLog(content, "Using thread pool for Delete operation with threads");
        this.assertInLog(content, "Encountered Exception for Delete operation for file " + path);
        this.assertInLog(content, "Terminating execution of Delete operation now as some other thread already got exception or operation failed");
    }

    @Test
    public void testRenameThreadPoolExceptionFailure() throws Exception {
        NativeAzureFileSystem mockFs = (NativeAzureFileSystem)Mockito.spy((Object)this.fs);
        String path = mockFs.pathToKey(mockFs.makeAbsolute(new Path("root")));
        AzureFileSystemThreadPoolExecutor mockThreadPoolExecutor = (AzureFileSystemThreadPoolExecutor)Mockito.spy((Object)this.fs.getThreadPoolExecutor(10, "AzureBlobRenameThread", "Rename", path, "fs.azure.rename.threads"));
        Mockito.when((Object)mockThreadPoolExecutor.getThreadPool(7)).thenThrow(new Throwable[]{new Exception()});
        ((NativeAzureFileSystem)Mockito.doReturn((Object)mockThreadPoolExecutor).when((Object)mockFs)).getThreadPoolExecutor(10, "AzureBlobRenameThread", "Rename", path, "fs.azure.rename.threads");
        this.validateRenameFolder((FileSystem)mockFs, "root", "rootnew");
        String content = this.logs.getOutput();
        this.assertInLog(content, "Failed to create thread pool with threads");
        this.assertInLog(content, "Serializing the Rename operation");
    }

    @Test
    public void testRenameThreadPoolExecuteFailure() throws Exception {
        ThreadPoolExecutor mockThreadExecutor = (ThreadPoolExecutor)Mockito.mock(ThreadPoolExecutor.class);
        ((ThreadPoolExecutor)Mockito.doThrow((Throwable[])new Throwable[]{new RejectedExecutionException()}).when((Object)mockThreadExecutor)).execute((Runnable)Mockito.any(Runnable.class));
        NativeAzureFileSystem mockFs = (NativeAzureFileSystem)Mockito.spy((Object)this.fs);
        String path = mockFs.pathToKey(mockFs.makeAbsolute(new Path("root")));
        AzureFileSystemThreadPoolExecutor mockThreadPoolExecutor = (AzureFileSystemThreadPoolExecutor)Mockito.spy((Object)mockFs.getThreadPoolExecutor(10, "AzureBlobRenameThread", "Rename", path, "fs.azure.rename.threads"));
        Mockito.when((Object)mockThreadPoolExecutor.getThreadPool(7)).thenReturn((Object)mockThreadExecutor);
        Mockito.when((Object)mockFs.getThreadPoolExecutor(10, "AzureBlobRenameThread", "Rename", path, "fs.azure.rename.threads")).thenReturn((Object)mockThreadPoolExecutor);
        this.validateRenameFolder((FileSystem)mockFs, "root", "rootnew");
        String content = this.logs.getOutput();
        this.assertInLog(content, "Rejected execution of thread for Rename operation on blob");
        this.assertInLog(content, "Serializing the Rename operation");
    }

    @Test
    public void testRenameThreadPoolExecuteSingleThreadFailure() throws Exception {
        NativeAzureFileSystem mockFs = (NativeAzureFileSystem)Mockito.spy((Object)this.fs);
        String path = mockFs.pathToKey(mockFs.makeAbsolute(new Path("root")));
        AzureFileSystemThreadPoolExecutor mockThreadPoolExecutor = (AzureFileSystemThreadPoolExecutor)Mockito.spy((Object)mockFs.getThreadPoolExecutor(10, "AzureBlobRenameThread", "Rename", path, "fs.azure.rename.threads"));
        Mockito.when((Object)mockFs.getThreadPoolExecutor(10, "AzureBlobRenameThread", "Rename", path, "fs.azure.rename.threads")).thenReturn((Object)mockThreadPoolExecutor);
        ThreadPoolExecutor mockThreadExecutor = (ThreadPoolExecutor)Mockito.spy((Object)mockThreadPoolExecutor.getThreadPool(7));
        Mockito.when((Object)mockThreadPoolExecutor.getThreadPool(7)).thenReturn((Object)mockThreadExecutor);
        ((ThreadPoolExecutor)Mockito.doCallRealMethod().doThrow(new Throwable[]{new RejectedExecutionException()}).when((Object)mockThreadExecutor)).execute((Runnable)Mockito.any(Runnable.class));
        this.validateRenameFolder((FileSystem)mockFs, "root", "rootnew");
        String content = this.logs.getOutput();
        this.assertInLog(content, "Using thread pool for Rename operation with threads 7");
        this.assertInLog(content, "6 threads not used for Rename operation on blob");
    }

    @Test
    public void testRenameThreadPoolTerminationFailure() throws Exception {
        NativeAzureFileSystem mockFs = (NativeAzureFileSystem)Mockito.spy((Object)this.fs);
        String path = mockFs.pathToKey(mockFs.makeAbsolute(new Path("root")));
        AzureFileSystemThreadPoolExecutor mockThreadPoolExecutor = (AzureFileSystemThreadPoolExecutor)Mockito.spy((Object)mockFs.getThreadPoolExecutor(10, "AzureBlobRenameThread", "Rename", path, "fs.azure.rename.threads"));
        Mockito.when((Object)mockFs.getThreadPoolExecutor(10, "AzureBlobRenameThread", "Rename", path, "fs.azure.rename.threads")).thenReturn((Object)mockThreadPoolExecutor);
        ThreadPoolExecutor mockThreadExecutor = (ThreadPoolExecutor)Mockito.mock(ThreadPoolExecutor.class);
        ((ThreadPoolExecutor)Mockito.doNothing().when((Object)mockThreadExecutor)).execute((Runnable)Mockito.any(Runnable.class));
        Mockito.when((Object)mockThreadExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS)).thenThrow(new Throwable[]{new InterruptedException()});
        Mockito.when((Object)mockThreadPoolExecutor.getThreadPool(7)).thenReturn((Object)mockThreadExecutor);
        this.createFolder((FileSystem)mockFs, "root");
        Path sourceFolder = new Path("root");
        Path destFolder = new Path("rootnew");
        boolean exception = false;
        try {
            mockFs.rename(sourceFolder, destFolder);
        }
        catch (IOException e) {
            exception = true;
        }
        ITestFileSystemOperationsWithThreads.assertTrue((boolean)exception);
        ITestFileSystemOperationsWithThreads.assertTrue((boolean)mockFs.exists(sourceFolder));
        String content = this.logs.getOutput();
        this.assertInLog(content, "Using thread pool for Rename operation with threads");
        this.assertInLog(content, "Threads got interrupted Rename blob operation");
        this.assertInLog(content, "Rename failed as operation on subfolders and files failed.");
    }

    @Test
    public void testRenameSingleRenameException() throws Exception {
        Path sourceFolder = new Path("root");
        Path destFolder = new Path("rootnew");
        NativeAzureFileSystem mockFs = (NativeAzureFileSystem)Mockito.spy((Object)this.fs);
        this.createFolder((FileSystem)mockFs, "root");
        String srcKey = mockFs.pathToKey(mockFs.makeAbsolute(sourceFolder));
        String dstKey = mockFs.pathToKey(mockFs.makeAbsolute(destFolder));
        NativeAzureFileSystem.FolderRenamePending mockRenameFs = (NativeAzureFileSystem.FolderRenamePending)Mockito.spy((Object)mockFs.prepareAtomicFolderRename(srcKey, dstKey));
        Mockito.when((Object)mockFs.prepareAtomicFolderRename(srcKey, dstKey)).thenReturn((Object)mockRenameFs);
        String path = mockFs.pathToKey(mockFs.makeAbsolute(new Path("root/0")));
        ((NativeAzureFileSystem.FolderRenamePending)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)mockRenameFs)).renameFile((FileMetadata)Mockito.any(FileMetadata.class));
        boolean exception = false;
        try {
            mockFs.rename(sourceFolder, destFolder);
        }
        catch (IOException e) {
            exception = true;
        }
        ITestFileSystemOperationsWithThreads.assertTrue((boolean)exception);
        ITestFileSystemOperationsWithThreads.assertTrue((boolean)mockFs.exists(sourceFolder));
        String content = this.logs.getOutput();
        this.assertInLog(content, "Using thread pool for Rename operation with threads");
        this.assertInLog(content, "Encountered Exception for Rename operation for file " + path);
        this.assertInLog(content, "Terminating execution of Rename operation now as some other thread already got exception or operation failed");
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }
}

