/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Test;

public class ITestAzureBlobFileSystemFileStatus
extends AbstractAbfsIntegrationTest {
    private static final String DEFAULT_FILE_PERMISSION_VALUE = "640";
    private static final String DEFAULT_DIR_PERMISSION_VALUE = "750";
    private static final String DEFAULT_UMASK_VALUE = "027";
    private static final String FULL_PERMISSION = "777";
    private static final String TEST_FILE = "testFile";
    private static final String TEST_FOLDER = "testDir";

    @Test
    public void testEnsureStatusWorksForRoot() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path root = new Path("/");
        FileStatus[] rootls = fs.listStatus(root);
        ITestAzureBlobFileSystemFileStatus.assertEquals((String)"root listing", (long)0L, (long)rootls.length);
    }

    @Test
    public void testFileStatusPermissionsAndOwnerAndGroup() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.getConf().set("fs.permissions.umask-mode", DEFAULT_UMASK_VALUE);
        Path testFile = this.path(TEST_FILE);
        this.touch(testFile);
        this.validateStatus(fs, testFile, false);
    }

    private FileStatus validateStatus(AzureBlobFileSystem fs, Path name, boolean isDir) throws IOException {
        FileStatus fileStatus = fs.getFileStatus(name);
        String errorInStatus = "error in " + fileStatus + " from " + fs;
        if (!this.getIsNamespaceEnabled(fs)) {
            ITestAzureBlobFileSystemFileStatus.assertEquals((String)(errorInStatus + ": owner"), (Object)fs.getOwnerUser(), (Object)fileStatus.getOwner());
            ITestAzureBlobFileSystemFileStatus.assertEquals((String)(errorInStatus + ": group"), (Object)fs.getOwnerUserPrimaryGroup(), (Object)fileStatus.getGroup());
            ITestAzureBlobFileSystemFileStatus.assertEquals((Object)new FsPermission(FULL_PERMISSION), (Object)fileStatus.getPermission());
        } else if (isDir) {
            ITestAzureBlobFileSystemFileStatus.assertEquals((String)(errorInStatus + ": permission"), (Object)new FsPermission(DEFAULT_DIR_PERMISSION_VALUE), (Object)fileStatus.getPermission());
        } else {
            ITestAzureBlobFileSystemFileStatus.assertEquals((String)(errorInStatus + ": permission"), (Object)new FsPermission(DEFAULT_FILE_PERMISSION_VALUE), (Object)fileStatus.getPermission());
        }
        return fileStatus;
    }

    @Test
    public void testFolderStatusPermissionsAndOwnerAndGroup() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.getConf().set("fs.permissions.umask-mode", DEFAULT_UMASK_VALUE);
        Path testFolder = this.path(TEST_FOLDER);
        fs.mkdirs(testFolder);
        this.validateStatus(fs, testFolder, true);
    }

    @Test
    public void testAbfsPathWithHost() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path pathWithHost1 = new Path("abfs://mycluster/abfs/file1.txt");
        Path pathwithouthost1 = new Path("/abfs/file1.txt");
        Path pathWithHost2 = new Path("abfs://mycluster/abfs/file2.txt");
        Path pathwithouthost2 = new Path("/abfs/file2.txt");
        fs.create(pathWithHost1).close();
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)pathwithouthost1);
        fs.create(pathwithouthost2).close();
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)pathWithHost2);
        FileStatus fileStatus1 = fs.getFileStatus(pathWithHost1);
        ITestAzureBlobFileSystemFileStatus.assertEquals((Object)pathwithouthost1.getName(), (Object)fileStatus1.getPath().getName());
        FileStatus fileStatus2 = fs.getFileStatus(pathwithouthost2);
        ITestAzureBlobFileSystemFileStatus.assertEquals((Object)pathWithHost2.getName(), (Object)fileStatus2.getPath().getName());
    }

    @Test
    public void testLastModifiedTime() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFilePath = this.path("childfile1.txt");
        long createStartTime = System.currentTimeMillis();
        long minCreateStartTime = createStartTime / 1000L * 1000L - 1L;
        fs.create(testFilePath).close();
        long createEndTime = System.currentTimeMillis();
        FileStatus fStat = fs.getFileStatus(testFilePath);
        long lastModifiedTime = fStat.getModificationTime();
        ITestAzureBlobFileSystemFileStatus.assertTrue((String)"lastModifiedTime should be after minCreateStartTime", (minCreateStartTime < lastModifiedTime ? 1 : 0) != 0);
        ITestAzureBlobFileSystemFileStatus.assertTrue((String)"lastModifiedTime should be before createEndTime", (createEndTime > lastModifiedTime ? 1 : 0) != 0);
    }
}

