/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.ITestAbfsInputStream;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ITestAbfsInputStreamSmallFileReads
extends ITestAbfsInputStream {
    @Test
    public void testOnlyOneServerCallIsMadeWhenTheConfIsTrue() throws Exception {
        this.testNumBackendCalls(true);
    }

    @Test
    public void testMultipleServerCallsAreMadeWhenTheConfIsFalse() throws Exception {
        this.testNumBackendCalls(false);
    }

    private void testNumBackendCalls(boolean readSmallFilesCompletely) throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem(readSmallFilesCompletely);
        for (int i = 1; i <= 4; ++i) {
            String fileName = this.methodName.getMethodName() + i;
            int fileSize = i * 0x100000;
            byte[] fileContent = this.getRandomBytesArray(fileSize);
            Path testFilePath = this.createFileWithContent((FileSystem)fs, fileName, fileContent);
            int length = 1024;
            try (FSDataInputStream iStream = fs.open(testFilePath);){
                byte[] buffer = new byte[length];
                Map<String, Long> metricMap = this.getInstrumentationMap((FileSystem)fs);
                long requestsMadeBeforeTest = metricMap.get(AbfsStatistic.CONNECTIONS_MADE.getStatName());
                iStream.seek((long)this.seekPos(SeekTo.END, fileSize, length));
                iStream.read(buffer, 0, length);
                iStream.seek((long)this.seekPos(SeekTo.MIDDLE, fileSize, length));
                iStream.read(buffer, 0, length);
                iStream.seek((long)this.seekPos(SeekTo.BEGIN, fileSize, length));
                iStream.read(buffer, 0, length);
                metricMap = this.getInstrumentationMap((FileSystem)fs);
                long requestsMadeAfterTest = metricMap.get(AbfsStatistic.CONNECTIONS_MADE.getStatName());
                if (readSmallFilesCompletely) {
                    ITestAbfsInputStreamSmallFileReads.assertEquals((long)1L, (long)(requestsMadeAfterTest - requestsMadeBeforeTest));
                    continue;
                }
                ITestAbfsInputStreamSmallFileReads.assertEquals((long)3L, (long)(requestsMadeAfterTest - requestsMadeBeforeTest));
                continue;
            }
        }
    }

    @Test
    public void testSeekToBeginingAndReadSmallFileWithConfTrue() throws Exception {
        this.testSeekAndReadWithConf(SeekTo.BEGIN, 2, 4, true);
    }

    @Test
    public void testSeekToBeginingAndReadSmallFileWithConfFalse() throws Exception {
        this.testSeekAndReadWithConf(SeekTo.BEGIN, 2, 4, false);
    }

    @Test
    public void testSeekToBeginingAndReadBigFileWithConfTrue() throws Exception {
        this.testSeekAndReadWithConf(SeekTo.BEGIN, 5, 6, true);
    }

    @Test
    public void testSeekToBeginingAndReadBigFileWithConfFalse() throws Exception {
        this.testSeekAndReadWithConf(SeekTo.BEGIN, 5, 6, false);
    }

    @Test
    public void testSeekToEndAndReadSmallFileWithConfTrue() throws Exception {
        this.testSeekAndReadWithConf(SeekTo.END, 2, 4, true);
    }

    @Test
    public void testSeekToEndAndReadSmallFileWithConfFalse() throws Exception {
        this.testSeekAndReadWithConf(SeekTo.END, 2, 4, false);
    }

    @Test
    public void testSeekToEndAndReadBigFileWithConfTrue() throws Exception {
        this.testSeekAndReadWithConf(SeekTo.END, 5, 6, true);
    }

    @Test
    public void testSeekToEndAndReaBigFiledWithConfFalse() throws Exception {
        this.testSeekAndReadWithConf(SeekTo.END, 5, 6, false);
    }

    @Test
    public void testSeekToMiddleAndReadSmallFileWithConfTrue() throws Exception {
        this.testSeekAndReadWithConf(SeekTo.MIDDLE, 2, 4, true);
    }

    @Test
    public void testSeekToMiddleAndReadSmallFileWithConfFalse() throws Exception {
        this.testSeekAndReadWithConf(SeekTo.MIDDLE, 2, 4, false);
    }

    @Test
    public void testSeekToMiddleAndReaBigFileWithConfTrue() throws Exception {
        this.testSeekAndReadWithConf(SeekTo.MIDDLE, 5, 6, true);
    }

    @Test
    public void testSeekToMiddleAndReadBigFileWithConfFalse() throws Exception {
        this.testSeekAndReadWithConf(SeekTo.MIDDLE, 5, 6, false);
    }

    private void testSeekAndReadWithConf(SeekTo seekTo, int startFileSizeInMB, int endFileSizeInMB, boolean readSmallFilesCompletely) throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem(readSmallFilesCompletely);
        for (int i = startFileSizeInMB; i <= endFileSizeInMB; ++i) {
            String fileName = this.methodName.getMethodName() + i;
            int fileSize = i * 0x100000;
            byte[] fileContent = this.getRandomBytesArray(fileSize);
            Path testFilePath = this.createFileWithContent((FileSystem)fs, fileName, fileContent);
            int length = 1024;
            int seekPos = this.seekPos(seekTo, fileSize, length);
            this.seekReadAndTest((FileSystem)fs, testFilePath, seekPos, length, fileContent);
        }
    }

    private int seekPos(SeekTo seekTo, int fileSize, int length) {
        if (seekTo == SeekTo.BEGIN) {
            return 0;
        }
        if (seekTo == SeekTo.END) {
            return fileSize - length;
        }
        return fileSize / 2;
    }

    private void seekReadAndTest(FileSystem fs, Path testFilePath, int seekPos, int length, byte[] fileContent) throws IOException, NoSuchFieldException, IllegalAccessException {
        AbfsConfiguration conf = this.getAbfsStore(fs).getAbfsConfiguration();
        try (FSDataInputStream iStream = fs.open(testFilePath);){
            int expectedBCursor;
            int expectedLimit;
            int expectedFCursor;
            boolean smallFile;
            this.seek(iStream, seekPos);
            byte[] buffer = new byte[length];
            int bytesRead = iStream.read(buffer, 0, length);
            ITestAbfsInputStreamSmallFileReads.assertEquals((long)bytesRead, (long)length);
            this.assertContentReadCorrectly(fileContent, seekPos, length, buffer);
            AbfsInputStream abfsInputStream = (AbfsInputStream)iStream.getWrappedStream();
            int readBufferSize = conf.getReadBufferSize();
            int fileContentLength = fileContent.length;
            boolean bl = smallFile = fileContentLength <= readBufferSize;
            if (conf.readSmallFilesCompletely() && smallFile) {
                this.assertBuffersAreEqual(fileContent, abfsInputStream.getBuffer(), conf);
                expectedFCursor = fileContentLength;
                expectedLimit = fileContentLength;
                expectedBCursor = seekPos + length;
            } else {
                if (seekPos == 0) {
                    this.assertBuffersAreEqual(fileContent, abfsInputStream.getBuffer(), conf);
                } else {
                    this.assertBuffersAreNotEqual(fileContent, abfsInputStream.getBuffer(), conf);
                }
                expectedBCursor = length;
                expectedFCursor = fileContentLength < seekPos + readBufferSize ? fileContentLength : seekPos + readBufferSize;
                expectedLimit = fileContentLength < seekPos + readBufferSize ? fileContentLength - seekPos : readBufferSize;
            }
            ITestAbfsInputStreamSmallFileReads.assertEquals((long)expectedFCursor, (long)abfsInputStream.getFCursor());
            ITestAbfsInputStreamSmallFileReads.assertEquals((long)expectedFCursor, (long)abfsInputStream.getFCursorAfterLastRead());
            ITestAbfsInputStreamSmallFileReads.assertEquals((long)expectedBCursor, (long)abfsInputStream.getBCursor());
            ITestAbfsInputStreamSmallFileReads.assertEquals((long)expectedLimit, (long)abfsInputStream.getLimit());
        }
    }

    @Test
    public void testPartialReadWithNoData() throws Exception {
        for (int i = 2; i <= 4; ++i) {
            int fileSize = i * 0x100000;
            AzureBlobFileSystem fs = this.getFileSystem(true);
            String fileName = this.methodName.getMethodName() + i;
            byte[] fileContent = this.getRandomBytesArray(fileSize);
            Path testFilePath = this.createFileWithContent((FileSystem)fs, fileName, fileContent);
            this.partialReadWithNoData((FileSystem)fs, testFilePath, fileSize / 2, fileSize / 4, fileContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partialReadWithNoData(FileSystem fs, Path testFilePath, int seekPos, int length, byte[] fileContent) throws IOException {
        try (FSDataInputStream iStream = fs.open(testFilePath);){
            AbfsInputStream abfsInputStream = (AbfsInputStream)iStream.getWrappedStream();
            abfsInputStream = (AbfsInputStream)Mockito.spy((Object)abfsInputStream);
            ((AbfsInputStream)Mockito.doReturn((Object)10).doReturn((Object)10).doCallRealMethod().when((Object)abfsInputStream)).readRemote(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
            iStream = new FSDataInputStream((InputStream)abfsInputStream);
            this.seek(iStream, seekPos);
            byte[] buffer = new byte[length];
            int bytesRead = iStream.read(buffer, 0, length);
            ITestAbfsInputStreamSmallFileReads.assertEquals((long)bytesRead, (long)length);
            this.assertContentReadCorrectly(fileContent, seekPos, length, buffer);
            ITestAbfsInputStreamSmallFileReads.assertEquals((long)fileContent.length, (long)abfsInputStream.getFCursor());
            ITestAbfsInputStreamSmallFileReads.assertEquals((long)fileContent.length, (long)abfsInputStream.getFCursorAfterLastRead());
            ITestAbfsInputStreamSmallFileReads.assertEquals((long)length, (long)abfsInputStream.getBCursor());
            ITestAbfsInputStreamSmallFileReads.assertTrue((abfsInputStream.getLimit() >= (long)length ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPartialReadWithSomeData() throws Exception {
        for (int i = 2; i <= 4; ++i) {
            int fileSize = i * 0x100000;
            AzureBlobFileSystem fs = this.getFileSystem(true);
            String fileName = this.methodName.getMethodName() + i;
            byte[] fileContent = this.getRandomBytesArray(fileSize);
            Path testFilePath = this.createFileWithContent((FileSystem)fs, fileName, fileContent);
            this.partialReadWithSomeData((FileSystem)fs, testFilePath, fileSize / 2, fileSize / 4, fileContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partialReadWithSomeData(FileSystem fs, Path testFilePath, int seekPos, int length, byte[] fileContent) throws IOException, NoSuchFieldException, IllegalAccessException {
        try (FSDataInputStream iStream = fs.open(testFilePath);){
            AbfsInputStream abfsInputStream = (AbfsInputStream)iStream.getWrappedStream();
            abfsInputStream = (AbfsInputStream)Mockito.spy((Object)abfsInputStream);
            int someDataLength = 10;
            int secondReturnSize = seekPos - 10 + someDataLength;
            ((AbfsInputStream)Mockito.doReturn((Object)10).doReturn((Object)secondReturnSize).doCallRealMethod().when((Object)abfsInputStream)).readRemote(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
            iStream = new FSDataInputStream((InputStream)abfsInputStream);
            this.seek(iStream, seekPos);
            byte[] buffer = new byte[length];
            int bytesRead = iStream.read(buffer, 0, length);
            ITestAbfsInputStreamSmallFileReads.assertEquals((long)length, (long)bytesRead);
            ITestAbfsInputStreamSmallFileReads.assertTrue((abfsInputStream.getFCursor() > (long)(seekPos + length) ? 1 : 0) != 0);
            ITestAbfsInputStreamSmallFileReads.assertTrue((abfsInputStream.getFCursorAfterLastRead() > (long)(seekPos + length) ? 1 : 0) != 0);
            ITestAbfsInputStreamSmallFileReads.assertEquals((long)(length - someDataLength), (long)abfsInputStream.getBCursor());
            ITestAbfsInputStreamSmallFileReads.assertTrue((abfsInputStream.getLimit() > (long)(length - someDataLength) ? 1 : 0) != 0);
        }
    }

    private static enum SeekTo {
        BEGIN,
        MIDDLE,
        END;

    }
}

