/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.ITestAbfsInputStream;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ITestAbfsInputStreamReadFooter
extends ITestAbfsInputStream {
    private static final int TEN = 10;
    private static final int TWENTY = 20;

    @Test
    public void testOnlyOneServerCallIsMadeWhenTheConfIsTrue() throws Exception {
        this.testNumBackendCalls(true);
    }

    @Test
    public void testMultipleServerCallsAreMadeWhenTheConfIsFalse() throws Exception {
        this.testNumBackendCalls(false);
    }

    private void testNumBackendCalls(boolean optimizeFooterRead) throws Exception {
        for (int i = 1; i <= 4; ++i) {
            int fileSize = i * 0x100000;
            AzureBlobFileSystem fs = this.getFileSystem(optimizeFooterRead, fileSize);
            String fileName = this.methodName.getMethodName() + i;
            byte[] fileContent = this.getRandomBytesArray(fileSize);
            Path testFilePath = this.createFileWithContent((FileSystem)fs, fileName, fileContent);
            int length = 16384;
            try (FSDataInputStream iStream = fs.open(testFilePath);){
                byte[] buffer = new byte[length];
                Map<String, Long> metricMap = this.getInstrumentationMap((FileSystem)fs);
                long requestsMadeBeforeTest = metricMap.get(AbfsStatistic.CONNECTIONS_MADE.getStatName());
                iStream.seek((long)(fileSize - 8));
                iStream.read(buffer, 0, length);
                iStream.seek((long)(fileSize - 10240));
                iStream.read(buffer, 0, length);
                iStream.seek((long)(fileSize - 20480));
                iStream.read(buffer, 0, length);
                metricMap = this.getInstrumentationMap((FileSystem)fs);
                long requestsMadeAfterTest = metricMap.get(AbfsStatistic.CONNECTIONS_MADE.getStatName());
                if (optimizeFooterRead) {
                    ITestAbfsInputStreamReadFooter.assertEquals((long)1L, (long)(requestsMadeAfterTest - requestsMadeBeforeTest));
                    continue;
                }
                ITestAbfsInputStreamReadFooter.assertEquals((long)3L, (long)(requestsMadeAfterTest - requestsMadeBeforeTest));
                continue;
            }
        }
    }

    @Test
    public void testSeekToBeginAndReadWithConfTrue() throws Exception {
        this.testSeekAndReadWithConf(true, SeekTo.BEGIN);
    }

    @Test
    public void testSeekToBeginAndReadWithConfFalse() throws Exception {
        this.testSeekAndReadWithConf(false, SeekTo.BEGIN);
    }

    @Test
    public void testSeekToBeforeFooterAndReadWithConfTrue() throws Exception {
        this.testSeekAndReadWithConf(true, SeekTo.BEFORE_FOOTER_START);
    }

    @Test
    public void testSeekToBeforeFooterAndReadWithConfFalse() throws Exception {
        this.testSeekAndReadWithConf(false, SeekTo.BEFORE_FOOTER_START);
    }

    @Test
    public void testSeekToFooterAndReadWithConfTrue() throws Exception {
        this.testSeekAndReadWithConf(true, SeekTo.AT_FOOTER_START);
    }

    @Test
    public void testSeekToFooterAndReadWithConfFalse() throws Exception {
        this.testSeekAndReadWithConf(false, SeekTo.AT_FOOTER_START);
    }

    @Test
    public void testSeekToAfterFooterAndReadWithConfTrue() throws Exception {
        this.testSeekAndReadWithConf(true, SeekTo.AFTER_FOOTER_START);
    }

    @Test
    public void testSeekToToAfterFooterAndReadWithConfFalse() throws Exception {
        this.testSeekAndReadWithConf(false, SeekTo.AFTER_FOOTER_START);
    }

    @Test
    public void testSeekToEndAndReadWithConfTrue() throws Exception {
        this.testSeekAndReadWithConf(true, SeekTo.END);
    }

    @Test
    public void testSeekToEndAndReadWithConfFalse() throws Exception {
        this.testSeekAndReadWithConf(false, SeekTo.END);
    }

    private void testSeekAndReadWithConf(boolean optimizeFooterRead, SeekTo seekTo) throws Exception {
        for (int i = 2; i <= 6; ++i) {
            int fileSize = i * 0x100000;
            AzureBlobFileSystem fs = this.getFileSystem(optimizeFooterRead, fileSize);
            String fileName = this.methodName.getMethodName() + i;
            byte[] fileContent = this.getRandomBytesArray(fileSize);
            Path testFilePath = this.createFileWithContent((FileSystem)fs, fileName, fileContent);
            this.seekReadAndTest((FileSystem)fs, testFilePath, this.seekPos(seekTo, fileSize), 100, fileContent);
        }
    }

    private int seekPos(SeekTo seekTo, int fileSize) {
        if (seekTo == SeekTo.BEGIN) {
            return 0;
        }
        if (seekTo == SeekTo.BEFORE_FOOTER_START) {
            return fileSize - 16384 - 1;
        }
        if (seekTo == SeekTo.AT_FOOTER_START) {
            return fileSize - 16384;
        }
        if (seekTo == SeekTo.END) {
            return fileSize - 1;
        }
        return fileSize - 16384 + 1;
    }

    private void seekReadAndTest(FileSystem fs, Path testFilePath, int seekPos, int length, byte[] fileContent) throws IOException, NoSuchFieldException, IllegalAccessException {
        AbfsConfiguration conf = this.getAbfsStore(fs).getAbfsConfiguration();
        long actualContentLength = fileContent.length;
        try (FSDataInputStream iStream = fs.open(testFilePath);){
            long expectedFCursor;
            long expectedBCurson;
            long expectedLimit;
            AbfsInputStream abfsInputStream = (AbfsInputStream)iStream.getWrappedStream();
            long bufferSize = abfsInputStream.getBufferSize();
            this.seek(iStream, seekPos);
            byte[] buffer = new byte[length];
            long bytesRead = iStream.read(buffer, 0, length);
            long footerStart = Math.max(0L, actualContentLength - 16384L);
            boolean optimizationOn = conf.optimizeFooterRead() && (long)seekPos >= footerStart;
            long actualLength = length;
            if ((long)(seekPos + length) > actualContentLength) {
                long delta = (long)(seekPos + length) - actualContentLength;
                actualLength = (long)length - delta;
            }
            if (optimizationOn) {
                if (actualContentLength <= bufferSize) {
                    expectedLimit = actualContentLength;
                    expectedBCurson = (long)seekPos + actualLength;
                } else {
                    expectedLimit = bufferSize;
                    long lastBlockStart = Math.max(0L, actualContentLength - bufferSize);
                    expectedBCurson = (long)seekPos - lastBlockStart + actualLength;
                }
                expectedFCursor = actualContentLength;
            } else {
                if ((long)seekPos + bufferSize < actualContentLength) {
                    expectedLimit = bufferSize;
                    expectedFCursor = bufferSize;
                } else {
                    expectedLimit = actualContentLength - (long)seekPos;
                    expectedFCursor = Math.min((long)seekPos + bufferSize, actualContentLength);
                }
                expectedBCurson = actualLength;
            }
            ITestAbfsInputStreamReadFooter.assertEquals((long)expectedFCursor, (long)abfsInputStream.getFCursor());
            ITestAbfsInputStreamReadFooter.assertEquals((long)expectedFCursor, (long)abfsInputStream.getFCursorAfterLastRead());
            ITestAbfsInputStreamReadFooter.assertEquals((long)expectedLimit, (long)abfsInputStream.getLimit());
            ITestAbfsInputStreamReadFooter.assertEquals((long)expectedBCurson, (long)abfsInputStream.getBCursor());
            ITestAbfsInputStreamReadFooter.assertEquals((long)actualLength, (long)bytesRead);
            this.assertContentReadCorrectly(fileContent, seekPos, (int)actualLength, buffer);
            int from = seekPos;
            if (optimizationOn) {
                from = (int)Math.max(0L, actualContentLength - bufferSize);
            }
            this.assertContentReadCorrectly(fileContent, from, (int)abfsInputStream.getLimit(), abfsInputStream.getBuffer());
        }
    }

    @Test
    public void testPartialReadWithNoData() throws Exception {
        for (int i = 2; i <= 6; ++i) {
            int fileSize = i * 0x100000;
            AzureBlobFileSystem fs = this.getFileSystem(true, fileSize);
            String fileName = this.methodName.getMethodName() + i;
            byte[] fileContent = this.getRandomBytesArray(fileSize);
            Path testFilePath = this.createFileWithContent((FileSystem)fs, fileName, fileContent);
            this.testPartialReadWithNoData((FileSystem)fs, testFilePath, fileSize - 16384, 16384, fileContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPartialReadWithNoData(FileSystem fs, Path testFilePath, int seekPos, int length, byte[] fileContent) throws IOException, NoSuchFieldException, IllegalAccessException {
        try (FSDataInputStream iStream = fs.open(testFilePath);){
            AbfsInputStream abfsInputStream = (AbfsInputStream)iStream.getWrappedStream();
            abfsInputStream = (AbfsInputStream)Mockito.spy((Object)abfsInputStream);
            ((AbfsInputStream)Mockito.doReturn((Object)10).doReturn((Object)10).doCallRealMethod().when((Object)abfsInputStream)).readRemote(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
            iStream = new FSDataInputStream((InputStream)abfsInputStream);
            this.seek(iStream, seekPos);
            byte[] buffer = new byte[length];
            int bytesRead = iStream.read(buffer, 0, length);
            ITestAbfsInputStreamReadFooter.assertEquals((long)length, (long)bytesRead);
            this.assertContentReadCorrectly(fileContent, seekPos, length, buffer);
            ITestAbfsInputStreamReadFooter.assertEquals((long)fileContent.length, (long)abfsInputStream.getFCursor());
            ITestAbfsInputStreamReadFooter.assertEquals((long)length, (long)abfsInputStream.getBCursor());
            ITestAbfsInputStreamReadFooter.assertTrue((abfsInputStream.getLimit() >= (long)length ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPartialReadWithSomeDat() throws Exception {
        for (int i = 3; i <= 6; ++i) {
            int fileSize = i * 0x100000;
            AzureBlobFileSystem fs = this.getFileSystem(true, fileSize);
            String fileName = this.methodName.getMethodName() + i;
            byte[] fileContent = this.getRandomBytesArray(fileSize);
            Path testFilePath = this.createFileWithContent((FileSystem)fs, fileName, fileContent);
            this.testPartialReadWithSomeDat((FileSystem)fs, testFilePath, fileSize - 16384, 16384, fileContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPartialReadWithSomeDat(FileSystem fs, Path testFilePath, int seekPos, int length, byte[] fileContent) throws IOException, NoSuchFieldException, IllegalAccessException {
        try (FSDataInputStream iStream = fs.open(testFilePath);){
            AbfsInputStream abfsInputStream = (AbfsInputStream)iStream.getWrappedStream();
            abfsInputStream = (AbfsInputStream)Mockito.spy((Object)abfsInputStream);
            int someDataLength = 2;
            int secondReturnSize = Math.min(fileContent.length, abfsInputStream.getBufferSize()) - 10 - someDataLength;
            ((AbfsInputStream)Mockito.doReturn((Object)10).doReturn((Object)secondReturnSize).doCallRealMethod().when((Object)abfsInputStream)).readRemote(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
            iStream = new FSDataInputStream((InputStream)abfsInputStream);
            this.seek(iStream, seekPos);
            byte[] buffer = new byte[length];
            int bytesRead = iStream.read(buffer, 0, length);
            ITestAbfsInputStreamReadFooter.assertEquals((long)length, (long)bytesRead);
            ITestAbfsInputStreamReadFooter.assertEquals((long)fileContent.length, (long)abfsInputStream.getFCursor());
            ITestAbfsInputStreamReadFooter.assertEquals((long)someDataLength, (long)abfsInputStream.getBCursor());
            ITestAbfsInputStreamReadFooter.assertEquals((long)someDataLength, (long)abfsInputStream.getLimit());
        }
    }

    private AzureBlobFileSystem getFileSystem(boolean optimizeFooterRead, int fileSize) throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.getAbfsStore(fs).getAbfsConfiguration().setOptimizeFooterRead(optimizeFooterRead);
        if (fileSize <= this.getAbfsStore(fs).getAbfsConfiguration().getReadBufferSize()) {
            this.getAbfsStore(fs).getAbfsConfiguration().setReadSmallFilesCompletely(false);
        }
        return fs;
    }

    private static enum SeekTo {
        BEGIN,
        AT_FOOTER_START,
        BEFORE_FOOTER_START,
        AFTER_FOOTER_START,
        END;

    }
}

