/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.commons.codec.Charsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.contracts.annotations.ConfigurationValidationAnnotations;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.KeyProviderException;
import org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestAbfsConfigurationFieldsValidation {
    private AbfsConfiguration abfsConfiguration;
    private static final String INT_KEY = "intKey";
    private static final String LONG_KEY = "longKey";
    private static final String STRING_KEY = "stringKey";
    private static final String BASE64_KEY = "base64Key";
    private static final String BOOLEAN_KEY = "booleanKey";
    private static final int DEFAULT_INT = 0x400000;
    private static final int DEFAULT_LONG = 0x400000;
    private static final int TEST_INT = 1234565;
    private static final int TEST_LONG = 0x400000;
    private final String accountName;
    private final String encodedString = Base64.encode((byte[])"base64Value".getBytes(Charsets.UTF_8));
    private final String encodedAccountKey = Base64.encode((byte[])"someAccountKey".getBytes(Charsets.UTF_8));
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="intKey", MinValue=-2147483648, MaxValue=0x7FFFFFFF, DefaultValue=0x400000)
    private int intField;
    @ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation(ConfigurationKey="longKey", MinValue=-9223372036854775808L, MaxValue=0x7FFFFFFFFFFFFFFFL, DefaultValue=0x400000L)
    private int longField;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="stringKey", DefaultValue="default")
    private String stringField;
    @ConfigurationValidationAnnotations.Base64StringConfigurationValidatorAnnotation(ConfigurationKey="base64Key", DefaultValue="base64")
    private String base64Field;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="booleanKey", DefaultValue=false)
    private boolean boolField;

    public TestAbfsConfigurationFieldsValidation() throws Exception {
        this.accountName = "testaccount1.blob.core.windows.net";
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        configuration.set(INT_KEY, "1234565");
        configuration.set(LONG_KEY, "4194304");
        configuration.set(STRING_KEY, "stringValue");
        configuration.set(BASE64_KEY, this.encodedString);
        configuration.set(BOOLEAN_KEY, "true");
        configuration.set("fs.azure.account.key." + this.accountName, this.encodedAccountKey);
        this.abfsConfiguration = new AbfsConfiguration(configuration, this.accountName);
    }

    @Test
    public void testValidateFunctionsInConfigServiceImpl() throws Exception {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation.class)) {
                Assert.assertEquals((long)1234565L, (long)this.abfsConfiguration.validateInt(field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation.class)) {
                Assert.assertEquals((long)0x400000L, (long)this.abfsConfiguration.validateLong(field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation.class)) {
                Assert.assertEquals((Object)"stringValue", (Object)this.abfsConfiguration.validateString(field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.Base64StringConfigurationValidatorAnnotation.class)) {
                Assert.assertEquals((Object)this.encodedString, (Object)this.abfsConfiguration.validateBase64String(field));
                continue;
            }
            if (!field.isAnnotationPresent(ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation.class)) continue;
            Assert.assertEquals((Object)true, (Object)this.abfsConfiguration.validateBoolean(field));
        }
    }

    @Test
    public void testConfigServiceImplAnnotatedFieldsInitialized() throws Exception {
        Assert.assertEquals((long)0x800000L, (long)this.abfsConfiguration.getWriteBufferSize());
        Assert.assertEquals((long)0x400000L, (long)this.abfsConfiguration.getReadBufferSize());
        Assert.assertEquals((long)3000L, (long)this.abfsConfiguration.getMinBackoffIntervalMilliseconds());
        Assert.assertEquals((long)30000L, (long)this.abfsConfiguration.getMaxBackoffIntervalMilliseconds());
        Assert.assertEquals((long)3000L, (long)this.abfsConfiguration.getBackoffIntervalMilliseconds());
        Assert.assertEquals((long)30L, (long)this.abfsConfiguration.getMaxIoRetries());
        Assert.assertEquals((long)0x10000000L, (long)this.abfsConfiguration.getAzureBlockSize());
        Assert.assertEquals((Object)"localhost", (Object)this.abfsConfiguration.getAzureBlockLocationHost());
        Assert.assertEquals((long)65536L, (long)this.abfsConfiguration.getReadAheadRange());
    }

    @Test
    public void testConfigBlockSizeInitialized() throws Exception {
        Assert.assertEquals((long)0x10000000L, (long)this.abfsConfiguration.getAzureBlockSize());
    }

    @Test
    public void testGetAccountKey() throws Exception {
        String accountKey = this.abfsConfiguration.getStorageAccountKey();
        Assert.assertEquals((Object)this.encodedAccountKey, (Object)accountKey);
    }

    @Test(expected=KeyProviderException.class)
    public void testGetAccountKeyWithNonExistingAccountName() throws Exception {
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        configuration.unset("fs.azure.account.key");
        AbfsConfiguration abfsConfig = new AbfsConfiguration(configuration, "bogusAccountName");
        abfsConfig.getStorageAccountKey();
    }

    @Test
    public void testSSLSocketFactoryConfiguration() throws InvalidConfigurationValueException, IllegalAccessException, IOException {
        Assert.assertEquals((Object)DelegatingSSLSocketFactory.SSLChannelMode.Default, (Object)this.abfsConfiguration.getPreferredSSLFactoryOption());
        Assert.assertNotEquals((Object)DelegatingSSLSocketFactory.SSLChannelMode.Default_JSSE, (Object)this.abfsConfiguration.getPreferredSSLFactoryOption());
        Assert.assertNotEquals((Object)DelegatingSSLSocketFactory.SSLChannelMode.OpenSSL, (Object)this.abfsConfiguration.getPreferredSSLFactoryOption());
        Configuration configuration = new Configuration();
        configuration.setEnum("fs.azure.ssl.channel.mode", (Enum)DelegatingSSLSocketFactory.SSLChannelMode.Default_JSSE);
        AbfsConfiguration localAbfsConfiguration = new AbfsConfiguration(configuration, this.accountName);
        Assert.assertEquals((Object)DelegatingSSLSocketFactory.SSLChannelMode.Default_JSSE, (Object)localAbfsConfiguration.getPreferredSSLFactoryOption());
        configuration = new Configuration();
        configuration.setEnum("fs.azure.ssl.channel.mode", (Enum)DelegatingSSLSocketFactory.SSLChannelMode.OpenSSL);
        localAbfsConfiguration = new AbfsConfiguration(configuration, this.accountName);
        Assert.assertEquals((Object)DelegatingSSLSocketFactory.SSLChannelMode.OpenSSL, (Object)localAbfsConfiguration.getPreferredSSLFactoryOption());
    }

    public static AbfsConfiguration updateRetryConfigs(AbfsConfiguration abfsConfig, int retryCount, int backoffTime) {
        abfsConfig.setMaxIoRetries(retryCount);
        abfsConfig.setMaxBackoffIntervalMilliseconds(backoffTime);
        return abfsConfig;
    }
}

