/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.utils.AclTestHelpers;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Mockito;

public class ITestAzureBlobFileSystemCheckAccess
extends AbstractAbfsIntegrationTest {
    private static final String TEST_FOLDER_PATH = "CheckAccessTestFolder";
    private final FileSystem superUserFs = this.getFileSystem();
    private FileSystem testUserFs;
    private final String testUserGuid = this.getConfiguration().get("fs.azure.check.access.testuser.guid");
    private final boolean isCheckAccessEnabled = this.getConfiguration().isCheckAccessEnabled();
    private final boolean isHNSEnabled = this.getConfiguration().getBoolean("fs.azure.test.namespace.enabled", false);

    private void setTestUserFs() throws Exception {
        if (this.testUserFs != null) {
            return;
        }
        this.checkIfConfigIsSet("fs.azure.account.oauth2.client.endpoint." + this.getAccountName());
        Configuration conf = this.getRawConfiguration();
        this.setTestFsConf("fs.azure.account.oauth2.client.id", "fs.azure.account.test.oauth2.client.id");
        this.setTestFsConf("fs.azure.account.oauth2.client.secret", "fs.azure.account.test.oauth2.client.secret");
        conf.set("fs.azure.account.auth.type", AuthType.OAuth.name());
        conf.set("fs.azure.account.oauth.provider.type." + this.getAccountName(), ClientCredsTokenProvider.class.getName());
        conf.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", false);
        this.testUserFs = FileSystem.newInstance((Configuration)this.getRawConfiguration());
    }

    private void setTestFsConf(String fsConfKey, String testFsConfKey) {
        String confKeyWithAccountName = fsConfKey + "." + this.getAccountName();
        String confValue = this.getConfiguration().getString(testFsConfKey, "");
        this.getRawConfiguration().set(confKeyWithAccountName, confValue);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCheckAccessWithNullPath() throws IOException {
        this.superUserFs.access(null, FsAction.READ);
    }

    @Test(expected=NullPointerException.class)
    public void testCheckAccessForFileWithNullFsAction() throws Exception {
        Assume.assumeTrue((String)"fs.azure.test.namespace.enabled is false", (boolean)this.isHNSEnabled);
        Assume.assumeTrue((String)"fs.azure.enable.check.access is false", (boolean)this.isCheckAccessEnabled);
        this.superUserFs.access(new Path("test.txt"), null);
    }

    @Test(expected=FileNotFoundException.class)
    public void testCheckAccessForNonExistentFile() throws Exception {
        this.checkPrerequisites();
        Path nonExistentFile = this.setupTestDirectoryAndUserAccess("/nonExistentFile1.txt", FsAction.ALL);
        this.superUserFs.delete(nonExistentFile, true);
        this.testUserFs.access(nonExistentFile, FsAction.READ);
    }

    @Test
    public void testWhenCheckAccessConfigIsOff() throws Exception {
        Assume.assumeTrue((String)"fs.azure.test.namespace.enabled is false", (boolean)this.isHNSEnabled);
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.check.access", false);
        FileSystem fs = FileSystem.newInstance((Configuration)conf);
        Path testFilePath = this.setupTestDirectoryAndUserAccess("/test1.txt", FsAction.NONE);
        fs.access(testFilePath, FsAction.EXECUTE);
        fs.access(testFilePath, FsAction.READ);
        fs.access(testFilePath, FsAction.WRITE);
        fs.access(testFilePath, FsAction.READ_EXECUTE);
        fs.access(testFilePath, FsAction.WRITE_EXECUTE);
        fs.access(testFilePath, FsAction.READ_WRITE);
        fs.access(testFilePath, FsAction.ALL);
        testFilePath = this.setupTestDirectoryAndUserAccess("/test1.txt", FsAction.ALL);
        fs.access(testFilePath, FsAction.EXECUTE);
        fs.access(testFilePath, FsAction.READ);
        fs.access(testFilePath, FsAction.WRITE);
        fs.access(testFilePath, FsAction.READ_EXECUTE);
        fs.access(testFilePath, FsAction.WRITE_EXECUTE);
        fs.access(testFilePath, FsAction.READ_WRITE);
        fs.access(testFilePath, FsAction.ALL);
        fs.access(testFilePath, null);
        Path nonExistentFile = this.setupTestDirectoryAndUserAccess("/nonExistentFile2.txt", FsAction.NONE);
        this.superUserFs.delete(nonExistentFile, true);
        fs.access(nonExistentFile, FsAction.READ);
    }

    @Test
    public void testCheckAccessForAccountWithoutNS() throws Exception {
        Assume.assumeFalse((String)"fs.azure.test.namespace.enabled is true", (boolean)this.getConfiguration().getBoolean("fs.azure.test.namespace.enabled", true));
        Assume.assumeTrue((String)"fs.azure.enable.check.access is false", (boolean)this.isCheckAccessEnabled);
        this.checkIfConfigIsSet("fs.azure.account.test.oauth2.client.id");
        this.checkIfConfigIsSet("fs.azure.account.test.oauth2.client.secret");
        this.checkIfConfigIsSet("fs.azure.check.access.testuser.guid");
        this.setTestUserFs();
        LambdaTestUtils.intercept(AccessControlException.class, (String)"\"This request is not authorized to perform this operation using this permission.\", 403", () -> this.testUserFs.access(new Path("/"), FsAction.READ));
        AzureBlobFileSystemStore mockAbfsStore = (AzureBlobFileSystemStore)Mockito.mock(AzureBlobFileSystemStore.class);
        Mockito.when((Object)mockAbfsStore.getIsNamespaceEnabled(this.getTestTracingContext(this.getFileSystem(), false))).thenReturn((Object)true);
        Field abfsStoreField = AzureBlobFileSystem.class.getDeclaredField("abfsStore");
        abfsStoreField.setAccessible(true);
        abfsStoreField.set(this.testUserFs, mockAbfsStore);
        this.testUserFs.access(new Path("/"), FsAction.READ);
        this.superUserFs.access(new Path("/"), FsAction.READ);
    }

    @Test
    public void testFsActionNONE() throws Exception {
        this.checkPrerequisites();
        Path testFilePath = this.setupTestDirectoryAndUserAccess("/test2.txt", FsAction.NONE);
        this.assertInaccessible(testFilePath, FsAction.EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.READ);
        this.assertInaccessible(testFilePath, FsAction.WRITE);
        this.assertInaccessible(testFilePath, FsAction.READ_EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.WRITE_EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.READ_WRITE);
        this.assertInaccessible(testFilePath, FsAction.ALL);
    }

    @Test
    public void testFsActionEXECUTE() throws Exception {
        this.checkPrerequisites();
        Path testFilePath = this.setupTestDirectoryAndUserAccess("/test3.txt", FsAction.EXECUTE);
        this.assertAccessible(testFilePath, FsAction.EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.READ);
        this.assertInaccessible(testFilePath, FsAction.WRITE);
        this.assertInaccessible(testFilePath, FsAction.READ_EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.WRITE_EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.READ_WRITE);
        this.assertInaccessible(testFilePath, FsAction.ALL);
    }

    @Test
    public void testFsActionREAD() throws Exception {
        this.checkPrerequisites();
        Path testFilePath = this.setupTestDirectoryAndUserAccess("/test4.txt", FsAction.READ);
        this.assertAccessible(testFilePath, FsAction.READ);
        this.assertInaccessible(testFilePath, FsAction.EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.WRITE);
        this.assertInaccessible(testFilePath, FsAction.READ_EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.WRITE_EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.READ_WRITE);
        this.assertInaccessible(testFilePath, FsAction.ALL);
    }

    @Test
    public void testFsActionWRITE() throws Exception {
        this.checkPrerequisites();
        Path testFilePath = this.setupTestDirectoryAndUserAccess("/test5.txt", FsAction.WRITE);
        this.assertAccessible(testFilePath, FsAction.WRITE);
        this.assertInaccessible(testFilePath, FsAction.EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.READ);
        this.assertInaccessible(testFilePath, FsAction.READ_EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.WRITE_EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.READ_WRITE);
        this.assertInaccessible(testFilePath, FsAction.ALL);
    }

    @Test
    public void testFsActionREADEXECUTE() throws Exception {
        this.checkPrerequisites();
        Path testFilePath = this.setupTestDirectoryAndUserAccess("/test6.txt", FsAction.READ_EXECUTE);
        this.assertAccessible(testFilePath, FsAction.EXECUTE);
        this.assertAccessible(testFilePath, FsAction.READ);
        this.assertAccessible(testFilePath, FsAction.READ_EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.WRITE);
        this.assertInaccessible(testFilePath, FsAction.WRITE_EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.READ_WRITE);
        this.assertInaccessible(testFilePath, FsAction.ALL);
    }

    @Test
    public void testFsActionWRITEEXECUTE() throws Exception {
        this.checkPrerequisites();
        Path testFilePath = this.setupTestDirectoryAndUserAccess("/test7.txt", FsAction.WRITE_EXECUTE);
        this.assertAccessible(testFilePath, FsAction.EXECUTE);
        this.assertAccessible(testFilePath, FsAction.WRITE);
        this.assertAccessible(testFilePath, FsAction.WRITE_EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.READ);
        this.assertInaccessible(testFilePath, FsAction.READ_EXECUTE);
        this.assertInaccessible(testFilePath, FsAction.READ_WRITE);
        this.assertInaccessible(testFilePath, FsAction.ALL);
    }

    @Test
    public void testFsActionALL() throws Exception {
        this.checkPrerequisites();
        Path testFilePath = this.setupTestDirectoryAndUserAccess("/test8.txt", FsAction.ALL);
        this.assertAccessible(testFilePath, FsAction.EXECUTE);
        this.assertAccessible(testFilePath, FsAction.WRITE);
        this.assertAccessible(testFilePath, FsAction.WRITE_EXECUTE);
        this.assertAccessible(testFilePath, FsAction.READ);
        this.assertAccessible(testFilePath, FsAction.READ_EXECUTE);
        this.assertAccessible(testFilePath, FsAction.READ_WRITE);
        this.assertAccessible(testFilePath, FsAction.ALL);
    }

    private void checkPrerequisites() throws Exception {
        this.setTestUserFs();
        Assume.assumeTrue((String)"fs.azure.test.namespace.enabled is false", (boolean)this.isHNSEnabled);
        Assume.assumeTrue((String)"fs.azure.enable.check.access is false", (boolean)this.isCheckAccessEnabled);
        this.checkIfConfigIsSet("fs.azure.account.test.oauth2.client.id");
        this.checkIfConfigIsSet("fs.azure.account.test.oauth2.client.secret");
        this.checkIfConfigIsSet("fs.azure.check.access.testuser.guid");
    }

    private void checkIfConfigIsSet(String configKey) {
        AbfsConfiguration conf = this.getConfiguration();
        String value = conf.get(configKey);
        Assume.assumeTrue((String)(configKey + " config is mandatory for the test to run"), (value != null && value.trim().length() > 1 ? 1 : 0) != 0);
    }

    private void assertAccessible(Path testFilePath, FsAction fsAction) throws IOException {
        ITestAzureBlobFileSystemCheckAccess.assertTrue((String)("Should have been given access  " + fsAction + " on " + testFilePath), (boolean)this.isAccessible(this.testUserFs, testFilePath, fsAction));
    }

    private void assertInaccessible(Path testFilePath, FsAction fsAction) throws IOException {
        ITestAzureBlobFileSystemCheckAccess.assertFalse((String)("Should have been denied access  " + fsAction + " on " + testFilePath), (boolean)this.isAccessible(this.testUserFs, testFilePath, fsAction));
    }

    private void setExecuteAccessForParentDirs(Path dir) throws IOException {
        for (dir = dir.getParent(); dir != null; dir = dir.getParent()) {
            this.modifyAcl(dir, this.testUserGuid, FsAction.EXECUTE);
        }
    }

    private void modifyAcl(Path file, String uid, FsAction fsAction) throws IOException {
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, uid, fsAction)});
        this.superUserFs.modifyAclEntries(file, (List)aclSpec);
    }

    private Path setupTestDirectoryAndUserAccess(String testFileName, FsAction fsAction) throws Exception {
        Path file = new Path(TEST_FOLDER_PATH + testFileName);
        file = this.superUserFs.makeQualified(file);
        this.superUserFs.delete(file, true);
        this.superUserFs.create(file);
        this.modifyAcl(file, this.testUserGuid, fsAction);
        this.setExecuteAccessForParentDirs(file);
        return file;
    }

    private boolean isAccessible(FileSystem fs, Path path, FsAction fsAction) throws IOException {
        try {
            fs.access(path, fsAction);
        }
        catch (AccessControlException ace) {
            return false;
        }
        return true;
    }
}

