/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.live;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.live.AdlStorageConfiguration;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;

public class TestAdlFileSystemContractLive
extends FileSystemContractBaseTest {
    private FileSystem adlStore;

    @Before
    public void setUp() throws Exception {
        this.skipTestCheck();
        this.adlStore = AdlStorageConfiguration.createStorageConnector();
        if (AdlStorageConfiguration.isContractTestEnabled()) {
            this.fs = this.adlStore;
        }
        Assume.assumeNotNull((Object[])new Object[]{this.fs});
    }

    @After
    public void tearDown() throws Exception {
        if (AdlStorageConfiguration.isContractTestEnabled()) {
            this.cleanup();
        }
        super.tearDown();
    }

    private void cleanup() throws IOException {
        this.adlStore.delete(new Path("/test"), true);
    }

    private void skipTestCheck() {
        Assume.assumeTrue((boolean)AdlStorageConfiguration.isContractTestEnabled());
    }
}

