/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.common;

import java.io.IOException;
import java.util.Date;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.adl.oauth2.AzureADTokenProvider;

public class CustomMockTokenProvider
extends AzureADTokenProvider {
    private Random random;
    private long expiryTime;
    private int accessTokenRequestCount = 0;

    public void initialize(Configuration configuration) throws IOException {
        this.random = new Random();
    }

    public String getAccessToken() throws IOException {
        ++this.accessTokenRequestCount;
        return String.valueOf(this.random.nextInt());
    }

    public Date getExpiryTime() {
        Date before10Min = new Date();
        before10Min.setTime(this.expiryTime);
        return before10Min;
    }

    public void setExpiryTimeInMillisAfter(long timeInMillis) {
        this.expiryTime = System.currentTimeMillis() + timeInMillis;
    }

    public int getAccessTokenRequestCount() {
        return this.accessTokenRequestCount;
    }
}

