/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.live;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.live.AdlStorageConfiguration;
import org.junit.Assume;
import org.junit.Before;

public class TestAdlFileSystemContractLive
extends FileSystemContractBaseTest {
    private FileSystem adlStore;

    protected void setUp() throws Exception {
        this.adlStore = AdlStorageConfiguration.createStorageConnector();
        if (AdlStorageConfiguration.isContractTestEnabled()) {
            this.fs = this.adlStore;
        }
    }

    protected void tearDown() throws Exception {
        if (AdlStorageConfiguration.isContractTestEnabled()) {
            this.cleanup();
            this.adlStore = null;
            this.fs = null;
        }
    }

    private void cleanup() throws IOException {
        this.adlStore.delete(new Path("/test"), true);
    }

    protected void runTest() throws Throwable {
        if (AdlStorageConfiguration.isContractTestEnabled()) {
            super.runTest();
        }
    }

    @Before
    public void skipTestCheck() {
        Assume.assumeTrue((boolean)AdlStorageConfiguration.isContractTestEnabled());
    }
}

