/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.magic;

import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.WriteOperationHelper;
import org.apache.hadoop.fs.s3a.commit.PutTracker;
import org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.hadoop.fs.s3a.impl.PutObjectOptions;
import org.apache.hadoop.fs.s3a.statistics.PutTrackerStatistics;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MagicCommitTracker
extends PutTracker {
    public static final Logger LOG = LoggerFactory.getLogger(MagicCommitTracker.class);
    private final String originalDestKey;
    private final String pendingPartKey;
    private final Path path;
    private final WriteOperationHelper writer;
    private final String bucket;
    private static final byte[] EMPTY = new byte[0];
    private final PutTrackerStatistics trackerStatistics;

    public MagicCommitTracker(Path path, String bucket, String originalDestKey, String destKey, String pendingsetKey, WriteOperationHelper writer, PutTrackerStatistics trackerStatistics) {
        super(destKey);
        this.bucket = bucket;
        this.path = path;
        this.originalDestKey = originalDestKey;
        this.pendingPartKey = pendingsetKey;
        this.writer = writer;
        this.trackerStatistics = Objects.requireNonNull(trackerStatistics);
        LOG.info("File {} is written as magic file to path {}", (Object)path, (Object)destKey);
    }

    @Override
    public boolean initialize() throws IOException {
        return true;
    }

    @Override
    public boolean outputImmediatelyVisible() {
        return false;
    }

    @Override
    public boolean aboutToComplete(String uploadId, List<PartETag> parts, long bytesWritten, IOStatistics iostatistics) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)uploadId), (Object)("empty/null upload ID: " + uploadId));
        Preconditions.checkArgument((parts != null ? 1 : 0) != 0, (Object)"No uploaded parts list");
        Preconditions.checkArgument((!parts.isEmpty() ? 1 : 0) != 0, (Object)"No uploaded parts to save");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-hadoop-s3a-magic-data-length", Long.toString(bytesWritten));
        PutObjectRequest originalDestPut = this.writer.createPutObjectRequest(this.originalDestKey, new ByteArrayInputStream(EMPTY), 0L, new PutObjectOptions(true, null, headers));
        this.upload(originalDestPut);
        SinglePendingCommit commitData = new SinglePendingCommit();
        commitData.touch(System.currentTimeMillis());
        commitData.setDestinationKey(this.getDestKey());
        commitData.setBucket(this.bucket);
        commitData.setUri(this.path.toUri().toString());
        commitData.setUploadId(uploadId);
        commitData.setText("");
        commitData.setLength(bytesWritten);
        commitData.bindCommitData(parts);
        commitData.setIOStatistics(new IOStatisticsSnapshot(iostatistics));
        byte[] bytes = commitData.toBytes(SinglePendingCommit.serializer());
        LOG.info("Uncommitted data pending to file {}; commit metadata for {} parts in {}. size: {} byte(s)", new Object[]{this.path.toUri(), parts.size(), this.pendingPartKey, bytesWritten});
        LOG.debug("Closed MPU to {}, saved commit information to {}; data=:\n{}", new Object[]{this.path, this.pendingPartKey, commitData});
        PutObjectRequest put = this.writer.createPutObjectRequest(this.pendingPartKey, new ByteArrayInputStream(bytes), bytes.length, null);
        this.upload(put);
        return false;
    }

    private void upload(PutObjectRequest request) throws IOException {
        IOStatisticsBinding.trackDurationOfInvocation((DurationTrackerFactory)this.trackerStatistics, (String)Statistic.COMMITTER_MAGIC_MARKER_PUT.getSymbol(), () -> this.writer.uploadObject(request, PutObjectOptions.keepingDirs()));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MagicCommitTracker{");
        sb.append(", destKey=").append(this.getDestKey());
        sb.append(", pendingPartKey='").append(this.pendingPartKey).append('\'');
        sb.append(", path=").append(this.path);
        sb.append(", writer=").append(this.writer);
        sb.append('}');
        return sb.toString();
    }
}

