/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.bkjournal;

import com.google.common.base.Charsets;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.contrib.bkjournal.BKJournalProtos;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditLogLedgerMetadata {
    static final Logger LOG = LoggerFactory.getLogger(EditLogLedgerMetadata.class);
    private String zkPath;
    private final int dataLayoutVersion;
    private final long ledgerId;
    private final long firstTxId;
    private long lastTxId;
    private boolean inprogress;
    public static final Comparator COMPARATOR = new Comparator<EditLogLedgerMetadata>(){

        @Override
        public int compare(EditLogLedgerMetadata o1, EditLogLedgerMetadata o2) {
            if (o1.firstTxId < o2.firstTxId) {
                return -1;
            }
            if (o1.firstTxId == o2.firstTxId) {
                return 0;
            }
            return 1;
        }
    };

    EditLogLedgerMetadata(String zkPath, int dataLayoutVersion, long ledgerId, long firstTxId) {
        this.zkPath = zkPath;
        this.dataLayoutVersion = dataLayoutVersion;
        this.ledgerId = ledgerId;
        this.firstTxId = firstTxId;
        this.lastTxId = -12345L;
        this.inprogress = true;
    }

    EditLogLedgerMetadata(String zkPath, int dataLayoutVersion, long ledgerId, long firstTxId, long lastTxId) {
        this.zkPath = zkPath;
        this.dataLayoutVersion = dataLayoutVersion;
        this.ledgerId = ledgerId;
        this.firstTxId = firstTxId;
        this.lastTxId = lastTxId;
        this.inprogress = false;
    }

    String getZkPath() {
        return this.zkPath;
    }

    long getFirstTxId() {
        return this.firstTxId;
    }

    long getLastTxId() {
        return this.lastTxId;
    }

    long getLedgerId() {
        return this.ledgerId;
    }

    boolean isInProgress() {
        return this.inprogress;
    }

    int getDataLayoutVersion() {
        return this.dataLayoutVersion;
    }

    void finalizeLedger(long newLastTxId) {
        assert (this.lastTxId == -12345L);
        this.lastTxId = newLastTxId;
        this.inprogress = false;
    }

    static EditLogLedgerMetadata read(ZooKeeper zkc, String path) throws IOException, KeeperException.NoNodeException {
        try {
            byte[] data = zkc.getData(path, false, null);
            BKJournalProtos.EditLogLedgerProto.Builder builder = BKJournalProtos.EditLogLedgerProto.newBuilder();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading " + path + " data: " + new String(data, Charsets.UTF_8));
            }
            TextFormat.merge((CharSequence)new String(data, Charsets.UTF_8), (Message.Builder)builder);
            if (!builder.isInitialized()) {
                throw new IOException("Invalid/Incomplete data in znode");
            }
            BKJournalProtos.EditLogLedgerProto ledger = builder.build();
            int dataLayoutVersion = ledger.getDataLayoutVersion();
            long ledgerId = ledger.getLedgerId();
            long firstTxId = ledger.getFirstTxId();
            if (ledger.hasLastTxId()) {
                long lastTxId = ledger.getLastTxId();
                return new EditLogLedgerMetadata(path, dataLayoutVersion, ledgerId, firstTxId, lastTxId);
            }
            return new EditLogLedgerMetadata(path, dataLayoutVersion, ledgerId, firstTxId);
        }
        catch (KeeperException.NoNodeException nne) {
            throw nne;
        }
        catch (KeeperException ke) {
            throw new IOException("Error reading from zookeeper", ke);
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted reading from zookeeper", ie);
        }
    }

    void write(ZooKeeper zkc, String path) throws IOException, KeeperException.NodeExistsException {
        this.zkPath = path;
        BKJournalProtos.EditLogLedgerProto.Builder builder = BKJournalProtos.EditLogLedgerProto.newBuilder();
        builder.setDataLayoutVersion(this.dataLayoutVersion).setLedgerId(this.ledgerId).setFirstTxId(this.firstTxId);
        if (!this.inprogress) {
            builder.setLastTxId(this.lastTxId);
        }
        try {
            zkc.create(path, TextFormat.printToString((MessageOrBuilder)builder.build()).getBytes(Charsets.UTF_8), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            throw nee;
        }
        catch (KeeperException e) {
            throw new IOException("Error creating ledger znode", e);
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted creating ledger znode", ie);
        }
    }

    boolean verify(ZooKeeper zkc, String path) {
        try {
            EditLogLedgerMetadata other = EditLogLedgerMetadata.read(zkc, path);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Verifying " + this.toString() + " against " + other);
            }
            return other.equals(this);
        }
        catch (KeeperException e) {
            LOG.error("Couldn't verify data in " + path, (Throwable)e);
            return false;
        }
        catch (IOException ie) {
            LOG.error("Couldn't verify data in " + path, (Throwable)ie);
            return false;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof EditLogLedgerMetadata)) {
            return false;
        }
        EditLogLedgerMetadata ol = (EditLogLedgerMetadata)o;
        return this.ledgerId == ol.ledgerId && this.dataLayoutVersion == ol.dataLayoutVersion && this.firstTxId == ol.firstTxId && this.lastTxId == ol.lastTxId;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + (int)this.ledgerId;
        hash = hash * 31 + (int)this.firstTxId;
        hash = hash * 31 + (int)this.lastTxId;
        hash = hash * 31 + this.dataLayoutVersion;
        return hash;
    }

    public String toString() {
        return "[LedgerId:" + this.ledgerId + ", firstTxId:" + this.firstTxId + ", lastTxId:" + this.lastTxId + ", dataLayoutVersion:" + this.dataLayoutVersion + "]";
    }
}

