/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.jboss.netty.bootstrap;

import hidden.bkjournal.org.jboss.netty.bootstrap.Bootstrap;
import hidden.bkjournal.org.jboss.netty.channel.Channel;
import hidden.bkjournal.org.jboss.netty.channel.ChannelException;
import hidden.bkjournal.org.jboss.netty.channel.ChannelFactory;
import hidden.bkjournal.org.jboss.netty.channel.ChannelFuture;
import hidden.bkjournal.org.jboss.netty.channel.ChannelPipeline;
import hidden.bkjournal.org.jboss.netty.channel.ChannelPipelineException;
import java.net.SocketAddress;

public class ConnectionlessBootstrap
extends Bootstrap {
    public ConnectionlessBootstrap() {
    }

    public ConnectionlessBootstrap(ChannelFactory channelFactory) {
        super(channelFactory);
    }

    public Channel bind() {
        SocketAddress localAddress = (SocketAddress)this.getOption("localAddress");
        if (localAddress == null) {
            throw new IllegalStateException("localAddress option is not set.");
        }
        return this.bind(localAddress);
    }

    public Channel bind(SocketAddress localAddress) {
        ChannelPipeline pipeline;
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        try {
            pipeline = this.getPipelineFactory().getPipeline();
        }
        catch (Exception e) {
            throw new ChannelPipelineException("Failed to initialize a pipeline.", e);
        }
        Channel ch = this.getFactory().newChannel(pipeline);
        ch.getConfig().setPipelineFactory(this.getPipelineFactory());
        ch.getConfig().setOptions(this.getOptions());
        ChannelFuture future = ch.bind(localAddress);
        future.awaitUninterruptibly();
        if (!future.isSuccess()) {
            future.getChannel().close().awaitUninterruptibly();
            throw new ChannelException("Failed to bind to: " + localAddress, future.getCause());
        }
        return ch;
    }

    public ChannelFuture connect() {
        SocketAddress remoteAddress = (SocketAddress)this.getOption("remoteAddress");
        if (remoteAddress == null) {
            throw new IllegalStateException("remoteAddress option is not set.");
        }
        return this.connect(remoteAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remotedAddress");
        }
        SocketAddress localAddress = (SocketAddress)this.getOption("localAddress");
        return this.connect(remoteAddress, localAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        ChannelPipeline pipeline;
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        try {
            pipeline = this.getPipelineFactory().getPipeline();
        }
        catch (Exception e) {
            throw new ChannelPipelineException("Failed to initialize a pipeline.", e);
        }
        Channel ch = this.getFactory().newChannel(pipeline);
        ch.getConfig().setOptions(this.getOptions());
        if (localAddress != null) {
            ch.bind(localAddress);
        }
        return ch.connect(remoteAddress);
    }
}

