/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.proto;

import hidden.bkjournal.org.apache.bookkeeper.bookie.Bookie;
import hidden.bkjournal.org.apache.bookkeeper.bookie.BookieException;
import hidden.bkjournal.org.apache.bookkeeper.conf.ServerConfiguration;
import hidden.bkjournal.org.apache.bookkeeper.proto.BookieProtocol;
import hidden.bkjournal.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import hidden.bkjournal.org.apache.bookkeeper.proto.NIOServerFactory;
import hidden.bkjournal.org.apache.zookeeper.KeeperException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieServer
implements NIOServerFactory.PacketProcessor,
BookkeeperInternalCallbacks.WriteCallback {
    final ServerConfiguration conf;
    NIOServerFactory nioServerFactory;
    private volatile boolean running = false;
    Bookie bookie;
    DeathWatcher deathWatcher;
    static Logger LOG = LoggerFactory.getLogger(BookieServer.class);
    static final Options bkOpts = new Options();

    public BookieServer(ServerConfiguration conf) throws IOException, KeeperException, InterruptedException {
        this.conf = conf;
        this.bookie = new Bookie(conf);
    }

    public void start() throws IOException {
        this.nioServerFactory = new NIOServerFactory(this.conf, this);
        this.running = true;
        this.deathWatcher = new DeathWatcher(this.conf);
        this.deathWatcher.start();
    }

    public InetSocketAddress getLocalAddress() {
        try {
            return new InetSocketAddress(InetAddress.getLocalHost().getHostAddress(), this.conf.getBookiePort());
        }
        catch (UnknownHostException uhe) {
            return this.nioServerFactory.getLocalAddress();
        }
    }

    public synchronized void shutdown() throws InterruptedException {
        if (!this.running) {
            return;
        }
        this.nioServerFactory.shutdown();
        this.bookie.shutdown();
        this.running = false;
    }

    public boolean isRunning() {
        return this.bookie.isRunning() && this.nioServerFactory.isRunning() && this.running;
    }

    public boolean isBookieRunning() {
        return this.bookie.isRunning();
    }

    public boolean isNioServerRunning() {
        return this.nioServerFactory.isRunning();
    }

    public void join() throws InterruptedException {
        this.nioServerFactory.join();
    }

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("BookieServer [options]\n\tor\nBookieServer <bookie_port> <zk_servers> <journal_dir> <ledger_dir [ledger_dir]>", bkOpts);
    }

    private static void loadConfFile(ServerConfiguration conf, String confFile) throws IllegalArgumentException {
        try {
            conf.loadConf(new File(confFile).toURI().toURL());
        }
        catch (MalformedURLException e) {
            LOG.error("Could not open configuration file: " + confFile, (Throwable)e);
            throw new IllegalArgumentException();
        }
        catch (ConfigurationException e) {
            LOG.error("Malformed configuration file: " + confFile, (Throwable)e);
            throw new IllegalArgumentException();
        }
        LOG.info("Using configuration file " + confFile);
    }

    private static ServerConfiguration parseArgs(String[] args) throws IllegalArgumentException {
        try {
            BasicParser parser = new BasicParser();
            CommandLine cmdLine = parser.parse(bkOpts, args);
            if (cmdLine.hasOption('h')) {
                throw new IllegalArgumentException();
            }
            ServerConfiguration conf = new ServerConfiguration();
            String[] leftArgs = cmdLine.getArgs();
            if (cmdLine.hasOption('c')) {
                if (null != leftArgs && leftArgs.length > 0) {
                    throw new IllegalArgumentException();
                }
                String confFile = cmdLine.getOptionValue("c");
                BookieServer.loadConfFile(conf, confFile);
                return conf;
            }
            if (leftArgs.length < 4) {
                throw new IllegalArgumentException();
            }
            conf.setBookiePort(Integer.parseInt(leftArgs[0]));
            conf.setZkServers(leftArgs[1]);
            conf.setJournalDirName(leftArgs[2]);
            String[] ledgerDirNames = new String[leftArgs.length - 3];
            System.arraycopy(leftArgs, 3, ledgerDirNames, 0, ledgerDirNames.length);
            conf.setLedgerDirNames(ledgerDirNames);
            return conf;
        }
        catch (ParseException e) {
            LOG.error("Error parsing command line arguments : ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static void main(String[] args) throws IOException, KeeperException, InterruptedException {
        ServerConfiguration conf = null;
        try {
            conf = BookieServer.parseArgs(args);
        }
        catch (IllegalArgumentException iae) {
            LOG.error("Error parsing command line arguments : ", (Throwable)iae);
            System.err.println(iae.getMessage());
            BookieServer.printUsage();
            throw iae;
        }
        StringBuilder sb = new StringBuilder();
        String[] ledgerDirNames = conf.getLedgerDirNames();
        for (int i = 0; i < ledgerDirNames.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(ledgerDirNames[i]);
        }
        String hello = String.format("Hello, I'm your bookie, listening on port %1$s. ZKServers are on %2$s. Journals are in %3$s. Ledgers are stored in %4$s.", conf.getBookiePort(), conf.getZkServers(), conf.getJournalDirName(), sb);
        LOG.info(hello);
        final BookieServer bs = new BookieServer(conf);
        bs.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    bs.shutdown();
                    LOG.info("Shut down bookie server successfully");
                }
                catch (InterruptedException ie) {
                    LOG.warn("Exception when shutting down bookie server : ", (Throwable)ie);
                }
            }
        });
        LOG.info("Register shutdown hook successfully");
        bs.join();
    }

    @Override
    public void processPacket(ByteBuffer packet, NIOServerFactory.Cnxn src) {
        BookieProtocol.PacketHeader h = BookieProtocol.PacketHeader.fromInt(packet.getInt());
        long ledgerId = -1L;
        long entryId = -1L;
        byte[] masterKey = null;
        switch (h.getOpCode()) {
            case 1: {
                masterKey = new byte[20];
                packet.get(masterKey, 0, 20);
            }
            case 2: {
                ByteBuffer bb = packet.duplicate();
                ledgerId = bb.getLong();
                entryId = bb.getLong();
            }
        }
        if (h.getVersion() < 0 || h.getVersion() > 1) {
            LOG.error("Invalid protocol version, expected something between 0 & 1. got " + h.getVersion());
            src.sendResponse(this.buildResponse(103, h.getVersion(), h.getOpCode(), ledgerId, entryId));
            return;
        }
        short flags = h.getFlags();
        switch (h.getOpCode()) {
            case 1: {
                try {
                    if ((flags & 2) == 2) {
                        this.bookie.recoveryAddEntry(packet.slice(), this, src, masterKey);
                        break;
                    }
                    this.bookie.addEntry(packet.slice(), this, src, masterKey);
                }
                catch (IOException e) {
                    LOG.error("Error writing " + entryId + "@" + ledgerId, (Throwable)e);
                    src.sendResponse(this.buildResponse(101, h.getVersion(), h.getOpCode(), ledgerId, entryId));
                }
                catch (BookieException.LedgerFencedException lfe) {
                    LOG.error("Attempt to write to fenced ledger", (Throwable)lfe);
                    src.sendResponse(this.buildResponse(104, h.getVersion(), h.getOpCode(), ledgerId, entryId));
                }
                catch (BookieException e) {
                    LOG.error("Unauthorized access to ledger " + ledgerId, (Throwable)e);
                    src.sendResponse(this.buildResponse(102, h.getVersion(), h.getOpCode(), ledgerId, entryId));
                }
                break;
            }
            case 2: {
                ByteBuffer[] rsp = new ByteBuffer[2];
                LOG.debug("Received new read request: " + ledgerId + ", " + entryId);
                int errorCode = 101;
                try {
                    if ((flags & 1) == 1) {
                        LOG.warn("Ledger " + ledgerId + " fenced by " + src.getPeerName());
                        this.bookie.fenceLedger(ledgerId);
                    }
                    rsp[1] = this.bookie.readEntry(ledgerId, entryId);
                    LOG.debug("##### Read entry ##### " + rsp[1].remaining());
                    errorCode = 0;
                }
                catch (Bookie.NoLedgerException e) {
                    if (LOG.isTraceEnabled()) {
                        LOG.error("Error reading " + entryId + "@" + ledgerId, (Throwable)e);
                    }
                    errorCode = 1;
                }
                catch (Bookie.NoEntryException e) {
                    if (LOG.isTraceEnabled()) {
                        LOG.error("Error reading " + entryId + "@" + ledgerId, (Throwable)e);
                    }
                    errorCode = 2;
                }
                catch (IOException e) {
                    if (LOG.isTraceEnabled()) {
                        LOG.error("Error reading " + entryId + "@" + ledgerId, (Throwable)e);
                    }
                    errorCode = 101;
                }
                rsp[0] = this.buildResponse(errorCode, h.getVersion(), h.getOpCode(), ledgerId, entryId);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Read entry rc = " + errorCode + " for " + entryId + "@" + ledgerId);
                }
                if (rsp[1] == null) {
                    rsp[1] = ByteBuffer.allocate(16);
                    rsp[1].putLong(ledgerId);
                    rsp[1].putLong(entryId);
                    rsp[1].flip();
                }
                LOG.debug("Sending response for: " + entryId + ", " + new String(rsp[1].array()));
                src.sendResponse(rsp);
                break;
            }
            default: {
                src.sendResponse(this.buildResponse(100, h.getVersion(), h.getOpCode(), ledgerId, entryId));
            }
        }
    }

    private ByteBuffer buildResponse(int errorCode, byte version, byte opCode, long ledgerId, long entryId) {
        ByteBuffer rsp = ByteBuffer.allocate(24);
        rsp.putInt(new BookieProtocol.PacketHeader(version, opCode, 0).toInt());
        rsp.putInt(errorCode);
        rsp.putLong(ledgerId);
        rsp.putLong(entryId);
        rsp.flip();
        return rsp;
    }

    @Override
    public void writeComplete(int rc, long ledgerId, long entryId, InetSocketAddress addr, Object ctx) {
        NIOServerFactory.Cnxn src = (NIOServerFactory.Cnxn)ctx;
        ByteBuffer bb = ByteBuffer.allocate(24);
        bb.putInt(new BookieProtocol.PacketHeader(1, 1, 0).toInt());
        bb.putInt(rc);
        bb.putLong(ledgerId);
        bb.putLong(entryId);
        bb.flip();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Add entry rc = " + rc + " for " + entryId + "@" + ledgerId);
        }
        src.sendResponse(bb);
    }

    static {
        bkOpts.addOption("c", "conf", true, "Configuration for Bookie Server");
        bkOpts.addOption("h", "help", false, "Print help message");
    }

    class DeathWatcher
    extends Thread {
        final int watchInterval;

        DeathWatcher(ServerConfiguration conf) {
            this.watchInterval = conf.getDeathWatchInterval();
        }

        @Override
        public void run() {
            do {
                try {
                    Thread.sleep(this.watchInterval);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            } while (BookieServer.this.isBookieRunning() && BookieServer.this.isNioServerRunning());
            try {
                BookieServer.this.shutdown();
            }
            catch (InterruptedException ie) {
                System.exit(-1);
            }
        }
    }
}

