/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.conf;

import hidden.bkjournal.org.apache.bookkeeper.client.BookKeeper;
import hidden.bkjournal.org.apache.bookkeeper.conf.AbstractConfiguration;

public class ClientConfiguration
extends AbstractConfiguration {
    protected static final String ZK_TIMEOUT = "zkTimeout";
    protected static final String ZK_SERVERS = "zkServers";
    protected static final String THROTTLE = "throttle";
    protected static final String DIGEST_TYPE = "digestType";
    protected static final String PASSWD = "passwd";
    protected static final String CLIENT_TCP_NODELAY = "clientTcpNoDelay";

    public ClientConfiguration() {
    }

    public ClientConfiguration(AbstractConfiguration conf) {
        this.loadConf(conf);
    }

    public int getThrottleValue() {
        return this.getInt(THROTTLE, 5000);
    }

    public ClientConfiguration setThrottleValue(int throttle) {
        this.setProperty(THROTTLE, Integer.toString(throttle));
        return this;
    }

    public BookKeeper.DigestType getBookieRecoveryDigestType() {
        return BookKeeper.DigestType.valueOf(this.getString(DIGEST_TYPE, BookKeeper.DigestType.CRC32.toString()));
    }

    public ClientConfiguration setBookieRecoveryDigestType(BookKeeper.DigestType digestType) {
        this.setProperty(DIGEST_TYPE, digestType.toString());
        return this;
    }

    public byte[] getBookieRecoveryPasswd() {
        return this.getString(PASSWD, "").getBytes();
    }

    public ClientConfiguration setBookieRecoveryPasswd(byte[] passwd) {
        this.setProperty(PASSWD, new String(passwd));
        return this;
    }

    public boolean getClientTcpNoDelay() {
        return this.getBoolean(CLIENT_TCP_NODELAY, true);
    }

    public ClientConfiguration setClientTcpNoDelay(boolean noDelay) {
        this.setProperty(CLIENT_TCP_NODELAY, Boolean.toString(noDelay));
        return this;
    }

    public String getZkServers() {
        return this.getString(ZK_SERVERS, "localhost");
    }

    public ClientConfiguration setZkServers(String zkServers) {
        this.setProperty(ZK_SERVERS, zkServers);
        return this;
    }

    public int getZkTimeout() {
        return this.getInt(ZK_TIMEOUT, 10000);
    }

    public ClientConfiguration setZkTimeout(int zkTimeout) {
        this.setProperty(ZK_TIMEOUT, Integer.toString(zkTimeout));
        return this;
    }
}

