/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source.jms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.event.SimpleEvent;
import org.apache.flume.source.jms.JMSMessageConverter;

public class DefaultJMSMessageConverter
implements JMSMessageConverter {
    private final Charset charset;

    private DefaultJMSMessageConverter(String charset) {
        this.charset = Charset.forName(charset);
    }

    @Override
    public List<Event> convert(Message message) throws JMSException {
        ObjectMessage objectMessage;
        Serializable object;
        SimpleEvent event = new SimpleEvent();
        Map headers = event.getHeaders();
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = propertyNames.nextElement().toString();
            String value = message.getStringProperty(name);
            headers.put(name, value);
        }
        if (message instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)message;
            long length = bytesMessage.getBodyLength();
            if (length > 0L) {
                if (length > Integer.MAX_VALUE) {
                    throw new JMSException("Unable to process message of size " + length);
                }
                byte[] body = new byte[(int)length];
                int count = bytesMessage.readBytes(body);
                if ((long)count != length) {
                    throw new JMSException("Unable to read full message. Read " + count + " of total " + length);
                }
                event.setBody(body);
            }
        } else if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            event.setBody(textMessage.getText().getBytes(this.charset));
        } else if (message instanceof ObjectMessage && (object = (objectMessage = (ObjectMessage)message).getObject()) != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(bos);
                out.writeObject(object);
                event.setBody(bos.toByteArray());
            }
            catch (IOException e) {
                throw new FlumeException("Error serializing object", (Throwable)e);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    throw new FlumeException("Error closing ObjectOutputStream", (Throwable)e);
                }
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (IOException e) {
                    throw new FlumeException("Error closing ByteArrayOutputStream", (Throwable)e);
                }
            }
        }
        ArrayList<Event> events = new ArrayList<Event>(1);
        events.add((Event)event);
        return events;
    }

    public static class Builder
    implements JMSMessageConverter.Builder {
        @Override
        public JMSMessageConverter build(Context context) {
            return new DefaultJMSMessageConverter(context.getString("converter.charset", "UTF-8").trim());
        }
    }
}

