/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hbase;

import com.google.common.base.Charsets;
import java.util.LinkedList;
import java.util.List;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.sink.hbase.HbaseEventSerializer;
import org.apache.flume.sink.hbase.SimpleRowKeyGenerator;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;

public class SimpleHbaseEventSerializer
implements HbaseEventSerializer {
    private String rowPrefix;
    private byte[] incrementRow;
    private byte[] cf;
    private byte[] plCol;
    private byte[] incCol;
    private KeyType keyType;
    private byte[] payload;

    public void configure(Context context) {
        this.rowPrefix = context.getString("rowPrefix", "default");
        this.incrementRow = context.getString("incrementRow", "incRow").getBytes(Charsets.UTF_8);
        String suffix = context.getString("suffix", "uuid");
        String payloadColumn = context.getString("payloadColumn", "pCol");
        String incColumn = context.getString("incrementColumn", "iCol");
        if (payloadColumn != null && !payloadColumn.isEmpty()) {
            this.keyType = suffix.equals("timestamp") ? KeyType.TS : (suffix.equals("random") ? KeyType.RANDOM : (suffix.equals("nano") ? KeyType.TSNANO : KeyType.UUID));
            this.plCol = payloadColumn.getBytes(Charsets.UTF_8);
        }
        if (incColumn != null && !incColumn.isEmpty()) {
            this.incCol = incColumn.getBytes(Charsets.UTF_8);
        }
    }

    public void configure(ComponentConfiguration conf) {
    }

    @Override
    public void initialize(Event event, byte[] cf) {
        this.payload = event.getBody();
        this.cf = cf;
    }

    @Override
    public List<Row> getActions() throws FlumeException {
        LinkedList<Row> actions = new LinkedList<Row>();
        if (this.plCol != null) {
            try {
                byte[] rowKey = this.keyType == KeyType.TS ? SimpleRowKeyGenerator.getTimestampKey(this.rowPrefix) : (this.keyType == KeyType.RANDOM ? SimpleRowKeyGenerator.getRandomKey(this.rowPrefix) : (this.keyType == KeyType.TSNANO ? SimpleRowKeyGenerator.getNanoTimestampKey(this.rowPrefix) : SimpleRowKeyGenerator.getUUIDKey(this.rowPrefix)));
                Put put = new Put(rowKey);
                put.add(this.cf, this.plCol, this.payload);
                actions.add((Row)put);
            }
            catch (Exception e) {
                throw new FlumeException("Could not get row key!", (Throwable)e);
            }
        }
        return actions;
    }

    @Override
    public List<Increment> getIncrements() {
        LinkedList<Increment> incs = new LinkedList<Increment>();
        if (this.incCol != null) {
            Increment inc = new Increment(this.incrementRow);
            inc.addColumn(this.cf, this.incCol, 1L);
            incs.add(inc);
        }
        return incs;
    }

    @Override
    public void close() {
    }

    public static enum KeyType {
        UUID,
        RANDOM,
        TS,
        TSNANO;

    }
}

