/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.kafka;

import java.util.Collection;
import org.apache.flume.channel.kafka.KafkaChannel;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChannelRebalanceListener
implements ConsumerRebalanceListener {
    private static final Logger log = LoggerFactory.getLogger(ChannelRebalanceListener.class);
    private KafkaChannel.ConsumerAndRecords car;

    public ChannelRebalanceListener(KafkaChannel.ConsumerAndRecords car) {
        this.car = car;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        if (partitions.isEmpty()) {
            return;
        }
        log.info("waiting for \"in progress\" transaction to complete...");
        this.car.rebalanceLock.lock();
        try {
            log.info("\"in progress\" transaction completed, proceeding with actual revoking partitions");
            this.car.revokePartitions(partitions);
            for (TopicPartition partition : partitions) {
                log.info("topic {} - partition {} revoked.", (Object)partition.topic(), (Object)partition.partition());
            }
        }
        finally {
            log.info("partitions revoking completed.", partitions);
            this.car.rebalanceLock.unlock();
        }
    }

    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        for (TopicPartition partition : partitions) {
            log.info("topic {} - partition {} assigned.", (Object)partition.topic(), (Object)partition.partition());
        }
    }
}

