/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.MiniClusterClient;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.testutils.MiniClusterResource;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.util.TestStreamEnvironment;
import org.apache.flink.util.ExceptionUtils;

public class MiniClusterWithClientResource
extends MiniClusterResource {
    private ClusterClient<?> clusterClient;
    private RestClusterClient<MiniClusterClient.MiniClusterId> restClusterClient;
    private TestStreamEnvironment streamExecutionEnvironment;

    public MiniClusterWithClientResource(MiniClusterResourceConfiguration miniClusterResourceConfiguration) {
        super(miniClusterResourceConfiguration);
    }

    public ClusterClient<?> getClusterClient() {
        return this.clusterClient;
    }

    public RestClusterClient<?> getRestClusterClient() throws Exception {
        return this.restClusterClient;
    }

    public TestStreamEnvironment getTestStreamEnvironment() {
        return this.streamExecutionEnvironment;
    }

    public void before() throws Exception {
        super.before();
        this.clusterClient = this.createMiniClusterClient();
        this.restClusterClient = this.createRestClusterClient();
        TestStreamEnvironment.setAsContext(this.getMiniCluster(), this.getNumberSlots());
        this.streamExecutionEnvironment = new TestStreamEnvironment(this.getMiniCluster(), this.getNumberSlots());
    }

    public void after() {
        this.log.info("Finalization triggered: Cluster shutdown is going to be initiated.");
        TestStreamEnvironment.unsetAsContext();
        Exception exception = null;
        if (this.clusterClient != null) {
            try {
                this.clusterClient.close();
            }
            catch (Exception e) {
                exception = e;
            }
        }
        this.clusterClient = null;
        if (this.restClusterClient != null) {
            try {
                this.restClusterClient.close();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
        }
        this.restClusterClient = null;
        super.after();
        if (exception != null) {
            this.log.warn("Could not properly shut down the MiniClusterWithClientResource.", (Throwable)exception);
        }
    }

    private MiniClusterClient createMiniClusterClient() {
        return new MiniClusterClient((Configuration)this.getClientConfiguration(), this.getMiniCluster());
    }

    private RestClusterClient<MiniClusterClient.MiniClusterId> createRestClusterClient() throws Exception {
        return new RestClusterClient((Configuration)this.getClientConfiguration(), (Object)MiniClusterClient.MiniClusterId.INSTANCE);
    }
}

