/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.upserttest.table;

import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.upserttest.sink.UpsertTestSink;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkV2Provider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.ProjectedRowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

@Internal
class UpsertTestDynamicTableSink
implements DynamicTableSink {
    private final DataType physicalRowDataType;
    private final DataType primaryKeyDataType;
    private final int[] primaryKeyIndexes;
    private final EncodingFormat<SerializationSchema<RowData>> keyEncodingFormat;
    private final EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat;
    private final String outputFilePath;

    UpsertTestDynamicTableSink(DataType physicalRowDataType, DataType primaryKeyDataType, int[] primaryKeyIndexes, EncodingFormat<SerializationSchema<RowData>> keyEncodingFormat, EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat, String outputFilePath) {
        this.physicalRowDataType = (DataType)Preconditions.checkNotNull((Object)physicalRowDataType);
        this.primaryKeyIndexes = (int[])Preconditions.checkNotNull((Object)primaryKeyIndexes);
        this.primaryKeyDataType = (DataType)Preconditions.checkNotNull((Object)primaryKeyDataType);
        this.keyEncodingFormat = (EncodingFormat)Preconditions.checkNotNull(keyEncodingFormat);
        this.valueEncodingFormat = (EncodingFormat)Preconditions.checkNotNull(valueEncodingFormat);
        this.outputFilePath = (String)Preconditions.checkNotNull((Object)outputFilePath);
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        ChangelogMode.Builder builder = ChangelogMode.newBuilder();
        for (RowKind kind : requestedMode.getContainedKinds()) {
            if (kind == RowKind.UPDATE_BEFORE) continue;
            builder.addContainedKind(kind);
        }
        return builder.build();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        File outputFile = new File(this.outputFilePath);
        SerializationSchema<RowData> keySerialization = this.createKeySerializationSchema(context);
        SerializationSchema valueSerialization = (SerializationSchema)this.valueEncodingFormat.createRuntimeEncoder(context, this.physicalRowDataType);
        UpsertTestSink<RowData> sink = UpsertTestSink.builder().setOutputFile(outputFile).setKeySerializationSchema(keySerialization).setValueSerializationSchema((SerializationSchema<RowData>)valueSerialization).build();
        return SinkV2Provider.of(sink, (Integer)1);
    }

    public DynamicTableSink copy() {
        return new UpsertTestDynamicTableSink(this.physicalRowDataType, this.primaryKeyDataType, this.primaryKeyIndexes, this.keyEncodingFormat, this.valueEncodingFormat, this.outputFilePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertTestDynamicTableSink that = (UpsertTestDynamicTableSink)o;
        return Objects.equals(this.physicalRowDataType, that.physicalRowDataType) && Objects.equals(this.primaryKeyDataType, that.primaryKeyDataType) && Arrays.equals(this.primaryKeyIndexes, that.primaryKeyIndexes) && Objects.equals(this.keyEncodingFormat, that.keyEncodingFormat) && Objects.equals(this.valueEncodingFormat, that.valueEncodingFormat) && Objects.equals(this.outputFilePath, that.outputFilePath);
    }

    public int hashCode() {
        return 31 * Objects.hash(this.physicalRowDataType, this.primaryKeyDataType, this.keyEncodingFormat, this.valueEncodingFormat, this.outputFilePath) + Arrays.hashCode(this.primaryKeyIndexes);
    }

    public String asSummaryString() {
        return "UpsertTestSink";
    }

    private SerializationSchema<RowData> createKeySerializationSchema(DynamicTableSink.Context context) {
        SerializationSchema serializationSchema = (SerializationSchema)this.keyEncodingFormat.createRuntimeEncoder(context, this.primaryKeyDataType);
        if (this.primaryKeyIndexes.length > 0) {
            return new UpsertKeySerializationSchema((SerializationSchema<RowData>)serializationSchema, this.primaryKeyIndexes);
        }
        return serializationSchema;
    }

    private static class UpsertKeySerializationSchema
    implements SerializationSchema<RowData> {
        private final SerializationSchema<RowData> serializationSchema;
        private final int[] primaryKeyIndexes;

        private UpsertKeySerializationSchema(SerializationSchema<RowData> serializationSchema, int[] primaryKeyIndexes) {
            this.serializationSchema = serializationSchema;
            this.primaryKeyIndexes = primaryKeyIndexes;
        }

        public void open(SerializationSchema.InitializationContext context) throws Exception {
            this.serializationSchema.open(context);
        }

        public byte[] serialize(RowData element) {
            ProjectedRowData primaryKeyRowData = ProjectedRowData.from((int[])this.primaryKeyIndexes).replaceRow(element);
            return this.serializationSchema.serialize((Object)primaryKeyRowData);
        }
    }
}

